/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.bre.old;

import java.io.PrintStream;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.LongAdder;
import org.ballerinalang.bre.Context;
import org.ballerinalang.bre.bvm.CallableUnitCallback;
import org.ballerinalang.bre.old.AsyncInvocableWorkerResponseContext;
import org.ballerinalang.bre.old.WorkerExecutionContext;
import org.ballerinalang.bre.old.WorkerResponseContext;
import org.ballerinalang.bre.old.WorkerState;
import org.ballerinalang.config.ConfigRegistry;
import org.ballerinalang.model.NativeCallableUnit;
import org.ballerinalang.model.values.BError;
import org.ballerinalang.runtime.threadpool.ThreadPoolFactory;
import org.ballerinalang.util.codegen.CallableUnitInfo;

public class BLangScheduler {
    private static final String SCHEDULER_STATS_CONFIG_PROP = "b7a.runtime.scheduler.statistics";
    private static AtomicInteger workerCount = new AtomicInteger(0);
    private static Semaphore workersDoneSemaphore = new Semaphore(1);
    private static SchedulerStats schedulerStats = new SchedulerStats();
    private static boolean schedulerStatsEnabled;

    public static WorkerExecutionContext schedule(WorkerExecutionContext ctx) {
        return BLangScheduler.schedule(ctx, ctx.runInCaller);
    }

    public static void executeNow(WorkerExecutionContext ctx) {
    }

    public static void workerCountUp() {
        int count = workerCount.incrementAndGet();
        if (count == 1) {
            try {
                workersDoneSemaphore.acquire();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public static void workerCountDown() {
        int count = workerCount.decrementAndGet();
        if (count <= 0) {
            workersDoneSemaphore.release();
        }
    }

    public static WorkerExecutionContext schedule(WorkerExecutionContext ctx, boolean runInCaller) {
        BLangScheduler.workerReady(ctx);
        BLangScheduler.workerCountUp();
        if (runInCaller) {
            return ctx;
        }
        ExecutorService executor = ThreadPoolFactory.getInstance().getWorkerExecutor();
        executor.submit(new WorkerExecutor(ctx));
        return null;
    }

    public static WorkerExecutionContext resume(WorkerExecutionContext ctx) {
        return BLangScheduler.resume(ctx, false);
    }

    public static WorkerExecutionContext resume(WorkerExecutionContext ctx, boolean runInCaller) {
        if (ctx == null) {
            return null;
        }
        BLangScheduler.workerReady(ctx);
        if (runInCaller) {
            return ctx;
        }
        ThreadPoolFactory.getInstance().getWorkerExecutor().submit(new WorkerExecutor(ctx));
        return null;
    }

    public static WorkerExecutionContext resume(WorkerExecutionContext ctx, int targetIp, boolean runInCaller) {
        ctx.ip = targetIp;
        return BLangScheduler.resume(ctx, runInCaller);
    }

    public static WorkerExecutionContext errorThrown(WorkerExecutionContext ctx, BError error2) {
        ctx.setError(error2);
        if (!ctx.isRootContext()) {
            return ctx;
        }
        return null;
    }

    public static void stopWorker(WorkerExecutionContext ctx) {
        ctx.stop = true;
    }

    public static void workerDone(WorkerExecutionContext ctx) {
        schedulerStats.stateTransition(ctx, WorkerState.DONE);
        ctx.state = WorkerState.DONE;
        BLangScheduler.workerCountDown();
    }

    public static void workerReady(WorkerExecutionContext ctx) {
        schedulerStats.stateTransition(ctx, WorkerState.READY);
        ctx.state = WorkerState.READY;
    }

    public static void workerPaused(WorkerExecutionContext ctx) {
        schedulerStats.stateTransition(ctx, WorkerState.PAUSED);
        ctx.state = WorkerState.PAUSED;
    }

    public static void workerWaitForResponse(WorkerExecutionContext ctx) {
        schedulerStats.stateTransition(ctx, WorkerState.WAITING_FOR_RESPONSE);
        ctx.state = WorkerState.WAITING_FOR_RESPONSE;
    }

    public static void workerWaitForLock(WorkerExecutionContext ctx) {
        schedulerStats.stateTransition(ctx, WorkerState.WAITING_FOR_LOCK);
        ctx.state = WorkerState.WAITING_FOR_LOCK;
    }

    public static void workerRunning(WorkerExecutionContext ctx) {
        schedulerStats.stateTransition(ctx, WorkerState.RUNNING);
        ctx.state = WorkerState.RUNNING;
    }

    public static void workerExcepted(WorkerExecutionContext ctx) {
        schedulerStats.stateTransition(ctx, WorkerState.EXCEPTED);
        ctx.state = WorkerState.EXCEPTED;
        BLangScheduler.workerCountDown();
    }

    public static void waitForWorkerCompletion() {
        try {
            workersDoneSemaphore.acquire();
            workersDoneSemaphore.release();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static void dumpCallStack(WorkerExecutionContext ctx) {
        PrintStream out = System.out;
        while (ctx != null && ctx.code != null) {
            out.println(ctx.callableUnitInfo.getPkgPath() + "." + ctx.callableUnitInfo.getName() + "[worker=" + ctx.workerInfo.getWorkerName() + "][state=" + (Object)((Object)ctx.state) + "]");
            ctx = ctx.parent;
        }
    }

    public static AsyncInvocableWorkerResponseContext executeBlockingNativeAsync(NativeCallableUnit nativeCallable, Context nativeCtx, int flags) {
        CallableUnitInfo callableUnitInfo = nativeCtx.getCallableUnitInfo();
        AsyncInvocableWorkerResponseContext respCtx = new AsyncInvocableWorkerResponseContext(callableUnitInfo);
        BLangScheduler.checkAndObserveNativeAsync(nativeCtx, respCtx, callableUnitInfo, flags);
        NativeCallExecutor exec = new NativeCallExecutor(nativeCallable, nativeCtx, respCtx);
        ThreadPoolFactory.getInstance().getWorkerExecutor().submit(exec);
        return respCtx;
    }

    public static AsyncInvocableWorkerResponseContext executeNonBlockingNativeAsync(NativeCallableUnit nativeCallable, Context nativeCtx, int flags) {
        CallableUnitInfo callableUnitInfo = nativeCtx.getCallableUnitInfo();
        AsyncInvocableWorkerResponseContext respCtx = new AsyncInvocableWorkerResponseContext(callableUnitInfo);
        BLangScheduler.checkAndObserveNativeAsync(nativeCtx, respCtx, callableUnitInfo, flags);
        BLangAsyncCallableUnitCallback callback = new BLangAsyncCallableUnitCallback(respCtx, nativeCtx);
        nativeCallable.execute(nativeCtx, callback);
        return respCtx;
    }

    public static SchedulerStats getStats() {
        return schedulerStats;
    }

    private static void checkAndObserveNativeAsync(Context nativeCtx, AsyncInvocableWorkerResponseContext respCtx, CallableUnitInfo callableUnitInfo, int flags) {
    }

    static {
        String statsConfigProp = ConfigRegistry.getInstance().getAsString(SCHEDULER_STATS_CONFIG_PROP);
        if (statsConfigProp != null) {
            schedulerStatsEnabled = Boolean.parseBoolean(statsConfigProp);
        }
    }

    public static class SchedulerStats {
        private LongAdder[] stateCounts = new LongAdder[6];

        public SchedulerStats() {
            for (int i = 0; i < this.stateCounts.length; ++i) {
                this.stateCounts[i] = new LongAdder();
            }
        }

        public long getReadyWorkerCount() {
            return this.stateCounts[0].longValue();
        }

        public long getRunningWorkerCount() {
            return this.stateCounts[1].longValue();
        }

        public long getExceptedWorkerCount() {
            return this.stateCounts[2].longValue();
        }

        public long getWaitingForResponseWorkerCount() {
            return this.stateCounts[3].longValue();
        }

        public long getPausedWorkerCount() {
            return this.stateCounts[4].longValue();
        }

        public long getWaitingForLockWorkerCount() {
            return this.stateCounts[5].longValue();
        }

        public void stateTransition(WorkerExecutionContext currentCtx, WorkerState newState) {
            if (!schedulerStatsEnabled || currentCtx.isRootContext()) {
                return;
            }
            WorkerState oldState = currentCtx.state;
            if (oldState != WorkerState.CREATED) {
                this.stateCounts[oldState.ordinal()].decrement();
            }
            if (newState != WorkerState.DONE) {
                this.stateCounts[newState.ordinal()].increment();
            }
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("Worker Status:- \n");
            builder.append("\tREADY: " + this.getReadyWorkerCount() + "\n");
            builder.append("\tRUNNING: " + this.getRunningWorkerCount() + "\n");
            builder.append("\tEXCEPTED: " + this.getExceptedWorkerCount() + "\n");
            builder.append("\tWAITING FOR RESPONSE: " + this.getWaitingForResponseWorkerCount() + "\n");
            builder.append("\tPAUSED: " + this.getPausedWorkerCount() + "\n");
            builder.append("\tWAITING FOR LOCK: " + this.getWaitingForLockWorkerCount() + "\n");
            return builder.toString();
        }
    }

    public static class BLangAsyncCallableUnitCallback
    implements CallableUnitCallback {
        private WorkerResponseContext respCtx;
        private Context nativeCallCtx;

        public BLangAsyncCallableUnitCallback(WorkerResponseContext respCtx, Context nativeCallCtx) {
            this.respCtx = respCtx;
            this.nativeCallCtx = nativeCallCtx;
            BLangScheduler.workerCountUp();
        }

        @Override
        public synchronized void notifySuccess() {
        }

        @Override
        public synchronized void notifyFailure(BError error2) {
        }
    }

    private static class NativeCallExecutor
    implements Runnable {
        private NativeCallableUnit nativeCallable;
        private Context nativeCtx;
        private WorkerResponseContext respCtx;

        public NativeCallExecutor(NativeCallableUnit nativeCallable, Context nativeCtx, WorkerResponseContext respCtx) {
            this.nativeCallable = nativeCallable;
            this.nativeCtx = nativeCtx;
            this.respCtx = respCtx;
            BLangScheduler.workerCountUp();
        }

        @Override
        public void run() {
        }
    }

    private static class WorkerExecutor
    implements Runnable {
        private WorkerExecutionContext ctx;

        public WorkerExecutor(WorkerExecutionContext ctx) {
            this.ctx = ctx;
        }

        @Override
        public void run() {
        }
    }
}

