/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.bre.old;

import java.util.HashMap;
import java.util.Map;
import org.ballerinalang.bre.old.WorkerData;
import org.ballerinalang.bre.old.WorkerResponseContext;
import org.ballerinalang.bre.old.WorkerState;
import org.ballerinalang.model.values.BError;
import org.ballerinalang.util.codegen.CallableUnitInfo;
import org.ballerinalang.util.codegen.Instruction;
import org.ballerinalang.util.codegen.ProgramFile;
import org.ballerinalang.util.codegen.WorkerInfo;
import org.ballerinalang.util.codegen.cpentries.ConstantPoolEntry;
import org.ballerinalang.util.debugger.DebugContext;
import org.ballerinalang.util.transactions.TransactionLocalContext;

public class WorkerExecutionContext {
    private static final String WORKER_NAME_NATIVE = "native";
    public WorkerExecutionContext parent;
    public WorkerState state = WorkerState.CREATED;
    public Map<String, Object> globalProps;
    public Map<String, Object> localProps;
    public int ip;
    public boolean stop;
    public ProgramFile programFile;
    public ConstantPoolEntry[] constPool;
    public Instruction[] code;
    public WorkerData workerLocal;
    public WorkerData workerResult;
    public int[] retRegIndexes;
    public CallableUnitInfo callableUnitInfo;
    public WorkerInfo workerInfo;
    public WorkerResponseContext respCtx;
    public boolean runInCaller;
    private BError error;
    private DebugContext debugContext;
    private static final String FALSE = "false";
    public boolean interruptible;
    public boolean markAsCheckPointed;

    public WorkerExecutionContext(ProgramFile programFile) {
        this.programFile = programFile;
        this.globalProps = new HashMap<String, Object>();
        this.runInCaller = true;
    }

    public WorkerExecutionContext(BError error2) {
        this.error = error2;
        this.workerInfo = new WorkerInfo(0, WORKER_NAME_NATIVE);
    }

    public WorkerExecutionContext(WorkerExecutionContext parent, WorkerResponseContext respCtx, CallableUnitInfo callableUnitInfo, WorkerInfo workerInfo, WorkerData workerLocal, WorkerData workerResult, int[] retRegIndexes, boolean runInCaller) {
        this.parent = parent;
        this.respCtx = respCtx;
        this.callableUnitInfo = callableUnitInfo;
        this.workerInfo = workerInfo;
        this.programFile = callableUnitInfo.getPackageInfo().getProgramFile();
        this.constPool = callableUnitInfo.getPackageInfo().getConstPoolEntries();
        this.code = callableUnitInfo.getPackageInfo().getInstructions();
        this.workerLocal = workerLocal;
        this.workerResult = workerResult;
        this.retRegIndexes = retRegIndexes;
        this.interruptible = parent.interruptible;
        this.globalProps = parent.globalProps;
        this.ip = this.workerInfo.getCodeAttributeInfo().getCodeAddrs();
        this.runInCaller = runInCaller;
        this.initDebugger();
    }

    public WorkerExecutionContext(WorkerExecutionContext parent, WorkerResponseContext respCtx, CallableUnitInfo callableUnitInfo, WorkerInfo workerInfo, WorkerData workerLocal, boolean runInCaller) {
        this.parent = parent;
        this.respCtx = respCtx;
        this.callableUnitInfo = callableUnitInfo;
        this.workerInfo = workerInfo;
        this.programFile = callableUnitInfo.getPackageInfo().getProgramFile();
        this.constPool = callableUnitInfo.getPackageInfo().getConstPoolEntries();
        this.code = callableUnitInfo.getPackageInfo().getInstructions();
        this.workerLocal = workerLocal;
        this.globalProps = parent.globalProps;
        this.interruptible = parent.interruptible;
        this.ip = this.workerInfo.getCodeAttributeInfo().getCodeAddrs();
        this.runInCaller = runInCaller;
        this.initDebugger();
    }

    private void initDebugger() {
        if (!this.programFile.getDebugger().isDebugEnabled()) {
            return;
        }
    }

    public void setError(BError error2) {
        this.error = error2;
    }

    public BError getError() {
        return this.error;
    }

    public boolean isInTransaction() {
        return false;
    }

    public void setLocalTransactionInfo(TransactionLocalContext transactionLocalContext) {
    }

    public TransactionLocalContext getLocalTransactionInfo() {
        return null;
    }

    public boolean getGlobalTransactionEnabled() {
        return true;
    }

    public boolean isRootContext() {
        return this.code == null;
    }

    public DebugContext getDebugContext() {
        return this.debugContext;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("\n{ ID: " + this.hashCode() + "\n");
        builder.append("Parent: " + (this.parent != null ? Integer.valueOf(this.parent.hashCode()) : "N/A") + "\n");
        builder.append("Callable Unit: " + (this.callableUnitInfo != null ? this.callableUnitInfo.getName() : "N/A") + "\n");
        builder.append("Worker ID: " + (this.workerInfo != null ? this.workerInfo.getWorkerName() : "N/A") + "\n");
        builder.append("STATE: " + (Object)((Object)this.state) + "\n");
        builder.append("Run In Caller: " + this.runInCaller + "\n");
        builder.append("IP: " + this.ip + "\n");
        return builder.toString();
    }

    public boolean equals(Object rhs) {
        return this == rhs;
    }
}

