/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.channels;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.ballerinalang.bre.bvm.Strand;
import org.ballerinalang.channels.DatabaseUtils;
import org.ballerinalang.model.values.BMap;
import org.ballerinalang.model.values.BValue;

public class ChannelRegistry {
    private static ChannelRegistry channelRegistry = null;
    private Map<String, Map<String, LinkedList<PendingContext>>> channelList = new ConcurrentHashMap<String, Map<String, LinkedList<PendingContext>>>();

    private ChannelRegistry() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ChannelRegistry getInstance() {
        if (channelRegistry != null) return channelRegistry;
        Class<ChannelRegistry> clazz = ChannelRegistry.class;
        synchronized (ChannelRegistry.class) {
            if (channelRegistry != null) return channelRegistry;
            channelRegistry = new ChannelRegistry();
            // ** MonitorExit[var0] (shouldn't be in output)
            return channelRegistry;
        }
    }

    public void addWaitingContext(String channel, BValue key, Strand ctx, int regIndex) {
        this.addChannel(channel);
        Map<String, LinkedList<PendingContext>> channelEntries = this.channelList.get(channel);
        String keyVal = null;
        if (key != null) {
            keyVal = key instanceof BMap ? DatabaseUtils.sortBMap(((BMap)key).getMap()) : key.stringValue();
        }
        LinkedList ctxList = channelEntries.computeIfAbsent(keyVal, bValue -> new LinkedList());
        PendingContext pContext = new PendingContext();
        pContext.regIndex = regIndex;
        pContext.context = ctx;
        ctxList.add(pContext);
        channelEntries.put(keyVal, ctxList);
    }

    public PendingContext pollOnChannel(String channel, BValue key) {
        LinkedList<PendingContext> pendingCtxs;
        this.addChannel(channel);
        String keyVal = null;
        if (key != null) {
            keyVal = key instanceof BMap ? DatabaseUtils.sortBMap(((BMap)key).getMap()) : key.stringValue();
        }
        if ((pendingCtxs = this.channelList.get(channel).get(keyVal)) != null) {
            return pendingCtxs.poll();
        }
        return null;
    }

    public Map<String, LinkedList<PendingContext>> addChannel(String name) {
        return this.channelList.computeIfAbsent(name, chn -> new HashMap());
    }

    public static class PendingContext {
        public int regIndex;
        public Strand context;
    }
}

