/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.channels;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.TreeMap;
import org.ballerinalang.config.ConfigRegistry;
import org.ballerinalang.model.types.BType;
import org.ballerinalang.model.util.JsonParser;
import org.ballerinalang.model.util.XMLUtils;
import org.ballerinalang.model.values.BBoolean;
import org.ballerinalang.model.values.BByte;
import org.ballerinalang.model.values.BFloat;
import org.ballerinalang.model.values.BInteger;
import org.ballerinalang.model.values.BMap;
import org.ballerinalang.model.values.BString;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.util.exceptions.BallerinaException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseUtils {
    private static final Logger logger = LoggerFactory.getLogger(DatabaseUtils.class);
    private static HikariDataSource hikariDataSource;
    public static HikariConfig config;
    private static ConfigRegistry registry;
    private static final String H2_MEM_URL = "jdbc:h2:mem:channels";

    public static void addEntry(String channelName, BValue key, BValue value2, BType keyType, BType valType) {
        Connection con = null;
        PreparedStatement stmt = null;
        try {
            con = DatabaseUtils.getDBConnection();
            stmt = con.prepareStatement("INSERT into messages (channelName, msgKey, value) values (?, ?, ?)");
            stmt.setString(1, channelName);
            if (keyType != null) {
                DatabaseUtils.setParam(stmt, key, keyType, 2, true);
            } else {
                stmt.setNull(2, 12);
            }
            DatabaseUtils.setParam(stmt, value2, valType, 3, false);
            stmt.execute();
        }
        catch (SQLException e) {
            throw new BallerinaException("error in saving received channel message " + e.getMessage(), e);
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (con != null) {
                    con.close();
                }
            }
            catch (SQLException e) {
                logger.warn("Could not close db connection created for channels", e);
            }
        }
    }

    public static BValue getMessage(String channelName, BValue key, BType keyType, BType receiverType) {
        ResultSet result = null;
        Connection con = null;
        Statement prpStmt = null;
        try {
            con = DatabaseUtils.getDBConnection();
            if (keyType != null) {
                prpStmt = con.prepareStatement("SELECT msgId,value FROM messages WHERE channelName = ? AND msgKey = ?");
                DatabaseUtils.setParam((PreparedStatement)prpStmt, key, keyType, 2, true);
            } else {
                prpStmt = con.prepareStatement("SELECT msgId,value FROM messages WHERE channelName = ? AND msgKey IS NULL");
            }
            prpStmt.setString(1, channelName);
            result = prpStmt.executeQuery();
            if (result.next()) {
                int msgId = result.getInt(1);
                BValue value2 = DatabaseUtils.getValue(result, receiverType);
                PreparedStatement dropStmt = con.prepareStatement("DELETE FROM messages where msgId = ?");
                dropStmt.setInt(1, msgId);
                dropStmt.execute();
                BValue bValue = value2;
                return bValue;
            }
        }
        catch (SQLException e) {
            throw new BallerinaException("error retrieving channel message " + e.getMessage(), e);
        }
        finally {
            try {
                if (prpStmt != null) {
                    prpStmt.close();
                }
                if (result != null) {
                    result.close();
                }
                if (con != null) {
                    con.close();
                }
            }
            catch (SQLException e) {
                logger.warn("Could not close db connection created for channels", e);
            }
        }
        return null;
    }

    public static String getJDBCURL() {
        String dbType = registry.getAsString("b7a.channel.db.dbType");
        if (dbType == null) {
            config.setPassword("");
            config.setUsername("SA");
            return H2_MEM_URL;
        }
        String hostOrPath = registry.getAsString("b7a.channel.db.hostOrPath");
        long port = -1L;
        if (registry.contains("b7a.channel.db.port")) {
            port = registry.getAsInt("b7a.channel.db.port");
        }
        String dbName = registry.getAsString("b7a.channel.db.dbName");
        String userName = registry.getAsString("b7a.channel.db.username");
        String password = registry.getAsString("b7a.channel.db.password");
        String dbOptions = registry.getAsString("b7a.channel.db.dbOptions");
        dbType = dbType.toUpperCase(Locale.ENGLISH);
        if (hostOrPath != null) {
            hostOrPath = hostOrPath.replaceAll("/$", "");
        }
        StringBuilder jdbcUrl = new StringBuilder();
        switch (dbType) {
            case "MYSQL": {
                if (port <= 0L) {
                    port = 3306L;
                }
                jdbcUrl.append("jdbc:mysql://").append(hostOrPath).append(":").append(port).append("/").append(dbName);
                break;
            }
            case "SQLSERVER": {
                if (port <= 0L) {
                    port = 1433L;
                }
                jdbcUrl.append("jdbc:sqlserver://").append(hostOrPath).append(":").append(port).append(";databaseName=").append(dbName);
                break;
            }
            case "ORACLE": {
                if (port <= 0L) {
                    port = 1521L;
                }
                jdbcUrl.append("jdbc:oracle:thin:").append(userName).append("/").append(password).append("@").append(hostOrPath).append(":").append(port).append("/").append(dbName);
                break;
            }
            case "SYBASE": {
                if (port <= 0L) {
                    port = 5000L;
                }
                jdbcUrl.append("jdbc:sybase:Tds:").append(hostOrPath).append(":").append(port).append("/").append(dbName);
                break;
            }
            case "POSTGRESQL": {
                if (port <= 0L) {
                    port = 5432L;
                }
                jdbcUrl.append("jdbc:postgresql://").append(hostOrPath).append(":").append(port).append("/").append(dbName);
                break;
            }
            case "DB2": {
                if (port <= 0L) {
                    port = 50000L;
                }
                jdbcUrl.append("jdbc:db2:").append(hostOrPath).append(":").append(port).append("/").append(dbName);
                break;
            }
            case "HSQLDB_SERVER": {
                if (port <= 0L) {
                    port = 9001L;
                }
                jdbcUrl.append("jdbc:hsqldb:hsql://").append(hostOrPath).append(":").append(port).append("/").append(dbName);
                break;
            }
            case "HSQLDB_FILE": {
                jdbcUrl.append("jdbc:hsqldb:file:").append(hostOrPath).append(File.separator).append(dbName);
                break;
            }
            case "H2_SERVER": {
                if (port <= 0L) {
                    port = 9092L;
                }
                jdbcUrl.append("jdbc:h2:tcp:").append(hostOrPath).append(":").append(port).append("/").append(dbName);
                break;
            }
            case "H2_FILE": {
                jdbcUrl.append("jdbc:h2:file:").append(hostOrPath).append(File.separator).append(dbName);
                break;
            }
            case "H2_MEMORY": {
                jdbcUrl.append("jdbc:h2:mem:").append(dbName);
                break;
            }
            case "DERBY_SERVER": {
                if (port <= 0L) {
                    port = 1527L;
                }
                jdbcUrl.append("jdbc:derby:").append(hostOrPath).append(":").append(port).append("/").append(dbName);
                break;
            }
            case "DERBY_FILE": {
                jdbcUrl.append("jdbc:derby:").append(hostOrPath).append(File.separator).append(dbName);
                break;
            }
            default: {
                throw new BallerinaException("cannot generate url for unknown database type : " + dbType);
            }
        }
        return dbOptions == null ? jdbcUrl.toString() : jdbcUrl.append(dbOptions).toString();
    }

    public static void close() {
        if (hikariDataSource != null) {
            hikariDataSource.close();
            hikariDataSource = null;
        }
    }

    private static Connection getDBConnection() throws SQLException {
        if (hikariDataSource == null) {
            config = new HikariConfig();
            String jdbcUrl = DatabaseUtils.getJDBCURL();
            config.setJdbcUrl(jdbcUrl);
            DatabaseUtils.setCredentials();
            hikariDataSource = new HikariDataSource(config);
            Connection con = hikariDataSource.getConnection();
            if (jdbcUrl.contains(H2_MEM_URL)) {
                PreparedStatement stmt = con.prepareStatement("create table IF NOT EXISTS messages (msgId int NOT NULL AUTO_INCREMENT,channelName varchar(200),msgKey varchar(4000),value CLOB, constraint pk primary key ( msgId ))");
                stmt.execute();
                stmt.close();
            }
            return con;
        }
        return hikariDataSource.getConnection();
    }

    private static BValue getValue(ResultSet resultSet, BType bType) throws SQLException {
        int type = bType.getTag();
        switch (type) {
            case 1: {
                return new BInteger(resultSet.getLong(2));
            }
            case 5: {
                return new BString(resultSet.getString(2));
            }
            case 2: {
                return new BByte(resultSet.getByte(2));
            }
            case 3: {
                return new BFloat(resultSet.getDouble(2));
            }
            case 6: {
                return new BBoolean(resultSet.getBoolean(2));
            }
            case 8: {
                return XMLUtils.parse(resultSet.getString(2));
            }
            case 7: {
                return JsonParser.parse(resultSet.getString(2));
            }
        }
        throw new BallerinaException("unsupported data type " + type + ", for channel data");
    }

    private static void setCredentials() {
        if (registry.contains("b7a.channel.db.password")) {
            config.setPassword(registry.getAsString("b7a.channel.db.password"));
        }
        if (registry.contains("b7a.channel.db.username")) {
            config.setUsername(registry.getAsString("b7a.channel.db.username"));
        }
    }

    private static void setParam(PreparedStatement stmt, BValue value2, BType bType, int index, boolean isKey) throws SQLException {
        int type = bType.getTag();
        switch (type) {
            case 1: {
                stmt.setLong(index, ((BInteger)value2).intValue());
                break;
            }
            case 5: {
                stmt.setString(index, value2.stringValue());
                break;
            }
            case 3: {
                stmt.setDouble(index, ((BFloat)value2).floatValue());
                break;
            }
            case 6: {
                stmt.setBoolean(index, ((BBoolean)value2).booleanValue());
                break;
            }
            case 2: {
                stmt.setByte(index, ((BByte)value2).value().byteValue());
                break;
            }
            default: {
                if (isKey && value2 instanceof BMap) {
                    stmt.setString(index, DatabaseUtils.sortBMap(((BMap)value2).getMap()));
                    break;
                }
                stmt.setString(index, value2.toString());
            }
        }
    }

    public static String sortBMap(LinkedHashMap map2) {
        TreeMap result = new TreeMap();
        result.putAll(map2);
        return result.toString();
    }

    static {
        registry = ConfigRegistry.getInstance();
    }
}

