/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.connector.api;

import org.ballerinalang.connector.api.Struct;
import org.ballerinalang.model.values.BValue;

public interface Value {
    public Type getType();

    public long getIntValue();

    public double getFloatValue();

    public String getStringValue();

    public boolean getBooleanValue();

    public Struct getStructValue();

    public BValue getVMValue();

    public static enum Type {
        INT(1),
        FLOAT(3),
        STRING(5),
        BOOLEAN(6),
        ARRAY(19),
        MAP(15),
        OBJECT(33),
        RECORD(12),
        JSON(7),
        XML(8),
        TYPEDESC(13),
        NULL(10),
        OTHER(-1);

        int tag;

        private Type(int i) {
            this.tag = i;
        }

        public int getTag() {
            return this.tag;
        }

        public static Type getType(int tag) {
            for (Type type : Type.values()) {
                if (type.tag != tag) continue;
                return type;
            }
            return OTHER;
        }

        public static Type getType(BValue value2) {
            if (value2 == null) {
                return NULL;
            }
            for (Type type : Type.values()) {
                if (type.tag != value2.getType().getTag()) continue;
                return type;
            }
            return OTHER;
        }
    }
}

