/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.connector.impl;

import java.util.Arrays;
import org.ballerinalang.bre.bvm.GlobalMemoryArea;
import org.ballerinalang.connector.impl.AnnotatableNode;
import org.ballerinalang.connector.impl.AnnotationImpl;
import org.ballerinalang.connector.impl.ResourceImpl;
import org.ballerinalang.connector.impl.ServiceImpl;
import org.ballerinalang.connector.impl.StructImpl;
import org.ballerinalang.model.types.BTypes;
import org.ballerinalang.model.values.BMap;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.util.codegen.FunctionInfo;
import org.ballerinalang.util.codegen.PackageInfo;
import org.ballerinalang.util.codegen.PackageVarInfo;
import org.ballerinalang.util.codegen.ProgramFile;
import org.ballerinalang.util.codegen.ServiceInfo;

public class ConnectorSPIModelHelper {
    private static final String ANNOTATION_DATA = "$annotation_data";

    public static ServiceImpl createService(ProgramFile programFile, ServiceInfo serviceInfo, BMap serviceValue) {
        ServiceImpl service = new ServiceImpl(serviceInfo, serviceValue);
        ConnectorSPIModelHelper.processAnnotations(serviceInfo.getPackagePath(), programFile, service);
        Arrays.stream(serviceInfo.getResourceInfoEntries()).forEach(resourceInfo -> {
            ResourceImpl resource = new ResourceImpl(resourceInfo.getName(), service, (FunctionInfo)resourceInfo);
            resource.setService(service);
            ConnectorSPIModelHelper.processAnnotations(resourceInfo.getPkgPath(), programFile, resource);
            service.addResource(resource.getName(), resource);
        });
        return service;
    }

    public static StructImpl createStruct(BMap<String, BValue> struct) {
        return new StructImpl(struct);
    }

    public static BMap getAnnotationVariable(String pkgPath, ProgramFile programFile) {
        PackageInfo packageInfo = programFile.getPackageInfo(pkgPath);
        PackageVarInfo annotationData = packageInfo.getPackageVarInfo(ANNOTATION_DATA);
        GlobalMemoryArea globalMemArea = programFile.globalMemArea;
        return (BMap)globalMemArea.getRefField(packageInfo.pkgIndex, annotationData.getGlobalMemIndex());
    }

    private static void processAnnotations(String pkgPath, ProgramFile programFile, AnnotatableNode annotatableNode) {
        BMap bMap = ConnectorSPIModelHelper.getAnnotationVariable(pkgPath, programFile);
        if (!bMap.hasKey(annotatableNode.getAnnotationEntryKey())) {
            return;
        }
        Object map2 = bMap.get(annotatableNode.getAnnotationEntryKey());
        if (map2 == null || map2.getType().getTag() != BTypes.typeMap.getTag()) {
            return;
        }
        BMap annotationMap = (BMap)map2;
        for (String key : (String[])annotationMap.keys()) {
            BMap annotationData = (BMap)annotationMap.get(key);
            StructImpl struct = null;
            if (annotationData != null) {
                struct = new StructImpl(annotationData);
            }
            String annotaionQName = key.split("\\$")[0];
            String[] qNameParts = annotaionQName.split(":");
            AnnotationImpl annotation = new AnnotationImpl(qNameParts[1], qNameParts[0], struct);
            annotatableNode.addAnnotation(annotaionQName, annotation);
        }
    }
}

