/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.connector.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ballerinalang.connector.api.Annotation;
import org.ballerinalang.connector.api.Resource;
import org.ballerinalang.connector.api.Service;
import org.ballerinalang.connector.impl.AnnotatableNode;
import org.ballerinalang.model.values.BMap;
import org.ballerinalang.util.codegen.ServiceInfo;

public class ServiceImpl
extends AnnotatableNode
implements Service {
    private String name;
    private String packagePath;
    private ServiceInfo serviceInfo;
    private String packageVersion;
    private BMap serviceValue;
    private Map<String, Resource> resourceMap = new HashMap<String, Resource>();

    ServiceImpl(ServiceInfo serviceInfo, BMap serviceValue) {
        this.serviceInfo = serviceInfo;
        this.name = serviceInfo.getName();
        this.packagePath = serviceInfo.getPackagePath();
        this.packageVersion = serviceInfo.getPackageInfo().getPackageVersion();
        this.serviceValue = serviceValue;
    }

    public void addResource(String name, Resource resource) {
        this.resourceMap.put(name, resource);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public BMap getBValue() {
        return this.serviceValue;
    }

    @Override
    public String getPackage() {
        return this.packagePath;
    }

    @Override
    public List<Annotation> getAnnotationList(String pkgPath, String name) {
        String key = pkgPath + ":" + name;
        return (List)this.annotationMap.get(key);
    }

    @Override
    public Resource[] getResources() {
        return this.resourceMap.values().toArray(new Resource[0]);
    }

    @Override
    public String getAnnotationEntryKey() {
        return this.name;
    }

    @Override
    public ServiceInfo getServiceInfo() {
        return this.serviceInfo;
    }

    @Override
    public String getPackageVersion() {
        return this.packageVersion;
    }
}

