/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.connector.impl;

import org.ballerinalang.connector.api.Struct;
import org.ballerinalang.connector.api.Value;
import org.ballerinalang.connector.impl.StructImpl;
import org.ballerinalang.model.values.BMap;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.model.values.BValueType;

public class ValueImpl
implements Value {
    private Value.Type type;
    private long intValue;
    private double floatValue;
    private String stringValue;
    private boolean booleanValue;
    private StructImpl structValue;
    private BValue value;

    private ValueImpl(Value.Type type, BValue value2) {
        this.type = type;
        this.value = value2;
    }

    @Override
    public Value.Type getType() {
        return this.type;
    }

    @Override
    public long getIntValue() {
        return this.intValue;
    }

    @Override
    public double getFloatValue() {
        return this.floatValue;
    }

    @Override
    public String getStringValue() {
        return this.stringValue;
    }

    @Override
    public boolean getBooleanValue() {
        return this.booleanValue;
    }

    @Override
    public Struct getStructValue() {
        return this.structValue;
    }

    @Override
    public BValue getVMValue() {
        return this.value;
    }

    public static ValueImpl createValue(BValue value2) {
        if (value2 == null) {
            return null;
        }
        ValueImpl val = new ValueImpl(Value.Type.getType(value2), value2);
        switch (val.type) {
            case INT: {
                val.intValue = ((BValueType)value2).intValue();
                break;
            }
            case FLOAT: {
                val.floatValue = ((BValueType)value2).floatValue();
                break;
            }
            case BOOLEAN: {
                val.booleanValue = ((BValueType)value2).booleanValue();
                break;
            }
            case OBJECT: 
            case RECORD: {
                val.structValue = new StructImpl((BMap)value2);
                break;
            }
            case NULL: {
                break;
            }
            default: {
                val.stringValue = value2.stringValue();
            }
        }
        return val;
    }
}

