/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.jvm;

import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.ballerinalang.jvm.scheduling.Scheduler;
import org.ballerinalang.jvm.scheduling.State;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.values.ObjectValue;

public class BRuntime {
    private Scheduler scheduler;

    private BRuntime(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    public static CompletableFuture<Object> markAsync() {
        Strand strand = Scheduler.getStrand();
        strand.blockedOnExtern = true;
        strand.setState(State.BLOCK_AND_YIELD);
        CompletableFuture<Object> future2 = new CompletableFuture<Object>();
        future2.whenComplete((BiConsumer)new Unblocker(strand));
        return future2;
    }

    public static BRuntime getCurrentRuntime() {
        Strand strand = Scheduler.getStrand();
        return new BRuntime(strand.scheduler);
    }

    public void invokeMethod(ObjectValue object, String methodName, Object ... args) {
        Consumer<Object> func = o -> object.call((Strand)((Object[])o)[0], methodName, args);
        this.scheduler.schedule(new Object[1], func, null);
    }

    private static class Unblocker
    implements BiConsumer<Object, Throwable> {
        private Strand strand;

        public Unblocker(Strand strand) {
            this.strand = strand;
        }

        @Override
        public void accept(Object returnValue, Throwable throwable) {
            if (throwable == null) {
                this.strand.setReturnValues(returnValue);
                this.strand.scheduler.unblockStrand(this.strand);
            }
        }
    }
}

