/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.jvm;

import java.util.Map;
import org.ballerinalang.jvm.types.BField;
import org.ballerinalang.jvm.types.BRecordType;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.jvm.values.MapValueImpl;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.jvm.values.ValueCreator;

public class BallerinaValues {
    public static MapValue<String, Object> createRecordValue(String pkgName, String recordTypeName) {
        ValueCreator valueCreator = ValueCreator.getValueCreator(pkgName);
        return valueCreator.createRecordValue(recordTypeName);
    }

    public static MapValue<String, Object> createRecordValue(String pkgName, String recordTypeName, Map<String, Object> valueMap) {
        MapValue<String, Object> record = BallerinaValues.createRecordValue(pkgName, recordTypeName);
        for (Map.Entry<String, Object> fieldEntry : valueMap.entrySet()) {
            record.put(fieldEntry.getKey(), fieldEntry.getValue());
        }
        return record;
    }

    public static ObjectValue createObjectValue(String pkgName, String objectTypeName, Object ... fieldValues) {
        ValueCreator valueCreator = ValueCreator.getValueCreator(pkgName);
        Object[] fields = new Object[fieldValues.length * 2];
        int j = 0;
        for (int i = 0; i < fieldValues.length; ++i) {
            fields[j++] = fieldValues[i];
            fields[j++] = true;
        }
        return valueCreator.createObjectValue(objectTypeName, null, null, null, fields);
    }

    public static MapValue<String, Object> createRecord(MapValue<String, Object> record, Object ... values) {
        BRecordType recordType = (BRecordType)record.getType();
        MapValueImpl<String, Object> mapValue = new MapValueImpl<String, Object>(recordType);
        int i = 0;
        for (Map.Entry<String, BField> fieldEntry : recordType.getFields().entrySet()) {
            mapValue.put(fieldEntry.getKey(), values[i++]);
        }
        return mapValue;
    }
}

