/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.jvm;

import org.ballerinalang.jvm.BallerinaErrors;
import org.ballerinalang.jvm.TypeChecker;
import org.ballerinalang.jvm.types.BArrayType;
import org.ballerinalang.jvm.types.BTupleType;
import org.ballerinalang.jvm.types.BType;
import org.ballerinalang.jvm.types.BTypes;
import org.ballerinalang.jvm.util.exceptions.BLangExceptionHelper;
import org.ballerinalang.jvm.util.exceptions.BallerinaErrorReasons;
import org.ballerinalang.jvm.util.exceptions.RuntimeErrors;
import org.ballerinalang.jvm.values.ArrayValue;

public class Lists {
    public static Object get(ArrayValue array2, long index) {
        if (array2.getType().getTag() != 20) {
            return array2.getRefValue(index);
        }
        switch (((BArrayType)array2.getType()).getElementType().getTag()) {
            case 6: {
                return new Boolean(array2.getBoolean(index));
            }
            case 2: {
                return new Long(array2.getByte(index));
            }
            case 3: {
                return new Double(array2.getFloat(index));
            }
            case 4: {
                return array2.getRefValue(index);
            }
            case 1: {
                return new Long((int)array2.getInt(index));
            }
            case 5: {
                return new String(array2.getString(index));
            }
        }
        return array2.getRefValue(index);
    }

    public static void add(ArrayValue array2, long index, Object refType) {
        BTupleType tupleType;
        BType elementType = array2.elementType;
        if (array2.getType().getTag() == 31 && Lists.isTupleIndexWithinRange(tupleType = (BTupleType)array2.getType(), index)) {
            elementType = tupleType.getTupleTypes().get((int)index);
        }
        if (elementType != null && !TypeChecker.checkIsType(refType, elementType)) {
            throw BallerinaErrors.createError(BallerinaErrorReasons.INHERENT_TYPE_VIOLATION_ERROR, BLangExceptionHelper.getErrorMessage(RuntimeErrors.INCOMPATIBLE_TYPE, elementType, refType != null ? TypeChecker.getType(refType) : BTypes.typeNull));
        }
        if (array2.getType().getTag() != 20) {
            array2.add(index, refType);
            return;
        }
        switch (((BArrayType)array2.getType()).getElementType().getTag()) {
            case 6: {
                array2.add(index, (Boolean)refType);
                return;
            }
            case 3: {
                array2.add(index, (Double)refType);
                return;
            }
            case 2: {
                array2.add(index, ((Integer)refType).byteValue());
                return;
            }
            case 1: {
                array2.add(index, (Long)refType);
                return;
            }
            case 5: {
                array2.add(index, (String)refType);
                return;
            }
        }
        array2.add(index, refType);
    }

    private static boolean isTupleIndexWithinRange(BTupleType tuple, long index) {
        return index >= 0L && index < (long)tuple.getTupleTypes().size();
    }
}

