/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.jvm;

import org.ballerinalang.jvm.BallerinaErrors;
import org.ballerinalang.jvm.TypeChecker;
import org.ballerinalang.jvm.types.BField;
import org.ballerinalang.jvm.types.BMapType;
import org.ballerinalang.jvm.types.BRecordType;
import org.ballerinalang.jvm.types.BType;
import org.ballerinalang.jvm.types.BTypes;
import org.ballerinalang.jvm.util.exceptions.BLangExceptionHelper;
import org.ballerinalang.jvm.util.exceptions.BallerinaErrorReasons;
import org.ballerinalang.jvm.util.exceptions.RuntimeErrors;
import org.ballerinalang.jvm.values.ErrorValue;
import org.ballerinalang.jvm.values.MapValue;

public class MapUtils {
    public static void handleMapStore(MapValue<String, Object> mapValue, String fieldName, Object value2) {
        BType mapType = mapValue.getType();
        BType valuesType = value2 == null ? BTypes.typeNull : TypeChecker.getType(value2);
        switch (mapType.getTag()) {
            case 15: {
                if (!TypeChecker.checkIsType(value2, ((BMapType)mapType).getConstrainedType())) {
                    BType expType = ((BMapType)mapType).getConstrainedType();
                    throw BallerinaErrors.createError(BallerinaErrorReasons.INHERENT_TYPE_VIOLATION_ERROR, BLangExceptionHelper.getErrorMessage(RuntimeErrors.INVALID_MAP_INSERTION, expType, valuesType));
                }
                mapValue.put(fieldName, value2);
                break;
            }
            case 12: {
                BType recFieldType;
                BRecordType recType = (BRecordType)mapType;
                BField recField = recType.getFields().get(fieldName);
                if (recField != null) {
                    recFieldType = recField.type;
                } else if (recType.restFieldType != null) {
                    recFieldType = recType.restFieldType;
                } else {
                    throw BallerinaErrors.createError(BallerinaErrorReasons.KEY_NOT_FOUND_ERROR, BLangExceptionHelper.getErrorMessage(RuntimeErrors.INVALID_RECORD_FIELD_ACCESS, fieldName, recType));
                }
                if (!TypeChecker.checkIsType(value2, recFieldType)) {
                    throw BallerinaErrors.createError(BallerinaErrorReasons.INHERENT_TYPE_VIOLATION_ERROR, BLangExceptionHelper.getErrorMessage(RuntimeErrors.INVALID_RECORD_FIELD_ADDITION, fieldName, recFieldType, valuesType));
                }
                mapValue.put(fieldName, value2);
            }
        }
    }

    public static ErrorValue createOpNotSupportedError(BType type, String op) {
        return BallerinaErrors.createError(BallerinaErrorReasons.OPERATION_NOT_SUPPORTED, String.format("%s not supported on type '%s'", op, type.getQualifiedName()));
    }

    public static void checkIsMapOnlyOperation(BType mapType, String op) {
        switch (mapType.getTag()) {
            case 7: 
            case 15: {
                return;
            }
        }
        throw MapUtils.createOpNotSupportedError(mapType, op);
    }
}

