/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.jvm;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import org.ballerinalang.jvm.BallerinaErrors;
import org.ballerinalang.jvm.util.exceptions.BallerinaErrorReasons;
import org.ballerinalang.jvm.util.exceptions.BallerinaException;

public class StringUtils {
    public static boolean isEqual(String s1, String s2) {
        if (s1 == s2) {
            return true;
        }
        if (s1 == null || s2 == null) {
            return false;
        }
        return s1.equals(s2);
    }

    public static String getStringFromInputStream(InputStream in) {
        String result;
        BufferedInputStream bis = new BufferedInputStream(in);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            int data;
            while ((data = bis.read()) != -1) {
                bos.write(data);
            }
            result = bos.toString();
        }
        catch (IOException ioe) {
            throw new BallerinaException("Error occurred when reading input stream", ioe);
        }
        finally {
            try {
                bos.close();
            }
            catch (IOException iOException) {}
        }
        return result;
    }

    public static String getStringFromInputStream(InputStream inputStream, String charset) {
        StringBuilder textBuilder = new StringBuilder();
        try (InputStreamReader reader = new InputStreamReader(inputStream, Charset.forName(charset));){
            int character;
            while ((character = ((Reader)reader).read()) != -1) {
                textBuilder.append((char)character);
            }
        }
        catch (IOException e) {
            throw new BallerinaException("Error occurred when reading input stream with the charset" + charset, e);
        }
        return textBuilder.toString();
    }

    public static String getStringAt(String s, long index) {
        if (index < 0L || index >= (long)s.length()) {
            throw BallerinaErrors.createError(BallerinaErrorReasons.INDEX_OUT_OF_RANGE_ERROR, "string index out of range: index: " + index + ", size: " + s.length());
        }
        return String.valueOf(s.charAt((int)index));
    }
}

