/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.jvm;

import java.io.IOException;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Struct;
import org.ballerinalang.jvm.ColumnDefinition;
import org.ballerinalang.jvm.JSONDataSource;
import org.ballerinalang.jvm.JSONGenerator;
import org.ballerinalang.jvm.JSONParser;
import org.ballerinalang.jvm.types.BArrayType;
import org.ballerinalang.jvm.types.BField;
import org.ballerinalang.jvm.types.BStructureType;
import org.ballerinalang.jvm.types.BType;
import org.ballerinalang.jvm.types.BTypes;
import org.ballerinalang.jvm.util.exceptions.BLangRuntimeException;
import org.ballerinalang.jvm.util.exceptions.BallerinaException;
import org.ballerinalang.jvm.values.ArrayValue;
import org.ballerinalang.jvm.values.DecimalValue;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.jvm.values.MapValueImpl;
import org.ballerinalang.jvm.values.TableValue;

public class TableJSONDataSource
implements JSONDataSource {
    private TableValue df;
    private JSONObjectGenerator objGen;

    public TableJSONDataSource(TableValue df) {
        this(df, new DefaultJSONObjectGenerator());
    }

    private TableJSONDataSource(TableValue df, JSONObjectGenerator objGen) {
        this.df = df;
        this.objGen = objGen;
    }

    @Override
    public void serialize(JSONGenerator gen) throws IOException {
        gen.writeStartArray();
        while (this.hasNext()) {
            gen.serialize(this.next());
        }
        gen.writeEndArray();
    }

    @Override
    public boolean hasNext() {
        return this.df.hasNext();
    }

    @Override
    public Object next() {
        try {
            this.df.moveToNext();
            return this.objGen.transform(this.df);
        }
        catch (IOException e) {
            throw new BLangRuntimeException("error while geting next data", e);
        }
    }

    @Override
    public Object build() {
        ArrayValue values = new ArrayValue(new BArrayType(BTypes.typeJSON));
        while (this.hasNext()) {
            values.append(this.next());
        }
        return values;
    }

    private static void constructJsonData(TableValue df, MapValue<String, Object> jsonObject, String name, int typeTag, int index, BField[] structFields) {
        switch (typeTag) {
            case 5: {
                jsonObject.put(name, df.getString(index));
                break;
            }
            case 1: {
                Long intVal = df.getInt(index);
                jsonObject.put(name, intVal == null ? null : intVal);
                break;
            }
            case 3: {
                Double floatVal = df.getFloat(index);
                jsonObject.put(name, floatVal == null ? null : floatVal);
                break;
            }
            case 4: {
                DecimalValue decimalVal = df.getDecimal(index);
                jsonObject.put(name, decimalVal == null ? null : decimalVal);
                break;
            }
            case 6: {
                Boolean boolVal = df.getBoolean(index);
                jsonObject.put(name, boolVal == null ? null : boolVal);
                break;
            }
            case 36: {
                jsonObject.put(name, df.getBlob(index));
                break;
            }
            case 20: {
                jsonObject.put(name, TableJSONDataSource.getDataArray(df, index));
                break;
            }
            case 7: {
                jsonObject.put(name, df.getString(index) == null ? null : JSONParser.parse(df.getString(index)));
                break;
            }
            case 12: 
            case 35: {
                jsonObject.put(name, TableJSONDataSource.getStructData(df.getStruct(index), structFields, index));
                break;
            }
            case 8: {
                jsonObject.put(name, df.getString(index));
                break;
            }
            default: {
                jsonObject.put(name, df.getString(index));
            }
        }
    }

    private static Object getStructData(Object[] data, BField[] structFields, int index) {
        try {
            if (structFields == null) {
                ArrayValue jsonArray = new ArrayValue(new BArrayType(BTypes.typeJSON));
                if (data != null) {
                    for (Object value2 : data) {
                        if (value2 instanceof String) {
                            jsonArray.append(new String((String)value2));
                            continue;
                        }
                        if (value2 instanceof Boolean) {
                            jsonArray.append((Boolean)value2);
                            continue;
                        }
                        if (value2 instanceof Long) {
                            jsonArray.append((long)((Long)value2));
                            continue;
                        }
                        if (value2 instanceof Double) {
                            jsonArray.append((double)((Double)value2));
                            continue;
                        }
                        if (value2 instanceof Integer) {
                            jsonArray.append((int)((Integer)value2));
                            continue;
                        }
                        if (value2 instanceof Float) {
                            jsonArray.append(Float.valueOf(((Float)value2).floatValue()));
                            continue;
                        }
                        if (!(value2 instanceof DecimalValue)) continue;
                        jsonArray.append(((DecimalValue)value2).floatValue());
                    }
                }
                return jsonArray;
            }
            MapValueImpl<String, Object> jsonData = new MapValueImpl<String, Object>();
            boolean structError = true;
            if (data != null) {
                int i = 0;
                for (Object value3 : data) {
                    BField[] internalStructFields;
                    BType internaltType = structFields[index - 1].type;
                    if ((internaltType.getTag() == 35 || internaltType.getTag() == 12) && (internalStructFields = ((BStructureType)internaltType).getFields().values().toArray(new BField[0])) != null) {
                        if (value3 instanceof BigDecimal) {
                            jsonData.put(internalStructFields[i].name, ((BigDecimal)value3).doubleValue());
                        } else if (value3 instanceof Struct) {
                            jsonData.put(internalStructFields[i].name, TableJSONDataSource.getStructData(((Struct)value3).getAttributes(), internalStructFields, i + 1));
                        } else {
                            jsonData.put(internalStructFields[i].name, value3);
                        }
                        structError = false;
                    }
                    ++i;
                }
            }
            if (structError) {
                throw new BallerinaException("error in constructing the json object from struct type data");
            }
            return jsonData;
        }
        catch (SQLException e) {
            throw new BallerinaException("error in retrieving struct data to construct the inner json object:" + e.getMessage());
        }
    }

    private static Object getDataArray(TableValue df, int columnIndex) {
        ArrayValue jsonArray;
        block8: {
            Object obj;
            Object[] dataArray;
            block14: {
                block13: {
                    block12: {
                        block11: {
                            block10: {
                                block9: {
                                    dataArray = df.getArray(columnIndex);
                                    int length = dataArray.length;
                                    jsonArray = new ArrayValue(new BArrayType(BTypes.typeJSON));
                                    if (length <= 0) break block8;
                                    obj = dataArray[0];
                                    if (!(obj instanceof String)) break block9;
                                    for (Object value2 : dataArray) {
                                        jsonArray.append(value2);
                                    }
                                    break block8;
                                }
                                if (!(obj instanceof Boolean)) break block10;
                                for (Object value3 : dataArray) {
                                    jsonArray.append(value3);
                                }
                                break block8;
                            }
                            if (!(obj instanceof Integer)) break block11;
                            for (Object value4 : dataArray) {
                                jsonArray.append(((Integer)value4).longValue());
                            }
                            break block8;
                        }
                        if (!(obj instanceof Long)) break block12;
                        for (Object value5 : dataArray) {
                            jsonArray.append(value5);
                        }
                        break block8;
                    }
                    if (!(obj instanceof Float)) break block13;
                    for (Object value6 : dataArray) {
                        jsonArray.append(((Float)value6).doubleValue());
                    }
                    break block8;
                }
                if (!(obj instanceof Double)) break block14;
                for (Object value7 : dataArray) {
                    jsonArray.append(value7);
                }
                break block8;
            }
            if (!(obj instanceof BigDecimal)) break block8;
            for (Object value8 : dataArray) {
                if (value8 != null) {
                    jsonArray.append(((BigDecimal)value8).doubleValue());
                    continue;
                }
                jsonArray.append(null);
            }
        }
        return jsonArray;
    }

    public static interface JSONObjectGenerator {
        public Object transform(TableValue var1) throws IOException;
    }

    private static class DefaultJSONObjectGenerator
    implements JSONObjectGenerator {
        private DefaultJSONObjectGenerator() {
        }

        @Override
        public Object transform(TableValue df) throws IOException {
            MapValueImpl objNode = new MapValueImpl(BTypes.typeJSON);
            BStructureType structType = df.getStructType();
            BField[] structFields = null;
            if (structType != null) {
                structFields = structType.getFields().values().toArray(new BField[0]);
            }
            int index = 0;
            for (ColumnDefinition col : df.getColumnDefs()) {
                String name = structFields != null ? structFields[index].getFieldName() : col.getName();
                TableJSONDataSource.constructJsonData(df, objNode, name, col.getTypeTag(), index + 1, structFields);
                ++index;
            }
            return objNode;
        }
    }
}

