/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.jvm;

import java.sql.SQLException;
import java.sql.Struct;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.om.ds.AbstractPushOMDataSource;
import org.ballerinalang.jvm.BallerinaErrors;
import org.ballerinalang.jvm.ColumnDefinition;
import org.ballerinalang.jvm.types.BField;
import org.ballerinalang.jvm.types.BStructureType;
import org.ballerinalang.jvm.types.BType;
import org.ballerinalang.jvm.values.TableValue;

public class TableOMDataSource
extends AbstractPushOMDataSource {
    private static final String XSI_NAMESPACE = "http://www.w3.org/2001/XMLSchema-instance";
    private static final String XSI_PREFIX = "xsi";
    private static final String ARRAY_ELEMENT_NAME = "element";
    private static final String DEFAULT_ROOT_WRAPPER = "results";
    private static final String DEFAULT_ROW_WRAPPER = "result";
    private TableValue table;
    private String rootWrapper;
    private String rowWrapper;

    public TableOMDataSource(TableValue table2, String rootWrapper, String rowWrapper) {
        this.table = table2;
        this.rootWrapper = rootWrapper != null ? rootWrapper : DEFAULT_ROOT_WRAPPER;
        this.rowWrapper = rowWrapper != null ? rowWrapper : DEFAULT_ROW_WRAPPER;
    }

    public void serialize(XMLStreamWriter xmlStreamWriter) throws XMLStreamException {
        xmlStreamWriter.writeStartElement("", this.rootWrapper, "");
        while (this.table.hasNext()) {
            this.table.moveToNext();
            xmlStreamWriter.writeStartElement("", this.rowWrapper, "");
            BStructureType structType = this.table.getStructType();
            BField[] structFields = null;
            if (structType != null) {
                structFields = structType.getFields().values().toArray(new BField[0]);
            }
            int index = 1;
            for (ColumnDefinition col : this.table.getColumnDefs()) {
                String name = structFields != null ? structFields[index - 1].getFieldName() : col.getName();
                this.writeElement(xmlStreamWriter, name, col.getTypeTag(), index, structFields);
                ++index;
            }
            xmlStreamWriter.writeEndElement();
        }
        xmlStreamWriter.writeEndElement();
        xmlStreamWriter.flush();
    }

    private void writeElement(XMLStreamWriter xmlStreamWriter, String name, int typeTag, int index, BField[] structFields) throws XMLStreamException {
        boolean isArray = false;
        xmlStreamWriter.writeStartElement("", name, "");
        String value2 = null;
        switch (typeTag) {
            case 6: {
                value2 = String.valueOf(this.table.getBoolean(index));
                break;
            }
            case 5: {
                value2 = this.table.getString(index);
                break;
            }
            case 1: {
                value2 = String.valueOf(this.table.getInt(index));
                break;
            }
            case 3: {
                value2 = String.valueOf(this.table.getFloat(index));
                break;
            }
            case 4: {
                value2 = String.valueOf(this.table.getDecimal(index));
                break;
            }
            case 36: {
                value2 = this.table.getBlob(index);
                break;
            }
            case 20: {
                isArray = true;
                Object[] array2 = this.table.getArray(index);
                this.processArray(xmlStreamWriter, array2);
                break;
            }
            case 12: 
            case 35: {
                isArray = true;
                Object[] structData = this.table.getStruct(index);
                if (structFields == null) {
                    this.processArray(xmlStreamWriter, structData);
                    break;
                }
                this.processStruct(xmlStreamWriter, structData, structFields, index);
                break;
            }
            default: {
                value2 = this.table.getString(index);
            }
        }
        if (!isArray) {
            if (value2 == null) {
                xmlStreamWriter.writeNamespace(XSI_PREFIX, XSI_NAMESPACE);
                xmlStreamWriter.writeAttribute(XSI_PREFIX, XSI_NAMESPACE, "nil", "true");
            } else {
                xmlStreamWriter.writeCharacters(value2);
            }
        }
        xmlStreamWriter.writeEndElement();
    }

    private void processArray(XMLStreamWriter xmlStreamWriter, Object[] array2) throws XMLStreamException {
        if (array2 != null) {
            for (Object value2 : array2) {
                xmlStreamWriter.writeStartElement("", ARRAY_ELEMENT_NAME, "");
                xmlStreamWriter.writeCharacters(String.valueOf(value2));
                xmlStreamWriter.writeEndElement();
            }
        }
    }

    private void processStruct(XMLStreamWriter xmlStreamWriter, Object[] structData, BField[] structFields, int index) throws XMLStreamException {
        try {
            BField[] internalStructFields;
            int i = 0;
            boolean structError = true;
            BType internaltType = structFields[index - 1].getFieldType();
            if ((internaltType.getTag() == 35 || internaltType.getTag() == 12) && (internalStructFields = ((BStructureType)internaltType).getFields().values().toArray(new BField[0])) != null) {
                for (Object val : structData) {
                    xmlStreamWriter.writeStartElement("", internalStructFields[i].getFieldName(), "");
                    if (val instanceof Struct) {
                        this.processStruct(xmlStreamWriter, ((Struct)val).getAttributes(), internalStructFields, i + 1);
                    } else {
                        xmlStreamWriter.writeCharacters(val.toString());
                    }
                    xmlStreamWriter.writeEndElement();
                    ++i;
                }
                structError = false;
            }
            if (structError) {
                throw BallerinaErrors.createError("error in constructing the xml element from struct type data");
            }
        }
        catch (SQLException e) {
            throw BallerinaErrors.createError("error in retrieving struct data to construct the inner xml element:" + e.getMessage());
        }
    }

    public boolean isDestructiveWrite() {
        return true;
    }
}

