/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.jvm;

import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.c14n.Canonicalizer;
import org.apache.axiom.c14n.exceptions.CanonicalizationException;
import org.apache.axiom.c14n.exceptions.InvalidCanonicalizerException;
import org.apache.axiom.om.DeferredParsingException;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMComment;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMDataSource;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMProcessingInstruction;
import org.apache.axiom.om.OMText;
import org.apache.axiom.om.OMXMLBuilderFactory;
import org.apache.axiom.om.impl.dom.TextImpl;
import org.apache.axiom.om.impl.llom.OMSourcedElementImpl;
import org.apache.axiom.om.util.StAXParserConfiguration;
import org.ballerinalang.jvm.BallerinaErrors;
import org.ballerinalang.jvm.JSONParser;
import org.ballerinalang.jvm.StringUtils;
import org.ballerinalang.jvm.TableOMDataSource;
import org.ballerinalang.jvm.XMLNodeType;
import org.ballerinalang.jvm.XMLValidator;
import org.ballerinalang.jvm.types.BArrayType;
import org.ballerinalang.jvm.types.BMapType;
import org.ballerinalang.jvm.types.BPackage;
import org.ballerinalang.jvm.types.BType;
import org.ballerinalang.jvm.types.BTypes;
import org.ballerinalang.jvm.values.ArrayValue;
import org.ballerinalang.jvm.values.ErrorValue;
import org.ballerinalang.jvm.values.MapValueImpl;
import org.ballerinalang.jvm.values.TableValue;
import org.ballerinalang.jvm.values.XMLItem;
import org.ballerinalang.jvm.values.XMLQName;
import org.ballerinalang.jvm.values.XMLSequence;
import org.ballerinalang.jvm.values.XMLValue;

public class XMLFactory {
    private static final String XML_NAMESPACE_PREFIX = "xmlns:";
    private static final String XML_VALUE_TAG = "#text";
    private static final String XML_DCLR_START = "<?xml";
    private static Canonicalizer canonicalizer = null;
    private static final String CANONICALIZER_OMIT_COMMENTS = "http://www.w3.org/TR/2001/REC-xml-c14n-20010315";
    private static final String CANONICALIZER_WITH_COMMENTS = "http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments";
    private static final String CANONICALIZER_EXCL_OMIT_COMMENTS = "http://www.w3.org/2001/10/xml-exc-c14n#";
    private static final String CANONICALIZER_EXCL_WITH_COMMENTS = "http://www.w3.org/2001/10/xml-exc-c14n#WithComments";
    private static final BType jsonMapType = new BMapType("map", BTypes.typeJSON, new BPackage(null, null, null));
    private static final OMFactory OM_FACTORY = OMAbstractFactory.getOMFactory();
    public static final StAXParserConfiguration STAX_PARSER_CONFIGURATION = StAXParserConfiguration.STANDALONE;

    public static XMLValue<?> parse(String xmlStr) {
        try {
            if (xmlStr.isEmpty()) {
                return new XMLItem((OMNode)new TextImpl());
            }
            if (xmlStr.trim().startsWith(XML_DCLR_START)) {
                return new XMLItem(xmlStr);
            }
            OMElement omElement = XMLFactory.stringToOM("<root>" + xmlStr + "</root>");
            Iterator children = omElement.getChildren();
            OMNode omNode = null;
            if (children.hasNext()) {
                omNode = (OMNode)children.next();
            }
            if (children.hasNext()) {
                throw BallerinaErrors.createError("xml item must be one of the types: 'element', 'comment', 'text', 'pi'");
            }
            omNode = omNode.detach();
            OMDocument doc = OM_FACTORY.createOMDocument();
            doc.addChild(omNode);
            return new XMLItem(omNode);
        }
        catch (ErrorValue e) {
            throw e;
        }
        catch (XMLStreamException | OMException e) {
            Throwable cause = e.getCause() == null ? e : e.getCause();
            throw BallerinaErrors.createError(cause.getMessage());
        }
        catch (Throwable e) {
            throw BallerinaErrors.createError("failed to parse xml: " + e.getMessage());
        }
    }

    public static XMLValue<?> parse(InputStream xmlStream) {
        ArrayValue elementsSeq = new ArrayValue(new BArrayType(BTypes.typeXML));
        try {
            OMDocument doc = OMXMLBuilderFactory.createOMBuilder((StAXParserConfiguration)STAX_PARSER_CONFIGURATION, (InputStream)xmlStream).getDocument();
            Iterator docChildItr = doc.getChildren();
            int i = 0;
            while (docChildItr.hasNext()) {
                elementsSeq.add((long)i++, new XMLItem((OMNode)docChildItr.next()));
            }
        }
        catch (DeferredParsingException e) {
            throw BallerinaErrors.createError(e.getCause().getMessage());
        }
        catch (Throwable e) {
            throw BallerinaErrors.createError("failed to create xml: " + e.getMessage());
        }
        return new XMLSequence(elementsSeq);
    }

    public static XMLValue<?> parse(InputStream xmlStream, String charset) {
        ArrayValue elementsSeq = new ArrayValue(new BArrayType(BTypes.typeXML));
        try {
            OMDocument doc = OMXMLBuilderFactory.createOMBuilder((StAXParserConfiguration)STAX_PARSER_CONFIGURATION, (InputStream)xmlStream, (String)charset).getDocument();
            Iterator docChildItr = doc.getChildren();
            int index = 0;
            while (docChildItr.hasNext()) {
                elementsSeq.add((long)index++, new XMLItem((OMNode)docChildItr.next()));
            }
        }
        catch (DeferredParsingException e) {
            throw BallerinaErrors.createError(e.getCause().getMessage());
        }
        catch (Throwable e) {
            throw BallerinaErrors.createError("failed to create xml: " + e.getMessage());
        }
        return new XMLSequence(elementsSeq);
    }

    public static XMLValue<?> parse(Reader reader) {
        ArrayValue elementsSeq = new ArrayValue(new BArrayType(BTypes.typeXML));
        try {
            OMDocument doc = OMXMLBuilderFactory.createOMBuilder((StAXParserConfiguration)STAX_PARSER_CONFIGURATION, (Reader)reader).getDocument();
            Iterator docChildItr = doc.getChildren();
            int i = 0;
            while (docChildItr.hasNext()) {
                elementsSeq.add((long)i++, new XMLItem((OMNode)docChildItr.next()));
            }
        }
        catch (DeferredParsingException e) {
            throw BallerinaErrors.createError(e.getCause().getMessage());
        }
        catch (Throwable e) {
            throw BallerinaErrors.createError("failed to create xml: " + e.getMessage());
        }
        return new XMLSequence(elementsSeq);
    }

    public static XMLValue<?> concatenate(XMLValue<?> firstSeq, XMLValue<?> secondSeq) {
        int i;
        ArrayValue seq;
        ArrayValue concatSeq = new ArrayValue(new BArrayType(BTypes.typeXML));
        int j = 0;
        firstSeq.build();
        secondSeq.build();
        if (firstSeq.getNodeType() == XMLNodeType.SEQUENCE) {
            seq = ((XMLSequence)firstSeq).value();
            for (i = 0; i < seq.size(); ++i) {
                concatSeq.add((long)j++, seq.getRefValue(i));
            }
        } else {
            concatSeq.add((long)j++, firstSeq);
        }
        if (secondSeq.getNodeType() == XMLNodeType.SEQUENCE) {
            seq = ((XMLSequence)secondSeq).value();
            for (i = 0; i < seq.size(); ++i) {
                concatSeq.add((long)j++, seq.getRefValue(i));
            }
        } else {
            concatSeq.add((long)j++, secondSeq);
        }
        return new XMLSequence(concatSeq);
    }

    public static XMLValue tableToXML(TableValue table2) {
        OMSourcedElementImpl omSourcedElement = new OMSourcedElementImpl();
        omSourcedElement.init((OMDataSource)new TableOMDataSource(table2, null, null));
        return new XMLItem((OMNode)omSourcedElement);
    }

    public static XMLValue<?> createXMLElement(XMLQName startTagName, XMLQName endTagName, String defaultNsUri) {
        OMElement omElement;
        String prefix;
        if (!(StringUtils.isEqual(startTagName.getLocalName(), endTagName.getLocalName()) && StringUtils.isEqual(startTagName.getUri(), endTagName.getUri()) && StringUtils.isEqual(startTagName.getPrefix(), endTagName.getPrefix()))) {
            throw BallerinaErrors.createError("start and end tag names mismatch: '" + startTagName + "' and '" + endTagName + "'");
        }
        XMLValidator.validateXMLQName(startTagName);
        String nsUri = startTagName.getUri();
        if (defaultNsUri == null) {
            defaultNsUri = "";
        }
        String string2 = prefix = startTagName.getPrefix() == null ? "" : startTagName.getPrefix();
        if (nsUri == null) {
            omElement = OM_FACTORY.createOMElement(startTagName.getLocalName(), defaultNsUri, prefix);
        } else if (nsUri.isEmpty()) {
            omElement = OM_FACTORY.createOMElement(startTagName.getLocalName(), nsUri, prefix);
        } else if (nsUri.equals(defaultNsUri)) {
            omElement = OM_FACTORY.createOMElement(startTagName.getLocalName(), defaultNsUri, prefix);
        } else {
            QName qname = XMLFactory.getQName(startTagName.getLocalName(), nsUri, prefix);
            omElement = OM_FACTORY.createOMElement(qname);
            if (!defaultNsUri.isEmpty()) {
                omElement.declareDefaultNamespace(defaultNsUri);
            }
        }
        return new XMLItem((OMNode)omElement);
    }

    public static XMLValue<?> createXMLComment(String content) {
        OMComment omComment = OM_FACTORY.createOMComment((OMContainer)OM_FACTORY.createOMDocument(), content);
        return new XMLItem((OMNode)omComment);
    }

    public static XMLValue<?> createXMLText(String content) {
        content = content.replace("\r\n", "\n");
        content = content.replace("&gt;", ">").replace("&lt;", "<").replace("&amp;", "&");
        OMText omText = OM_FACTORY.createOMText(content);
        return new XMLItem((OMNode)omText);
    }

    public static XMLValue<?> createXMLProcessingInstruction(String tartget, String data) {
        OMProcessingInstruction omText = OM_FACTORY.createOMProcessingInstruction((OMContainer)OM_FACTORY.createOMDocument(), tartget, data);
        return new XMLItem((OMNode)omText);
    }

    public static Object convertToJSON(XMLValue xml2, String attributePrefix, boolean preserveNamespaces) {
        Object json = null;
        if (xml2 instanceof XMLItem) {
            XMLItem xmlItem = (XMLItem)xml2;
            OMNode omNode = xmlItem.value();
            json = 1 == omNode.getType() ? XMLFactory.traverseXMLElement((OMElement)omNode, attributePrefix, preserveNamespaces) : (4 == omNode.getType() ? JSONParser.parse("\"" + ((OMText)omNode).getText() + "\"") : new MapValueImpl(jsonMapType));
        } else {
            XMLSequence xmlSequence = (XMLSequence)xml2;
            if (xmlSequence.isEmpty()) {
                return new ArrayValue(new BArrayType(BTypes.typeJSON));
            }
            json = XMLFactory.traverseXMLSequence(xmlSequence, attributePrefix, preserveNamespaces);
        }
        return json;
    }

    public static boolean isEqual(XMLValue<?> xmlOne, XMLValue<?> xmlTwo) {
        XMLNodeType xmlOneNodeType = xmlOne.getNodeType();
        XMLNodeType xmlTwoNodeType = xmlTwo.getNodeType();
        try {
            if (xmlOneNodeType == XMLNodeType.SEQUENCE && xmlTwoNodeType == XMLNodeType.SEQUENCE) {
                return XMLFactory.isXmlSequenceEqual((XMLSequence)xmlOne, (XMLSequence)xmlTwo);
            }
            if (xmlOneNodeType != XMLNodeType.SEQUENCE && xmlTwoNodeType != XMLNodeType.SEQUENCE) {
                return XMLFactory.isXmlItemEqual((XMLItem)xmlOne, (XMLItem)xmlTwo);
            }
            if (xmlOneNodeType == XMLNodeType.SEQUENCE && xmlOne.isSingleton()) {
                return XMLFactory.isXmlSingletonSequenceItemEqual((XMLSequence)xmlOne, (XMLItem)xmlTwo);
            }
            if (xmlTwoNodeType == XMLNodeType.SEQUENCE && xmlTwo.isSingleton()) {
                return XMLFactory.isXmlSingletonSequenceItemEqual((XMLSequence)xmlTwo, (XMLItem)xmlOne);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private static boolean isXmlSequenceEqual(XMLSequence xmlSequenceOne, XMLSequence xmlSequenceTwo) {
        if (xmlSequenceOne.size() != xmlSequenceTwo.size()) {
            return false;
        }
        for (int i = 0; i < xmlSequenceOne.size(); ++i) {
            if (XMLFactory.isEqual((XMLValue)xmlSequenceOne.value().getRefValue(i), (XMLValue)xmlSequenceTwo.value().getRefValue(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean isXmlItemEqual(XMLItem xmlItemOne, XMLItem xmlItemTwo) throws CanonicalizationException {
        switch (xmlItemOne.getNodeType()) {
            case ELEMENT: {
                return Arrays.equals(XMLFactory.canonicalize(xmlItemOne), XMLFactory.canonicalize(xmlItemTwo));
            }
        }
        return xmlItemOne.toString().equals(xmlItemTwo.toString());
    }

    private static boolean isXmlSingletonSequenceItemEqual(XMLSequence singletonXmlSequence, XMLItem xmlItem) throws CanonicalizationException {
        switch (xmlItem.getNodeType()) {
            case ELEMENT: {
                return Arrays.equals(XMLFactory.canonicalize((XMLItem)singletonXmlSequence.getItem(0)), XMLFactory.canonicalize(xmlItem));
            }
        }
        return singletonXmlSequence.getItem(0).toString().equals(xmlItem.toString());
    }

    private static byte[] canonicalize(XMLItem bxmlItem) throws CanonicalizationException {
        return canonicalizer.canonicalize(bxmlItem.value().toString().getBytes());
    }

    private static MapValueImpl<String, Object> traverseXMLElement(OMElement omElement, String attributePrefix, boolean preserveNamespaces) {
        MapValueImpl<String, Object> rootNode = new MapValueImpl<String, Object>(jsonMapType);
        LinkedHashMap<String, String> attributeMap = XMLFactory.collectAttributesAndNamespaces(omElement, preserveNamespaces);
        Iterator iterator = omElement.getChildElements();
        String keyValue = XMLFactory.getElementKey(omElement, preserveNamespaces);
        if (iterator.hasNext()) {
            MapValueImpl<String, Object> currentRoot = new MapValueImpl<String, Object>(jsonMapType);
            ArrayList<OMElement> childArray = new ArrayList<OMElement>();
            LinkedHashMap<String, ArrayList<Object>> rootMap = new LinkedHashMap<String, ArrayList<Object>>();
            while (iterator.hasNext()) {
                OMNode node = (OMNode)iterator.next();
                if (1 != node.getType()) continue;
                OMElement omChildElement = (OMElement)node;
                LinkedHashMap<String, String> childAttributeMap = XMLFactory.collectAttributesAndNamespaces(omChildElement, preserveNamespaces);
                Iterator iteratorChild = omChildElement.getChildElements();
                String childKeyValue = XMLFactory.getElementKey(omChildElement, preserveNamespaces);
                if (iteratorChild.hasNext()) {
                    MapValueImpl<String, Object> nodeIntermediate = XMLFactory.traverseXMLElement(omChildElement, attributePrefix, preserveNamespaces);
                    XMLFactory.addToRootMap(rootMap, childKeyValue, nodeIntermediate.get(childKeyValue));
                    continue;
                }
                if (childAttributeMap.size() > 0) {
                    MapValueImpl<String, Object> attrObject = XMLFactory.processAttributeAndNamespaces(null, childAttributeMap, attributePrefix, omChildElement.getText());
                    XMLFactory.addToRootMap(rootMap, childKeyValue, attrObject);
                    continue;
                }
                childArray.add(omChildElement);
            }
            XMLFactory.processAttributeAndNamespaces(currentRoot, attributeMap, attributePrefix, null);
            XMLFactory.processChildelements(currentRoot, childArray, attributePrefix, preserveNamespaces);
            XMLFactory.processRootNodes(currentRoot, rootMap);
            rootNode.put(keyValue, currentRoot);
        } else if (attributeMap.size() > 0) {
            MapValueImpl<String, Object> attrObject = XMLFactory.processAttributeAndNamespaces(null, attributeMap, attributePrefix, omElement.getText());
            rootNode.put(keyValue, attrObject);
        } else {
            rootNode.put(keyValue, omElement.getText());
        }
        return rootNode;
    }

    private static Object traverseXMLSequence(XMLSequence xmlSequence, String attributePrefix, boolean preserveNamespaces) {
        ArrayValue sequence = xmlSequence.value();
        long count = sequence.size();
        ArrayList<OMElement> childArray = new ArrayList<OMElement>();
        ArrayList<OMText> textArray = new ArrayList<OMText>();
        int i = 0;
        while ((long)i < count) {
            XMLItem xmlItem = (XMLItem)sequence.getRefValue(i);
            OMNode omNode = xmlItem.value();
            if (1 == omNode.getType()) {
                childArray.add((OMElement)omNode);
            } else if (4 == omNode.getType()) {
                textArray.add((OMText)omNode);
            }
            ++i;
        }
        ArrayValue textArrayNode = null;
        if (textArray.size() > 0) {
            textArrayNode = XMLFactory.processTextArray(textArray);
        }
        MapValueImpl<String, Object> jsonNode = new MapValueImpl<String, Object>(jsonMapType);
        if (childArray.size() > 0) {
            XMLFactory.processChildelements(jsonNode, childArray, attributePrefix, preserveNamespaces);
            if (textArrayNode != null) {
                textArrayNode.append(jsonNode);
            }
        }
        if (textArrayNode != null) {
            return textArrayNode;
        }
        return jsonNode;
    }

    private static void processChildelements(MapValueImpl<String, Object> root, ArrayList<OMElement> childArray, String attributePrefix, boolean preserveNamespaces) {
        LinkedHashMap rootMap = new LinkedHashMap();
        for (OMElement oMElement : childArray) {
            String key = oMElement.getLocalName();
            rootMap.putIfAbsent(key, new ArrayList());
            ((ArrayList)rootMap.get(key)).add(oMElement);
        }
        for (Map.Entry entry : rootMap.entrySet()) {
            ArrayList elementList = (ArrayList)entry.getValue();
            if (elementList.size() <= 0) continue;
            String nodeKey = XMLFactory.getElementKey((OMElement)elementList.get(0), preserveNamespaces);
            if (elementList.size() == 1) {
                OMElement element = (OMElement)elementList.get(0);
                if (element.getChildElements().hasNext()) {
                    MapValueImpl<String, Object> node = XMLFactory.traverseXMLElement(element, attributePrefix, preserveNamespaces);
                    root.put(nodeKey, node.get(nodeKey));
                    continue;
                }
                root.put(nodeKey, ((OMElement)elementList.get(0)).getText());
                continue;
            }
            ArrayValue arrayNode = new ArrayValue(new BArrayType(BTypes.typeJSON));
            for (OMElement element : elementList) {
                arrayNode.append(element.getText());
            }
            root.put(nodeKey, arrayNode);
        }
    }

    private static void processRootNodes(MapValueImpl<String, Object> root, LinkedHashMap<String, ArrayList<Object>> rootMap) {
        for (Map.Entry<String, ArrayList<Object>> entry : rootMap.entrySet()) {
            String key = entry.getKey();
            ArrayList<Object> elementList = entry.getValue();
            int elementCount = elementList.size();
            if (elementCount == 1) {
                root.put(key, elementList.get(0));
                continue;
            }
            ArrayValue arrayNode = new ArrayValue(new BArrayType(BTypes.typeJSON));
            for (Object node : elementList) {
                arrayNode.append(node);
            }
            root.put(key, arrayNode);
        }
    }

    private static LinkedHashMap<String, String> collectAttributesAndNamespaces(OMElement element, boolean preserveNamespaces) {
        LinkedHashMap<String, String> attributeMap = new LinkedHashMap<String, String>();
        if (preserveNamespaces) {
            Iterator namespaceIterator = element.getAllDeclaredNamespaces();
            while (namespaceIterator.hasNext()) {
                OMNamespace namespace = (OMNamespace)namespaceIterator.next();
                attributeMap.put(XML_NAMESPACE_PREFIX + namespace.getPrefix(), namespace.getNamespaceURI());
            }
        }
        Iterator attributeIterator = element.getAllAttributes();
        while (attributeIterator.hasNext()) {
            String prefix;
            OMAttribute attribute = (OMAttribute)attributeIterator.next();
            StringBuffer key = new StringBuffer();
            if (preserveNamespaces && (prefix = attribute.getPrefix()) != null) {
                key.append(prefix).append(":");
            }
            key.append(attribute.getLocalName());
            attributeMap.put(key.toString(), attribute.getAttributeValue());
        }
        return attributeMap;
    }

    private static MapValueImpl<String, Object> processAttributeAndNamespaces(MapValueImpl<String, Object> rootNode, LinkedHashMap<String, String> attributeMap, String attributePrefix, String singleElementValue) {
        boolean singleElement = false;
        if (rootNode == null) {
            rootNode = new MapValueImpl(jsonMapType);
            singleElement = true;
        }
        for (Map.Entry<String, String> entry : attributeMap.entrySet()) {
            String key = attributePrefix + entry.getKey();
            rootNode.put(key, entry.getValue());
        }
        if (singleElement && !singleElementValue.isEmpty()) {
            rootNode.put(XML_VALUE_TAG, singleElementValue);
        }
        return rootNode;
    }

    private static ArrayValue processTextArray(ArrayList<OMText> childArray) {
        ArrayValue arrayNode = new ArrayValue(new BArrayType(BTypes.typeJSON));
        for (OMText element : childArray) {
            arrayNode.append(element.getText());
        }
        return arrayNode;
    }

    private static String getElementKey(OMElement omElement, boolean preserveNamespaces) {
        String prefix;
        StringBuffer stringBuffer = new StringBuffer();
        if (preserveNamespaces && (prefix = omElement.getPrefix()) != null) {
            stringBuffer.append(prefix).append(":");
        }
        stringBuffer.append(omElement.getLocalName());
        return stringBuffer.toString();
    }

    private static void addToRootMap(LinkedHashMap<String, ArrayList<Object>> rootMap, String key, Object node) {
        rootMap.putIfAbsent(key, new ArrayList());
        rootMap.get(key).add(node);
    }

    private static QName getQName(String localName, String namespaceUri, String prefix) {
        QName qname = prefix != null ? new QName(namespaceUri, localName, prefix) : new QName(namespaceUri, localName);
        return qname;
    }

    public static OMElement stringToOM(String xmlFragment) throws XMLStreamException {
        return XMLFactory.stringToOM(OMAbstractFactory.getOMFactory(), xmlFragment);
    }

    private static OMElement stringToOM(OMFactory omFactory, String xmlFragment) throws XMLStreamException {
        return xmlFragment != null ? OMXMLBuilderFactory.createOMBuilder((OMFactory)omFactory, (StAXParserConfiguration)STAX_PARSER_CONFIGURATION, (Reader)new StringReader(xmlFragment)).getDocumentElement() : null;
    }

    static {
        Canonicalizer.init();
        try {
            Canonicalizer.register(CANONICALIZER_OMIT_COMMENTS, "org.apache.axiom.c14n.impl.Canonicalizer20010315OmitComments");
            Canonicalizer.register(CANONICALIZER_WITH_COMMENTS, "org.apache.axiom.c14n.impl.Canonicalizer20010315WithComments");
            Canonicalizer.register(CANONICALIZER_EXCL_OMIT_COMMENTS, "org.apache.axiom.c14n.impl.Canonicalizer20010315ExclOmitComments");
            Canonicalizer.register(CANONICALIZER_EXCL_WITH_COMMENTS, "org.apache.axiom.c14n.impl.Canonicalizer20010315ExclWithComments");
            canonicalizer = Canonicalizer.getInstance(CANONICALIZER_WITH_COMMENTS);
        }
        catch (InvalidCanonicalizerException e) {
            throw BallerinaErrors.createError("Error initializing canonicalizer: " + e.getMessage());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

