/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.jvm.scheduling;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.ballerinalang.jvm.TypeChecker;
import org.ballerinalang.jvm.observability.ObserverContext;
import org.ballerinalang.jvm.scheduling.Scheduler;
import org.ballerinalang.jvm.scheduling.SchedulerItem;
import org.ballerinalang.jvm.scheduling.State;
import org.ballerinalang.jvm.scheduling.WDChannels;
import org.ballerinalang.jvm.scheduling.WaitAnyContext;
import org.ballerinalang.jvm.scheduling.WaitContext;
import org.ballerinalang.jvm.scheduling.WaitMultipleContext;
import org.ballerinalang.jvm.scheduling.WorkerDataChannel;
import org.ballerinalang.jvm.transactions.TransactionLocalContext;
import org.ballerinalang.jvm.types.BTypes;
import org.ballerinalang.jvm.values.ChannelDetails;
import org.ballerinalang.jvm.values.ErrorValue;
import org.ballerinalang.jvm.values.FutureValue;
import org.ballerinalang.jvm.values.MapValue;

public class Strand {
    public Object[] frames;
    public int resumeIndex;
    public Object returnValue;
    public Scheduler scheduler;
    public Strand parent = null;
    public WDChannels wdChannels;
    public FlushDetail flushDetail;
    public boolean blockedOnExtern;
    public Set<ChannelDetails> channelDetails;
    public Set<SchedulerItem> dependants;
    public ObserverContext observerContext;
    public boolean cancel;
    SchedulerItem schedulerItem;
    List<WaitContext> waitingContexts;
    WaitContext waitContext;
    private Map<String, Object> globalProps;
    private TransactionLocalContext transactionStrandContext;
    private State state;
    private final ReentrantLock strandLock;

    public Strand(Scheduler scheduler) {
        this.scheduler = scheduler;
        this.wdChannels = new WDChannels();
        this.channelDetails = new HashSet<ChannelDetails>();
        this.globalProps = new HashMap<String, Object>();
        this.state = State.RUNNABLE;
        this.dependants = new HashSet<SchedulerItem>();
        this.strandLock = new ReentrantLock();
        this.waitingContexts = new ArrayList<WaitContext>();
    }

    public Strand(Scheduler scheduler, Strand parent, Map<String, Object> properties) {
        this(scheduler);
        this.parent = parent;
        this.globalProps = properties != null ? properties : new HashMap();
    }

    public void handleChannelError(ChannelDetails[] channels, ErrorValue error2) {
        for (int i = 0; i < channels.length; ++i) {
            ChannelDetails channelDetails = channels[i];
            WorkerDataChannel channel = this.getWorkerDataChannel(channelDetails);
            if (channels[i].send) {
                channel.setSendError(error2);
                continue;
            }
            channel.setReceiveError(error2);
        }
    }

    public void setReturnValues(Object returnValue) {
        this.returnValue = returnValue;
    }

    public Object getProperty(String key) {
        return this.globalProps.get(key);
    }

    public void setProperty(String key, Object value2) {
        this.globalProps.put(key, value2);
    }

    public boolean isInTransaction() {
        return this.transactionStrandContext != null;
    }

    public void setLocalTransactionContext(TransactionLocalContext transactionLocalContext) {
        this.transactionStrandContext = transactionLocalContext;
    }

    public TransactionLocalContext getLocalTransactionContext() {
        return this.transactionStrandContext;
    }

    public void removeLocalTransactionContext() {
        this.transactionStrandContext = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ErrorValue handleFlush(ChannelDetails[] channels) throws Throwable {
        try {
            if (this.flushDetail == null) {
                this.flushDetail = new FlushDetail(channels);
            }
            this.flushDetail.flushLock.lock();
            if (this.flushDetail.inProgress) {
                if (this.flushDetail.panic != null) {
                    throw this.flushDetail.panic;
                }
                ErrorValue result = this.flushDetail.result;
                this.cleanUpFlush(channels);
                ErrorValue errorValue = result;
                return errorValue;
            }
            this.flushDetail.panic = null;
            this.flushDetail.result = null;
            this.flushDetail.flushChannels = channels;
            for (int i = 0; i < channels.length; ++i) {
                ErrorValue error2 = this.getWorkerDataChannel(channels[i]).flushChannel(this);
                if (error2 != null) {
                    this.cleanUpFlush(channels);
                    ErrorValue errorValue = error2;
                    return errorValue;
                }
                if (this.flushDetail.flushedCount != this.flushDetail.flushChannels.length) continue;
                this.cleanUpFlush(channels);
                ErrorValue errorValue = null;
                return errorValue;
            }
            this.flushDetail.inProgress = true;
            this.setState(State.BLOCK_AND_YIELD);
            ErrorValue errorValue = null;
            return errorValue;
        }
        finally {
            this.flushDetail.flushLock.unlock();
        }
    }

    private void cleanUpFlush(ChannelDetails[] channels) {
        this.flushDetail.inProgress = false;
        this.flushDetail.flushedCount = 0;
        this.flushDetail.result = null;
        for (ChannelDetails channel : channels) {
            this.getWorkerDataChannel(channel).removeFlushWait();
        }
    }

    public void handleWaitMultiple(Map<String, FutureValue> keyValues, MapValue target) throws Throwable {
        WaitMultipleContext ctx = new WaitMultipleContext(this.schedulerItem);
        ctx.waitCount.set(keyValues.size());
        ctx.lock();
        for (Map.Entry<String, FutureValue> entry : keyValues.entrySet()) {
            FutureValue future2 = entry.getValue();
            future2.strand.lock();
            if (future2.isDone) {
                if (future2.panic != null) {
                    ctx.completed = true;
                    ctx.waitCount.set(0);
                    this.setState(State.RUNNABLE);
                    future2.strand.unlock();
                    ctx.unLock();
                    throw future2.panic;
                }
                ctx.waitCount.decrementAndGet();
                target.put(entry.getKey(), future2.result);
            } else {
                this.setState(State.BLOCK_ON_AND_YIELD);
                entry.getValue().strand.waitingContexts.add(ctx);
            }
            future2.strand.unlock();
        }
        if (!this.isBlocked()) {
            ctx.waitCount.set(0);
            ctx.completed = true;
        } else {
            this.waitContext = ctx;
            ctx.intermediate = true;
        }
        ctx.unLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WaitResult handleWaitAny(List<FutureValue> futures) throws Throwable {
        WaitResult waitResult = new WaitResult(false, null);
        WaitAnyContext ctx = new WaitAnyContext(this.schedulerItem);
        ctx.lock();
        ctx.waitCount.set(futures.size());
        Object error2 = null;
        for (FutureValue future2 : futures) {
            try {
                future2.strand.lock();
                if (future2.isDone) {
                    if (future2.panic != null) {
                        ctx.completed = true;
                        ctx.unLock();
                        throw future2.panic;
                    }
                    if (TypeChecker.checkIsType(future2.result, BTypes.typeError)) {
                        ctx.waitCount.decrementAndGet();
                        error2 = future2.result;
                        continue;
                    }
                    waitResult = new WaitResult(true, future2.result);
                    break;
                }
                future2.strand.waitingContexts.add(ctx);
            }
            finally {
                future2.strand.unlock();
            }
        }
        if (waitResult.done) {
            ctx.completed = true;
        } else if (ctx.waitCount.get() == 0) {
            ctx.completed = true;
            waitResult = new WaitResult(true, error2);
        } else {
            this.waitContext = ctx;
            this.setState(State.BLOCK_ON_AND_YIELD);
        }
        ctx.unLock();
        return waitResult;
    }

    public void updateChannelDetails(ChannelDetails[] channels) {
        for (ChannelDetails channel : channels) {
            this.channelDetails.add(channel);
        }
    }

    private WorkerDataChannel getWorkerDataChannel(ChannelDetails channel) {
        WorkerDataChannel dataChannel = channel.channelInSameStrand ? this.wdChannels.getWorkerDataChannel(channel.name) : this.parent.wdChannels.getWorkerDataChannel(channel.name);
        return dataChannel;
    }

    public void setState(State state) {
        this.lock();
        this.state = state;
        this.unlock();
    }

    public State getState() {
        return this.state;
    }

    public boolean isBlocked() {
        return (this.state.getStatus() & State.BLOCK_AND_YIELD.getStatus()) == State.BLOCK_AND_YIELD.getStatus();
    }

    public boolean isBlockedOn() {
        return (this.state.getStatus() & State.BLOCK_ON_AND_YIELD.getStatus()) == State.BLOCK_ON_AND_YIELD.getStatus();
    }

    public boolean isYielded() {
        return (this.state.getStatus() & State.YIELD.getStatus()) == State.YIELD.getStatus();
    }

    public boolean isBlockedOnExtern() {
        return this.blockedOnExtern;
    }

    public void lock() {
        this.strandLock.lock();
    }

    public void unlock() {
        this.strandLock.unlock();
    }

    public static class WaitResult {
        public boolean done;
        public Object result;

        public WaitResult(boolean done, Object result) {
            this.done = done;
            this.result = result;
        }
    }

    public static class FlushDetail {
        public ChannelDetails[] flushChannels;
        public int flushedCount;
        public Lock flushLock;
        public ErrorValue result;
        public boolean inProgress;
        public Throwable panic;

        public FlushDetail(ChannelDetails[] flushChannels) {
            this.flushChannels = flushChannels;
            this.flushedCount = 0;
            this.flushLock = new ReentrantLock();
            this.result = null;
            this.inProgress = false;
        }
    }
}

