/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.jvm.types;

import java.util.Arrays;
import org.ballerinalang.jvm.types.AnnotatableType;
import org.ballerinalang.jvm.types.BPackage;
import org.ballerinalang.jvm.types.BType;
import org.ballerinalang.jvm.types.BTypes;

public class BFunctionType
extends AnnotatableType {
    public BType[] paramTypes;
    public BType retType;

    public BFunctionType() {
        super("function ()", (BPackage)null, Object.class);
        this.paramTypes = new BType[0];
        this.retType = BTypes.typeNull;
    }

    public BFunctionType(BType[] paramTypes, BType retType) {
        super("function ()", (BPackage)null, Object.class);
        this.paramTypes = paramTypes;
        this.retType = retType;
    }

    public BType[] getParameterType() {
        return this.paramTypes;
    }

    public BType getReturnParameterType() {
        return this.retType;
    }

    @Override
    public <V> V getZeroValue() {
        return null;
    }

    @Override
    public <V> V getEmptyValue() {
        return null;
    }

    @Override
    public int getTag() {
        return 37;
    }

    public static String getTypeName(BType[] parameterType, BType retType) {
        return "function (" + (parameterType != null ? BFunctionType.getBTypeListAsString(parameterType) : "") + ")" + (retType != null ? " returns (" + retType + ")" : "");
    }

    private static String getBTypeListAsString(BType[] typeNames) {
        StringBuffer br = new StringBuffer();
        int i = 0;
        for (BType type : typeNames) {
            br.append(type.getName());
            if (++i >= typeNames.length) continue;
            br.append(",");
        }
        return br.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BFunctionType)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BFunctionType that = (BFunctionType)o;
        if (!Arrays.equals(this.paramTypes, that.paramTypes)) {
            return false;
        }
        return this.retType.equals(that.retType);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Arrays.hashCode(this.paramTypes);
        result = 31 * result + this.retType.hashCode();
        return result;
    }

    @Override
    public String toString() {
        return BFunctionType.getTypeName(this.paramTypes, this.retType);
    }

    @Override
    public String getAnnotationKey() {
        return this.typeName;
    }
}

