/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.jvm.types;

import java.util.Map;
import java.util.StringJoiner;
import org.ballerinalang.jvm.BallerinaValues;
import org.ballerinalang.jvm.types.AttachedFunction;
import org.ballerinalang.jvm.types.BField;
import org.ballerinalang.jvm.types.BPackage;
import org.ballerinalang.jvm.types.BStructureType;

public class BObjectType
extends BStructureType {
    private AttachedFunction[] attachedFunctions;
    public AttachedFunction initializer;
    public AttachedFunction defaultsValuesInitFunc;

    public BObjectType(String typeName, BPackage pkg, int flags) {
        super(typeName, pkg, flags, Object.class);
    }

    @Override
    public <V> V getZeroValue() {
        return (V)BallerinaValues.createObjectValue(this.pkg.toString(), this.typeName, new Object[0]);
    }

    @Override
    public String getAnnotationKey() {
        return this.typeName;
    }

    @Override
    public <V> V getEmptyValue() {
        return null;
    }

    @Override
    public int getTag() {
        return 35;
    }

    public AttachedFunction[] getAttachedFunctions() {
        return this.attachedFunctions;
    }

    public void setAttachedFunctions(AttachedFunction[] attachedFunctions) {
        this.attachedFunctions = attachedFunctions;
    }

    public void setInitializer(AttachedFunction initializer) {
        this.initializer = initializer;
    }

    @Override
    public String toString() {
        String name;
        String string2 = name = this.pkg == null || this.pkg.getName() == null || this.pkg.getName().equals(".") ? this.typeName : this.pkg.getName() + ":" + this.typeName;
        if (!this.typeName.contains("$anon")) {
            return name;
        }
        StringJoiner sj = new StringJoiner(",\n\t", name + " {\n\t", "\n}");
        for (Map.Entry<String, BField> field : this.getFields().entrySet()) {
            sj.add(field.getKey() + " : " + field.getValue().type);
        }
        for (AttachedFunction func : this.attachedFunctions) {
            sj.add(func.toString());
        }
        return sj.toString();
    }
}

