/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.jvm.types;

import java.util.ArrayList;
import org.ballerinalang.jvm.TypeChecker;
import org.ballerinalang.jvm.types.BPackage;
import org.ballerinalang.jvm.types.BType;
import org.ballerinalang.jvm.types.BTypes;
import org.ballerinalang.jvm.values.TableValue;

public class BTableType
extends BType {
    private BType constraint;

    public BTableType(String typeName, BType constraint, BPackage pkg) {
        super(typeName, pkg, TableValue.class);
        this.constraint = constraint;
    }

    public BTableType(BType constraint) {
        super("table", null, TableValue.class);
        this.constraint = constraint;
    }

    public BType getConstrainedType() {
        return this.constraint;
    }

    @Deprecated
    public BType getElementType() {
        return this.constraint;
    }

    @Override
    public <V> V getZeroValue() {
        return (V)new TableValue(this, null, null, null);
    }

    @Override
    public <V> V getEmptyValue() {
        return this.getZeroValue();
    }

    @Override
    public int getTag() {
        return 9;
    }

    @Override
    public String toString() {
        if (this.constraint == BTypes.typeAnydata) {
            return super.toString();
        }
        return "table<" + this.constraint.getName() + ">";
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj) || !(obj instanceof BTableType)) {
            return false;
        }
        BTableType other = (BTableType)obj;
        if (this.constraint == other.constraint) {
            return true;
        }
        return TypeChecker.checkIsType(this.constraint, other.constraint, new ArrayList<TypeChecker.TypePair>());
    }
}

