/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.jvm.types;

import java.util.Arrays;
import java.util.HashMap;
import org.ballerinalang.jvm.types.BAnyType;
import org.ballerinalang.jvm.types.BAnydataType;
import org.ballerinalang.jvm.types.BArrayType;
import org.ballerinalang.jvm.types.BBooleanType;
import org.ballerinalang.jvm.types.BByteType;
import org.ballerinalang.jvm.types.BDecimalType;
import org.ballerinalang.jvm.types.BErrorType;
import org.ballerinalang.jvm.types.BField;
import org.ballerinalang.jvm.types.BFloatType;
import org.ballerinalang.jvm.types.BFutureType;
import org.ballerinalang.jvm.types.BHandleType;
import org.ballerinalang.jvm.types.BIntegerType;
import org.ballerinalang.jvm.types.BIteratorType;
import org.ballerinalang.jvm.types.BJSONType;
import org.ballerinalang.jvm.types.BMapType;
import org.ballerinalang.jvm.types.BNullType;
import org.ballerinalang.jvm.types.BPackage;
import org.ballerinalang.jvm.types.BRecordType;
import org.ballerinalang.jvm.types.BServiceType;
import org.ballerinalang.jvm.types.BStreamType;
import org.ballerinalang.jvm.types.BStringType;
import org.ballerinalang.jvm.types.BTableType;
import org.ballerinalang.jvm.types.BType;
import org.ballerinalang.jvm.types.BTypedescType;
import org.ballerinalang.jvm.types.BUnionType;
import org.ballerinalang.jvm.types.BXMLAttributesType;
import org.ballerinalang.jvm.types.BXMLType;

public class BTypes {
    public static BType typeInt = new BIntegerType("int", new BPackage(null, null, null));
    public static BType typeByte = new BByteType("byte", new BPackage(null, null, null));
    public static BType typeFloat = new BFloatType("float", new BPackage(null, null, null));
    public static BType typeDecimal = new BDecimalType("decimal", new BPackage(null, null, null));
    public static BType typeString = new BStringType("string", new BPackage(null, null, null));
    public static BType typeBoolean = new BBooleanType("boolean", new BPackage(null, null, null));
    public static BType typeXML = new BXMLType("xml", new BPackage(null, null, null));
    public static BType typeJSON = new BJSONType("json", new BPackage(null, null, null));
    public static BType typeAny = new BAnyType("any", new BPackage(null, null, null));
    public static BType typeAnydata = new BAnydataType("anydata", new BPackage(null, null, null));
    public static BType typeStream = new BStreamType("stream", typeAny, new BPackage(null, null, null));
    public static BType typeTypedesc = new BTypedescType("typedesc", new BPackage(null, null, null));
    public static BType typeMap = new BMapType("map", typeAny, new BPackage(null, null, null));
    public static BType typeTable = new BTableType("table", typeAnydata, new BPackage(null, null, null));
    public static BType typeFuture = new BFutureType("future", new BPackage(null, null, null));
    public static BType typeNull = new BNullType("()", new BPackage(null, null, null));
    public static BType typeXMLAttributes = new BXMLAttributesType("xml-attributes", new BPackage(null, null, null));
    public static BType typeIterator = new BIteratorType("iterator", new BPackage(null, null, null));
    public static BType typeAnyService = new BServiceType("service", new BPackage(null, null, null), 0);
    public static BRecordType typeErrorDetail = new BRecordType("detail", new BPackage(null, null, null), 0, false);
    public static BErrorType typeError = new BErrorType("error", new BPackage(null, null, null), typeString, typeErrorDetail);
    public static BType typePureType = new BUnionType(Arrays.asList(typeAnydata, typeError));
    public static BType typeAllType = new BUnionType(Arrays.asList(typeAny, typeError));
    public static BType typeHandle = new BHandleType("handle", new BPackage(null, null, null));

    private BTypes() {
    }

    public static boolean isValueType(BType type) {
        return type == typeInt || type == typeByte || type == typeFloat || type == typeDecimal || type == typeString || type == typeBoolean;
    }

    public static BType getTypeFromName(String typeName) {
        switch (typeName) {
            case "int": {
                return typeInt;
            }
            case "byte": {
                return typeByte;
            }
            case "float": {
                return typeFloat;
            }
            case "decimal": {
                return typeDecimal;
            }
            case "string": {
                return typeString;
            }
            case "boolean": {
                return typeBoolean;
            }
            case "json": {
                return typeJSON;
            }
            case "xml": {
                return typeXML;
            }
            case "map": {
                return typeMap;
            }
            case "future": {
                return typeFuture;
            }
            case "stream": {
                return typeStream;
            }
            case "any": {
                return typeAny;
            }
            case "typedesc": {
                return typeTypedesc;
            }
            case "()": {
                return typeNull;
            }
            case "xml-attributes": {
                return typeXMLAttributes;
            }
            case "error": {
                return typeError;
            }
            case "anydata": {
                return typeAnydata;
            }
        }
        throw new IllegalStateException("Unknown type name");
    }

    public static BType fromString(String typeName) {
        if (typeName.endsWith("[]")) {
            String elementTypeName = typeName.substring(0, typeName.length() - 2);
            BType elemType = BTypes.fromString(elementTypeName);
            return new BArrayType(elemType);
        }
        return BTypes.getTypeFromName(typeName);
    }

    static {
        HashMap<String, BField> fields = new HashMap<String, BField>();
        fields.put("message", new BField(typeString, "message", 8193));
        fields.put("cause", new BField(typeError, "cause", 8193));
        typeErrorDetail.setFields(fields);
        BType[] restFieldType = new BType[]{typeAnydata, typeError};
        BTypes.typeErrorDetail.restFieldType = new BUnionType(restFieldType);
    }
}

