/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.jvm.types;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.ballerinalang.jvm.types.BType;
import org.ballerinalang.jvm.types.BTypes;

public class BUnionType
extends BType {
    private List<BType> memberTypes;
    private boolean nullable;

    public BUnionType() {
        super(null, null, Object.class);
    }

    public BUnionType(List<BType> memberTypes) {
        super(null, null, Object.class);
        this.memberTypes = memberTypes;
        this.nullable = memberTypes.contains(BTypes.typeNull);
    }

    public BUnionType(BType[] memberTypes) {
        this(Arrays.asList(memberTypes));
    }

    public List<BType> getMemberTypes() {
        return this.memberTypes;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    @Override
    public <V> V getZeroValue() {
        if (this.nullable || this.memberTypes.stream().anyMatch(BType::isNilable)) {
            return null;
        }
        return this.memberTypes.get(0).getZeroValue();
    }

    @Override
    public <V> V getEmptyValue() {
        if (this.nullable || this.memberTypes.stream().anyMatch(BType::isNilable)) {
            return null;
        }
        return this.memberTypes.get(0).getEmptyValue();
    }

    @Override
    public int getTag() {
        return 21;
    }

    @Override
    public String toString() {
        List list = this.memberTypes.stream().map(BType::toString).collect(Collectors.toList());
        return String.join((CharSequence)"|", list);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BUnionType)) {
            return false;
        }
        BUnionType that = (BUnionType)o;
        return this.memberTypes.containsAll(that.memberTypes) && that.memberTypes.containsAll(this.memberTypes);
    }

    @Override
    public String getName() {
        return this.toString();
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.memberTypes);
    }

    @Override
    public boolean isNilable() {
        return this.nullable;
    }
}

