/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.jvm.util;

import java.io.PrintStream;
import java.util.Optional;
import org.ballerinalang.jvm.TypeConverter;
import org.ballerinalang.jvm.types.BArrayType;
import org.ballerinalang.jvm.types.BType;
import org.ballerinalang.jvm.util.BLangConstants;
import org.ballerinalang.jvm.values.ArrayValue;
import org.ballerinalang.jvm.values.ErrorValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuntimeUtils {
    private static PrintStream errStream = System.err;
    private static final Logger breLog = LoggerFactory.getLogger(RuntimeUtils.class);

    public static ArrayValue createVarArgsArray(String[] args, int index, BArrayType type) {
        ArrayValue array2 = new ArrayValue(type, type.getSize());
        for (int i = index; i < args.length; ++i) {
            RuntimeUtils.addToArray(type.getElementType(), args[i], array2);
        }
        return array2;
    }

    public static void addToArray(BType type, String value2, ArrayValue array2) {
        switch (type.getTag()) {
            case 5: {
                array2.add((long)array2.size(), value2);
                break;
            }
            case 1: {
                array2.add((long)array2.size(), (Long)TypeConverter.convertValues(type, value2));
                break;
            }
            case 3: {
                array2.add((long)array2.size(), (Double)TypeConverter.convertValues(type, value2));
                break;
            }
            case 6: {
                array2.add((long)array2.size(), (Boolean)TypeConverter.convertValues(type, value2));
                break;
            }
            case 2: {
                array2.add((long)array2.size(), ((Integer)TypeConverter.convertValues(type, value2)).intValue());
                break;
            }
            default: {
                array2.append(value2);
            }
        }
    }

    public static boolean isByteLiteral(int intValue) {
        return intValue >= BLangConstants.BBYTE_MIN_VALUE && intValue <= BLangConstants.BBYTE_MAX_VALUE;
    }

    public static void handleRuntimeErrors(Throwable throwable) {
        if (throwable instanceof ErrorValue) {
            errStream.println("error: " + ((ErrorValue)throwable).getPrintableStackTrace());
        } else {
            errStream.println("ballerina: Oh no, something really went wrong. Bad. Sad.\n\nThere should be a file named \"ballerina-internal.log\" in the current directory.\nIf you are able to share with us the code that broke Ballerina then\nwe would REALLY appreciate if you would report this to us:\ngo to https://github.com/ballerina-platform/ballerina-lang/issues and\ncreate a bug report with both this log file and the sample code.\n\nWe thank you for helping make us better dancers.");
            breLog.error(throwable.getMessage(), throwable);
        }
        Runtime.getRuntime().exit(1);
    }

    public static void handleRuntimeReturnValues(Object returnValue) {
        if (returnValue instanceof ErrorValue) {
            ErrorValue errorValue = (ErrorValue)returnValue;
            errStream.println("error: " + errorValue.getReason() + Optional.ofNullable(errorValue.getDetails()).map(details -> " " + details).orElse(""));
            Runtime.getRuntime().exit(1);
        }
    }

    public static void silentlyLogBadSad(Throwable throwable) {
        breLog.error(throwable.getMessage(), throwable);
    }

    public static class ParamInfo {
        String name;
        boolean hasDefaultable;
        BType type;
        int index = -1;

        public ParamInfo(boolean hasDefaultable, String name, BType type) {
            this.name = name;
            this.hasDefaultable = hasDefaultable;
            this.type = type;
        }
    }
}

