/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.jvm.values;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.IntStream;
import org.ballerinalang.jvm.BallerinaErrors;
import org.ballerinalang.jvm.JSONGenerator;
import org.ballerinalang.jvm.TypeChecker;
import org.ballerinalang.jvm.TypeConverter;
import org.ballerinalang.jvm.commons.ArrayState;
import org.ballerinalang.jvm.commons.TypeValuePair;
import org.ballerinalang.jvm.types.BArrayType;
import org.ballerinalang.jvm.types.BTupleType;
import org.ballerinalang.jvm.types.BType;
import org.ballerinalang.jvm.types.BTypes;
import org.ballerinalang.jvm.types.BUnionType;
import org.ballerinalang.jvm.util.exceptions.BLangExceptionHelper;
import org.ballerinalang.jvm.util.exceptions.BLangFreezeException;
import org.ballerinalang.jvm.util.exceptions.BallerinaErrorReasons;
import org.ballerinalang.jvm.util.exceptions.BallerinaException;
import org.ballerinalang.jvm.util.exceptions.RuntimeErrors;
import org.ballerinalang.jvm.values.CollectionValue;
import org.ballerinalang.jvm.values.IteratorValue;
import org.ballerinalang.jvm.values.RefValue;
import org.ballerinalang.jvm.values.freeze.FreezeUtils;
import org.ballerinalang.jvm.values.freeze.State;
import org.ballerinalang.jvm.values.freeze.Status;

public class ArrayValue
implements RefValue,
CollectionValue {
    static final int SYSTEM_ARRAY_MAX = 0x7FFFFFF7;
    protected BType arrayType;
    private volatile Status freezeStatus = new Status(State.UNFROZEN);
    protected int maxArraySize = 0x7FFFFFF7;
    private static final int DEFAULT_ARRAY_SIZE = 100;
    protected int size = 0;
    Object[] refValues;
    private long[] intValues;
    private boolean[] booleanValues;
    private byte[] byteValues;
    private double[] floatValues;
    private String[] stringValues;
    public BType elementType;
    private BType tupleRestType;

    public ArrayValue(Object[] values, BType type) {
        this.refValues = values;
        this.arrayType = type;
        this.size = values.length;
        if (type.getTag() == 20) {
            this.elementType = ((BArrayType)type).getElementType();
        }
    }

    public ArrayValue(long[] values) {
        this.intValues = values;
        this.size = values.length;
        this.setArrayElementType(BTypes.typeInt);
    }

    public ArrayValue(boolean[] values) {
        this.booleanValues = values;
        this.size = values.length;
        this.setArrayElementType(BTypes.typeBoolean);
    }

    public ArrayValue(byte[] values) {
        this.byteValues = values;
        this.size = values.length;
        this.setArrayElementType(BTypes.typeByte);
    }

    public ArrayValue(double[] values) {
        this.floatValues = values;
        this.size = values.length;
        this.setArrayElementType(BTypes.typeFloat);
    }

    public ArrayValue(String[] values) {
        this.stringValues = values;
        this.size = values.length;
        this.setArrayElementType(BTypes.typeString);
    }

    public ArrayValue(BType type) {
        if (type.getTag() == 1) {
            this.intValues = (long[])this.newArrayInstance(Long.TYPE);
            this.setArrayElementType(type);
        } else if (type.getTag() == 6) {
            this.booleanValues = (boolean[])this.newArrayInstance(Boolean.TYPE);
            this.setArrayElementType(type);
        } else if (type.getTag() == 2) {
            this.byteValues = (byte[])this.newArrayInstance(Byte.TYPE);
            this.setArrayElementType(type);
        } else if (type.getTag() == 3) {
            this.floatValues = (double[])this.newArrayInstance(Double.TYPE);
            this.setArrayElementType(type);
        } else if (type.getTag() == 5) {
            this.stringValues = (String[])this.newArrayInstance(String.class);
            this.setArrayElementType(type);
        } else {
            this.arrayType = type;
            if (type.getTag() == 20) {
                BArrayType arrayType = (BArrayType)type;
                this.elementType = arrayType.getElementType();
                if (arrayType.getState() == ArrayState.CLOSED_SEALED) {
                    this.size = this.maxArraySize = arrayType.getSize();
                }
                this.initArrayValues(this.elementType);
            } else if (type.getTag() == 31) {
                BTupleType tupleType = (BTupleType)type;
                this.tupleRestType = tupleType.getRestType();
                this.size = tupleType.getTupleTypes().size();
                this.maxArraySize = this.tupleRestType != null ? this.maxArraySize : this.size;
                this.refValues = (Object[])this.newArrayInstance(Object.class);
                AtomicInteger counter = new AtomicInteger(0);
                tupleType.getTupleTypes().forEach(memType -> {
                    this.refValues[counter.getAndIncrement()] = memType.getEmptyValue();
                });
            } else if (type.getTag() == 21) {
                BUnionType unionType = (BUnionType)type;
                this.size = this.maxArraySize = unionType.getMemberTypes().size();
                unionType.getMemberTypes().forEach(this::initArrayValues);
            } else {
                this.refValues = (Object[])this.newArrayInstance(Object.class);
            }
        }
    }

    private void initArrayValues(BType elementType) {
        switch (elementType.getTag()) {
            case 1: {
                this.intValues = (long[])this.newArrayInstance(Long.TYPE);
                break;
            }
            case 3: {
                this.floatValues = (double[])this.newArrayInstance(Double.TYPE);
                break;
            }
            case 5: {
                this.stringValues = (String[])this.newArrayInstance(String.class);
                break;
            }
            case 6: {
                this.booleanValues = (boolean[])this.newArrayInstance(Boolean.TYPE);
                break;
            }
            case 2: {
                this.byteValues = (byte[])this.newArrayInstance(Byte.TYPE);
                break;
            }
            case 8: {
                this.refValues = (Object[])this.newArrayInstance(Object.class);
                break;
            }
            default: {
                this.refValues = (Object[])this.newArrayInstance(Object.class);
            }
        }
    }

    public ArrayValue() {
        this.refValues = (Object[])this.newArrayInstance(Object.class);
    }

    public ArrayValue(BType type, long size) {
        this.arrayType = type;
        if (type.getTag() == 20) {
            this.elementType = ((BArrayType)type).getElementType();
            if (size != -1L) {
                this.size = this.maxArraySize = (int)size;
            }
            this.initArrayValues(this.elementType);
        } else if (type.getTag() == 31) {
            this.tupleRestType = ((BTupleType)type).getRestType();
            if (size != -1L) {
                this.size = (int)size;
                this.maxArraySize = this.tupleRestType != null ? this.maxArraySize : (int)size;
            }
            this.refValues = (Object[])this.newArrayInstance(Object.class);
        } else {
            if (size != -1L) {
                this.size = this.maxArraySize = (int)size;
            }
            this.refValues = (Object[])this.newArrayInstance(Object.class);
        }
    }

    public Object getValue(long index) {
        if (this.elementType != null) {
            if (this.elementType.getTag() == 1) {
                return this.getInt(index);
            }
            if (this.elementType.getTag() == 6) {
                return this.getBoolean(index);
            }
            if (this.elementType.getTag() == 2) {
                return this.getByte(index);
            }
            if (this.elementType.getTag() == 3) {
                return this.getFloat(index);
            }
            if (this.elementType.getTag() == 5) {
                return this.getString(index);
            }
            return this.getRefValue(index);
        }
        return this.getRefValue(index);
    }

    public Object getRefValue(long index) {
        this.rangeCheckForGet(index, this.size);
        if (this.refValues == null) {
            return this.getValue(index);
        }
        return this.refValues[(int)index];
    }

    public long getInt(long index) {
        this.rangeCheckForGet(index, this.size);
        if (this.elementType.getTag() == 1) {
            return this.intValues[(int)index];
        }
        return (Long)this.refValues[(int)index];
    }

    public boolean getBoolean(long index) {
        this.rangeCheckForGet(index, this.size);
        if (this.elementType.getTag() == 6) {
            return this.booleanValues[(int)index];
        }
        return (Boolean)this.refValues[(int)index];
    }

    public byte getByte(long index) {
        this.rangeCheckForGet(index, this.size);
        if (this.elementType.getTag() == 2) {
            return this.byteValues[(int)index];
        }
        return (Byte)this.refValues[(int)index];
    }

    public double getFloat(long index) {
        this.rangeCheckForGet(index, this.size);
        if (this.elementType.getTag() == 3) {
            return this.floatValues[(int)index];
        }
        return (Double)this.refValues[(int)index];
    }

    public String getString(long index) {
        this.rangeCheckForGet(index, this.size);
        if (this.elementType.getTag() == 5) {
            return this.stringValues[(int)index];
        }
        return (String)this.refValues[(int)index];
    }

    public Object get(long index) {
        this.rangeCheckForGet(index, this.size);
        switch (this.elementType.getTag()) {
            case 1: {
                return this.intValues[(int)index];
            }
            case 6: {
                return this.booleanValues[(int)index];
            }
            case 2: {
                return this.byteValues[(int)index];
            }
            case 3: {
                return this.floatValues[(int)index];
            }
            case 5: {
                return this.stringValues[(int)index];
            }
        }
        return this.refValues[(int)index];
    }

    public void add(long index, Object value2) {
        this.handleFrozenArrayValue();
        this.prepareForAdd(index, this.refValues.length);
        this.refValues[(int)index] = value2;
    }

    public void add(long index, long value2) {
        this.handleFrozenArrayValue();
        this.prepareForAdd(index, this.intValues.length);
        this.intValues[(int)index] = value2;
    }

    public void add(long index, boolean value2) {
        if (this.elementType.getTag() == 1) {
            this.add(index, value2);
            return;
        }
        this.handleFrozenArrayValue();
        this.prepareForAdd(index, this.booleanValues.length);
        this.booleanValues[(int)index] = value2;
    }

    public void add(long index, byte value2) {
        this.handleFrozenArrayValue();
        this.prepareForAdd(index, this.byteValues.length);
        this.byteValues[(int)index] = value2;
    }

    public void add(long index, double value2) {
        this.handleFrozenArrayValue();
        this.prepareForAdd(index, this.floatValues.length);
        this.floatValues[(int)index] = value2;
    }

    public void add(long index, String value2) {
        this.handleFrozenArrayValue();
        this.prepareForAdd(index, this.stringValues.length);
        this.stringValues[(int)index] = value2;
    }

    public void append(Object value2) {
        this.add((long)this.size, value2);
    }

    public Object shift(long index) {
        this.handleFrozenArrayValue();
        Object val = this.get(index);
        this.shiftArray((int)index, this.getArrayFromType(this.elementType.getTag()));
        return val;
    }

    private void shiftArray(int index, Object arr) {
        int nElemsToBeMoved = this.size - 1 - index;
        if (nElemsToBeMoved >= 0) {
            System.arraycopy(arr, index + 1, arr, index, nElemsToBeMoved);
        }
        --this.size;
    }

    public void unshift(long index, ArrayValue vals) {
        this.handleFrozenArrayValue();
        this.unshiftArray(index, vals.size, this.getCurrentArrayLength());
        switch (this.elementType.getTag()) {
            case 1: {
                this.addToIntArray(vals, (int)index);
                break;
            }
            case 6: {
                this.addToBooleanArray(vals, (int)index);
                break;
            }
            case 2: {
                this.addToByteArray(vals, (int)index);
                break;
            }
            case 3: {
                this.addToFloatArray(vals, (int)index);
                break;
            }
            case 5: {
                this.addToStringArray(vals, (int)index);
                break;
            }
            default: {
                this.addToRefArray(vals, (int)index);
            }
        }
    }

    private void addToIntArray(ArrayValue vals, int startIndex) {
        int endIndex = startIndex + vals.size;
        int i = startIndex;
        int j = 0;
        while (i < endIndex) {
            this.add((long)i, vals.getInt(j));
            ++i;
            ++j;
        }
    }

    private void addToFloatArray(ArrayValue vals, int startIndex) {
        int endIndex = startIndex + vals.size;
        int i = startIndex;
        int j = 0;
        while (i < endIndex) {
            this.add((long)i, vals.getFloat(j));
            ++i;
            ++j;
        }
    }

    private void addToStringArray(ArrayValue vals, int startIndex) {
        int endIndex = startIndex + vals.size;
        int i = startIndex;
        int j = 0;
        while (i < endIndex) {
            this.add((long)i, vals.getString(j));
            ++i;
            ++j;
        }
    }

    private void addToByteArray(ArrayValue vals, int startIndex) {
        int endIndex = startIndex + vals.size;
        byte[] bytes = vals.getBytes();
        int i = startIndex;
        int j = 0;
        while (i < endIndex) {
            this.byteValues[i] = bytes[j];
            ++i;
            ++j;
        }
    }

    private void addToBooleanArray(ArrayValue vals, int startIndex) {
        int endIndex = startIndex + vals.size;
        int i = startIndex;
        int j = 0;
        while (i < endIndex) {
            this.add((long)i, vals.getBoolean(j));
            ++i;
            ++j;
        }
    }

    private void addToRefArray(ArrayValue vals, int startIndex) {
        int endIndex = startIndex + vals.size;
        int i = startIndex;
        int j = 0;
        while (i < endIndex) {
            this.add((long)i, vals.getRefValue(j));
            ++i;
            ++j;
        }
    }

    private void unshiftArray(long index, int unshiftByN, int arrLength) {
        int lastIndex = this.size() + unshiftByN - 1;
        this.prepareForConsecutiveMultiAdd(lastIndex, arrLength);
        Object arr = this.getArrayFromType(this.elementType.getTag());
        if (index > (long)lastIndex) {
            throw BLangExceptionHelper.getRuntimeException(BallerinaErrorReasons.INDEX_OUT_OF_RANGE_ERROR, RuntimeErrors.INDEX_NUMBER_TOO_LARGE, index);
        }
        int i = (int)index;
        System.arraycopy(arr, i, arr, i + unshiftByN, this.size - i);
    }

    private Object getArrayFromType(int typeTag) {
        switch (typeTag) {
            case 1: {
                return this.intValues;
            }
            case 6: {
                return this.booleanValues;
            }
            case 2: {
                return this.byteValues;
            }
            case 3: {
                return this.floatValues;
            }
            case 5: {
                return this.stringValues;
            }
        }
        return this.refValues;
    }

    private int getCurrentArrayLength() {
        switch (this.elementType.getTag()) {
            case 1: {
                return this.intValues.length;
            }
            case 6: {
                return this.booleanValues.length;
            }
            case 2: {
                return this.byteValues.length;
            }
            case 3: {
                return this.floatValues.length;
            }
            case 5: {
                return this.stringValues.length;
            }
        }
        return this.refValues.length;
    }

    @Override
    public String stringValue() {
        StringJoiner sj;
        if (this.elementType != null) {
            sj = new StringJoiner(" ");
            if (this.elementType.getTag() == 1) {
                for (int i = 0; i < this.size; ++i) {
                    sj.add(Long.toString(this.intValues[i]));
                }
                return sj.toString();
            }
            if (this.elementType.getTag() == 6) {
                for (int i = 0; i < this.size; ++i) {
                    sj.add(Boolean.toString(this.booleanValues[i]));
                }
                return sj.toString();
            }
            if (this.elementType.getTag() == 2) {
                for (int i = 0; i < this.size; ++i) {
                    sj.add(Long.toString(Byte.toUnsignedLong(this.byteValues[i])));
                }
                return sj.toString();
            }
            if (this.elementType.getTag() == 3) {
                for (int i = 0; i < this.size; ++i) {
                    sj.add(Double.toString(this.floatValues[i]));
                }
                return sj.toString();
            }
            if (this.elementType.getTag() == 5) {
                for (int i = 0; i < this.size; ++i) {
                    sj.add(this.stringValues[i]);
                }
                return sj.toString();
            }
        }
        if (this.getElementType(this.arrayType).getTag() == 7) {
            return this.getJSONString();
        }
        sj = this.arrayType != null && this.arrayType.getTag() == 31 ? new StringJoiner(" ") : new StringJoiner(" ");
        for (int i = 0; i < this.size; ++i) {
            if (this.refValues[i] != null) {
                sj.add(this.refValues[i] instanceof RefValue ? ((RefValue)this.refValues[i]).stringValue() : (this.refValues[i] instanceof String ? (String)this.refValues[i] : this.refValues[i].toString()));
                continue;
            }
            sj.add("()");
        }
        return sj.toString();
    }

    @Override
    public BType getType() {
        return this.arrayType;
    }

    @Override
    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public void stamp(BType type, List<TypeValuePair> unresolvedValues) {
        if (type.getTag() == 31) {
            if (this.elementType != null && this.isBasicType(this.elementType)) {
                this.moveBasicTypeArrayToRefValueArray();
            }
            Object[] arrayValues = this.getValues();
            for (int i = 0; i < this.size(); ++i) {
                BType memberType = ((BTupleType)type).getTupleTypes().get(i);
                if (arrayValues[i] instanceof RefValue) {
                    if (memberType.getTag() == 11 || memberType.getTag() == 7) {
                        memberType = TypeConverter.resolveMatchingTypeForUnion(arrayValues[i], memberType);
                        ((BTupleType)type).getTupleTypes().set(i, memberType);
                    }
                    ((RefValue)arrayValues[i]).stamp(memberType, unresolvedValues);
                    continue;
                }
                if (TypeChecker.checkIsType(arrayValues[i], memberType)) continue;
                arrayValues[i] = TypeConverter.convertValues(TypeConverter.getConvertibleTypes(arrayValues[i], memberType).get(0), arrayValues[i]);
            }
        } else if (type.getTag() == 7) {
            if (this.elementType != null && this.isBasicType(this.elementType) && !this.isBasicType(type)) {
                this.moveBasicTypeArrayToRefValueArray();
                this.arrayType = new BArrayType(type);
                return;
            }
            Object[] arrayValues = this.getValues();
            for (int i = 0; i < this.size(); ++i) {
                if (!(arrayValues[i] instanceof RefValue)) continue;
                ((RefValue)arrayValues[i]).stamp(TypeConverter.resolveMatchingTypeForUnion(arrayValues[i], type), unresolvedValues);
            }
            type = new BArrayType(type);
        } else if (type.getTag() == 21) {
            type = TypeConverter.getConvertibleTypes(this, type).get(0);
            this.stamp(type, unresolvedValues);
        } else if (type.getTag() == 11) {
            type = TypeConverter.resolveMatchingTypeForUnion(this, type);
            this.stamp(type, unresolvedValues);
        } else {
            BType arrayElementType = ((BArrayType)type).getElementType();
            if (this.elementType != null && this.isBasicType(this.elementType)) {
                if (this.isBasicType(arrayElementType)) {
                    if (TypeChecker.isNumericType(this.elementType) && TypeChecker.isNumericType(arrayElementType)) {
                        this.convertNumericTypeArray(type, arrayElementType);
                        return;
                    }
                    this.arrayType = type;
                    return;
                }
                this.moveBasicTypeArrayToRefValueArray();
                for (int i = 0; i < this.size(); ++i) {
                    Object value2 = this.refValues[i];
                    if (value2 instanceof RefValue || TypeChecker.checkIsType(value2, arrayElementType)) continue;
                    this.refValues[i] = TypeConverter.convertValues(TypeConverter.getConvertibleTypes(value2, arrayElementType).get(0), value2);
                }
                this.elementType = arrayElementType;
                this.arrayType = type;
                return;
            }
            if (this.isBasicType(arrayElementType) && (this.arrayType.getTag() == 31 || !this.isBasicType(this.elementType))) {
                this.moveRefValueArrayToBasicTypeArray(type, arrayElementType);
                return;
            }
            Object[] arrayValues = this.getValues();
            for (int i = 0; i < this.size(); ++i) {
                if (arrayValues[i] instanceof RefValue) {
                    ((RefValue)arrayValues[i]).stamp(arrayElementType, unresolvedValues);
                    continue;
                }
                if (TypeChecker.checkIsType(arrayValues[i], arrayElementType)) continue;
                arrayValues[i] = TypeConverter.convertValues(TypeConverter.getConvertibleTypes(arrayValues[i], arrayElementType).get(0), arrayValues[i]);
            }
        }
        this.arrayType = type;
    }

    @Override
    public Object copy(Map<Object, Object> refs) {
        if (this.isFrozen()) {
            return this;
        }
        if (refs.containsKey(this)) {
            return refs.get(this);
        }
        if (this.elementType != null) {
            ArrayValue valueArray = null;
            if (this.elementType.getTag() == 1) {
                valueArray = new ArrayValue(Arrays.copyOf(this.intValues, this.intValues.length));
            } else if (this.elementType.getTag() == 6) {
                valueArray = new ArrayValue(Arrays.copyOf(this.booleanValues, this.booleanValues.length));
            } else if (this.elementType.getTag() == 2) {
                valueArray = new ArrayValue(Arrays.copyOf(this.byteValues, this.byteValues.length));
            } else if (this.elementType.getTag() == 3) {
                valueArray = new ArrayValue(Arrays.copyOf(this.floatValues, this.floatValues.length));
            } else if (this.elementType.getTag() == 5) {
                valueArray = new ArrayValue(Arrays.copyOf(this.stringValues, this.stringValues.length));
            }
            if (valueArray != null) {
                valueArray.size = this.size;
                refs.put(this, valueArray);
                return valueArray;
            }
        }
        Object[] values = new Object[this.size];
        ArrayValue refValueArray = new ArrayValue(values, this.arrayType);
        refValueArray.size = this.size;
        refs.put(this, refValueArray);
        int bound = this.size;
        IntStream.range(0, bound).forEach(i -> {
            Object value2 = this.refValues[i];
            values[i] = value2 instanceof RefValue ? ((RefValue)value2).copy(refs) : value2;
        });
        return refValueArray;
    }

    @Override
    public Object frozenCopy(Map<Object, Object> refs) {
        ArrayValue copy = (ArrayValue)this.copy(refs);
        if (!copy.isFrozen()) {
            copy.freezeDirect();
        }
        return copy;
    }

    public String toString() {
        return this.stringValue();
    }

    public Object[] getValues() {
        return this.refValues;
    }

    public byte[] getBytes() {
        byte[] bytes = new byte[this.size];
        System.arraycopy(this.byteValues, 0, bytes, 0, this.size);
        return bytes;
    }

    public String[] getStringArray() {
        return Arrays.copyOf(this.stringValues, this.size);
    }

    public long[] getLongArray() {
        return Arrays.copyOf(this.intValues, this.size);
    }

    @Override
    public void serialize(OutputStream outputStream) {
        if (this.elementType.getTag() == 2) {
            try {
                outputStream.write(this.byteValues);
            }
            catch (IOException e) {
                throw new BallerinaException("error occurred while writing the binary content to the output stream", e);
            }
        }
        try {
            outputStream.write(this.toString().getBytes(Charset.defaultCharset()));
        }
        catch (IOException e) {
            throw new BallerinaException("error occurred while serializing data", e);
        }
    }

    public void resizeInternalArray(int newLength) {
        if (this.arrayType.getTag() == 31) {
            this.refValues = Arrays.copyOf(this.refValues, newLength);
        } else if (this.elementType != null) {
            switch (this.elementType.getTag()) {
                case 1: {
                    this.intValues = Arrays.copyOf(this.intValues, newLength);
                    break;
                }
                case 6: {
                    this.booleanValues = Arrays.copyOf(this.booleanValues, newLength);
                    break;
                }
                case 2: {
                    this.byteValues = Arrays.copyOf(this.byteValues, newLength);
                    break;
                }
                case 3: {
                    this.floatValues = Arrays.copyOf(this.floatValues, newLength);
                    break;
                }
                case 5: {
                    this.stringValues = Arrays.copyOf(this.stringValues, newLength);
                    break;
                }
                default: {
                    this.refValues = Arrays.copyOf(this.refValues, newLength);
                    break;
                }
            }
        } else {
            this.refValues = Arrays.copyOf(this.refValues, newLength);
        }
    }

    private void fillValues(int index) {
        if (index <= this.size) {
            return;
        }
        if (this.arrayType.getTag() == 31) {
            if (this.tupleRestType != null) {
                Arrays.fill(this.refValues, this.size, index, this.tupleRestType.getZeroValue());
            }
        } else {
            int typeTag = this.elementType.getTag();
            if (typeTag == 5) {
                Arrays.fill(this.stringValues, this.size, index, "");
                return;
            }
            if (typeTag == 1 || typeTag == 2 || typeTag == 3 || typeTag == 6) {
                return;
            }
            Arrays.fill(this.refValues, this.size, index, this.elementType.getZeroValue());
        }
    }

    public BType getArrayType() {
        return this.arrayType;
    }

    private void rangeCheckForGet(long index, int size) {
        this.rangeCheck(index, size);
        if (index < 0L || index >= (long)size) {
            if (this.arrayType != null && this.arrayType.getTag() == 31) {
                throw BLangExceptionHelper.getRuntimeException(BallerinaErrorReasons.INDEX_OUT_OF_RANGE_ERROR, RuntimeErrors.TUPLE_INDEX_OUT_OF_RANGE, index, size);
            }
            throw BLangExceptionHelper.getRuntimeException(BallerinaErrorReasons.INDEX_OUT_OF_RANGE_ERROR, RuntimeErrors.ARRAY_INDEX_OUT_OF_RANGE, index, size);
        }
    }

    private void rangeCheck(long index, int size) {
        if (index > Integer.MAX_VALUE || index < Integer.MIN_VALUE) {
            throw BLangExceptionHelper.getRuntimeException(BallerinaErrorReasons.INDEX_OUT_OF_RANGE_ERROR, RuntimeErrors.INDEX_NUMBER_TOO_LARGE, index);
        }
        if (this.arrayType != null && this.arrayType.getTag() == 31) {
            if (((BTupleType)this.arrayType).getRestType() == null && index >= (long)this.maxArraySize || (int)index < 0) {
                throw BLangExceptionHelper.getRuntimeException(BallerinaErrorReasons.INDEX_OUT_OF_RANGE_ERROR, RuntimeErrors.TUPLE_INDEX_OUT_OF_RANGE, index, size);
            }
        } else if ((int)index < 0 || index >= (long)this.maxArraySize) {
            throw BLangExceptionHelper.getRuntimeException(BallerinaErrorReasons.INDEX_OUT_OF_RANGE_ERROR, RuntimeErrors.ARRAY_INDEX_OUT_OF_RANGE, index, size);
        }
    }

    private void fillerValueCheck(int index, int size) {
        if (this.arrayType != null && this.arrayType.getTag() == 31) {
            if (!TypeChecker.hasFillerValue(this.tupleRestType) && index > size) {
                throw BLangExceptionHelper.getRuntimeException(BallerinaErrorReasons.ILLEGAL_LIST_INSERTION_ERROR, RuntimeErrors.ILLEGAL_TUPLE_INSERTION, size, index + 1);
            }
        } else if (!TypeChecker.hasFillerValue(this.elementType) && index > size) {
            throw BLangExceptionHelper.getRuntimeException(BallerinaErrorReasons.ILLEGAL_LIST_INSERTION_ERROR, RuntimeErrors.ILLEGAL_ARRAY_INSERTION, size, index + 1);
        }
    }

    Object newArrayInstance(Class<?> componentType) {
        return this.size > 0 ? Array.newInstance(componentType, this.size) : Array.newInstance(componentType, 100);
    }

    private void setArrayElementType(BType type) {
        this.arrayType = new BArrayType(type);
        this.elementType = type;
    }

    public String getJSONString() {
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        JSONGenerator gen = new JSONGenerator(byteOut);
        try {
            gen.serialize(this);
            gen.flush();
        }
        catch (IOException e) {
            throw new BallerinaException("Error in converting JSON to a string: " + e.getMessage(), e);
        }
        return new String(byteOut.toByteArray());
    }

    private BType getElementType(BType type) {
        if (type.getTag() != 20) {
            return type;
        }
        return this.getElementType(((BArrayType)type).getElementType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleFrozenArrayValue() {
        ArrayValue arrayValue = this;
        synchronized (arrayValue) {
            try {
                if (this.freezeStatus.getState() != State.UNFROZEN) {
                    FreezeUtils.handleInvalidUpdate(this.freezeStatus.getState());
                }
            }
            catch (BLangFreezeException e) {
                throw BallerinaErrors.createError(e.getMessage(), e.getDetail());
            }
        }
    }

    protected void prepareForAdd(long index, int currentArraySize) {
        int intIndex = (int)index;
        this.rangeCheck(index, this.size);
        this.fillerValueCheck(intIndex, this.size);
        this.ensureCapacity(intIndex + 1, currentArraySize);
        this.fillValues(intIndex);
        this.resetSize(intIndex);
    }

    void prepareForConsecutiveMultiAdd(long index, int currentArraySize) {
        int intIndex = (int)index;
        this.rangeCheck(index, this.size);
        this.ensureCapacity(intIndex + 1, currentArraySize);
        this.resetSize(intIndex);
    }

    private void ensureCapacity(int requestedCapacity, int currentArraySize) {
        if (requestedCapacity - currentArraySize > 0 && (this.arrayType.getTag() == 20 && ((BArrayType)this.arrayType).getState() == ArrayState.UNSEALED || this.arrayType.getTag() == 31)) {
            int newArraySize = currentArraySize + (currentArraySize >> 1);
            newArraySize = Math.max(newArraySize, requestedCapacity);
            newArraySize = Math.min(newArraySize, this.maxArraySize);
            this.resizeInternalArray(newArraySize);
        }
    }

    private void resetSize(int index) {
        if (index >= this.size) {
            this.size = index + 1;
        }
    }

    @Override
    public synchronized void attemptFreeze(Status freezeStatus) {
        if (!FreezeUtils.isOpenForFreeze(this.freezeStatus, freezeStatus)) {
            return;
        }
        this.freezeStatus = freezeStatus;
        if (this.elementType == null || this.elementType.getTag() > 6) {
            for (int i = 0; i < this.size; ++i) {
                Object value2 = this.getRefValue(i);
                if (!(value2 instanceof RefValue)) continue;
                ((RefValue)value2).attemptFreeze(freezeStatus);
            }
        }
    }

    @Override
    public void freezeDirect() {
        if (this.isFrozen()) {
            return;
        }
        this.freezeStatus.setFrozen();
        if (this.elementType == null || this.elementType.getTag() > 6) {
            for (int i = 0; i < this.size; ++i) {
                Object value2 = this.getRefValue(i);
                if (!(value2 instanceof RefValue)) continue;
                ((RefValue)value2).freezeDirect();
            }
        }
    }

    @Override
    public synchronized boolean isFrozen() {
        return this.freezeStatus.isFrozen();
    }

    private boolean isBasicType(BType type) {
        return type.getTag() <= 6 && type.getTag() != 4;
    }

    private void moveBasicTypeArrayToRefValueArray() {
        int i;
        this.refValues = new Object[this.size];
        if (this.elementType == BTypes.typeBoolean) {
            for (i = 0; i < this.size(); ++i) {
                this.refValues[i] = this.booleanValues[i];
            }
            this.booleanValues = null;
        }
        if (this.elementType == BTypes.typeInt) {
            for (i = 0; i < this.size(); ++i) {
                this.refValues[i] = this.intValues[i];
            }
            this.intValues = null;
        }
        if (this.elementType == BTypes.typeString) {
            System.arraycopy(this.stringValues, 0, this.refValues, 0, this.size());
            this.stringValues = null;
        }
        if (this.elementType == BTypes.typeFloat) {
            for (i = 0; i < this.size(); ++i) {
                this.refValues[i] = this.floatValues[i];
            }
            this.floatValues = null;
        }
        if (this.elementType == BTypes.typeByte) {
            for (i = 0; i < this.size(); ++i) {
                this.refValues[i] = this.byteValues[i];
            }
            this.byteValues = null;
        }
        this.elementType = null;
    }

    private void moveRefValueArrayToBasicTypeArray(BType type, BType arrayElementType) {
        Object value2;
        int i;
        Object[] arrayValues = this.getValues();
        if (arrayElementType.getTag() == 1) {
            this.intValues = (long[])this.newArrayInstance(Long.TYPE);
            for (i = 0; i < this.size(); ++i) {
                value2 = arrayValues[i];
                this.intValues[i] = TypeChecker.checkIsType(value2, arrayElementType) ? ((Long)value2).longValue() : ((Long)TypeConverter.convertValues(arrayElementType, value2)).longValue();
            }
        }
        if (arrayElementType.getTag() == 3) {
            this.floatValues = (double[])this.newArrayInstance(Double.TYPE);
            for (i = 0; i < this.size(); ++i) {
                value2 = arrayValues[i];
                this.floatValues[i] = TypeChecker.checkIsType(value2, arrayElementType) ? (double)((Float)value2).floatValue() : (double)((Float)TypeConverter.convertValues(arrayElementType, value2)).floatValue();
            }
        }
        if (arrayElementType.getTag() == 6) {
            this.booleanValues = new boolean[this.size()];
            for (i = 0; i < this.size(); ++i) {
                this.booleanValues[i] = (Boolean)arrayValues[i];
            }
        }
        if (arrayElementType.getTag() == 5) {
            this.stringValues = (String[])this.newArrayInstance(String.class);
            for (i = 0; i < this.size(); ++i) {
                this.stringValues[i] = (String)arrayValues[i];
            }
        }
        if (arrayElementType.getTag() == 2) {
            this.byteValues = (byte[])this.newArrayInstance(Byte.TYPE);
            for (i = 0; i < this.size(); ++i) {
                value2 = arrayValues[i];
                this.byteValues[i] = TypeChecker.checkIsType(value2, arrayElementType) ? ((Byte)value2).byteValue() : ((Byte)TypeConverter.convertValues(arrayElementType, value2)).byteValue();
            }
        }
        this.elementType = arrayElementType;
        this.arrayType = type;
        this.refValues = null;
    }

    private void convertNumericTypeArray(BType type, BType arrayElementType) {
        int i;
        if (arrayElementType.getTag() == this.elementType.getTag()) {
            return;
        }
        int arrayElementTypeTag = arrayElementType.getTag();
        if (arrayElementTypeTag == 2) {
            this.byteValues = (byte[])this.newArrayInstance(Byte.TYPE);
            for (i = 0; i < this.size(); ++i) {
                this.byteValues[i] = (byte)TypeChecker.anyToByte(this.get(i));
            }
        }
        if (arrayElementTypeTag == 1) {
            this.intValues = (long[])this.newArrayInstance(Long.TYPE);
            for (i = 0; i < this.size(); ++i) {
                this.intValues[i] = TypeChecker.anyToInt(this.get(i));
            }
        }
        if (arrayElementTypeTag == 3) {
            this.floatValues = (double[])this.newArrayInstance(Double.TYPE);
            for (i = 0; i < this.size(); ++i) {
                this.floatValues[i] = TypeChecker.anyToFloat(this.get(i));
            }
        }
        if (arrayElementTypeTag == 4) {
            for (i = 0; i < this.size(); ++i) {
                this.refValues[i] = TypeChecker.anyToDecimal(this.get(i));
            }
            switch (this.elementType.getTag()) {
                case 2: {
                    this.byteValues = null;
                    break;
                }
                case 1: {
                    this.intValues = null;
                    break;
                }
                case 3: {
                    this.floatValues = null;
                }
            }
            this.elementType = arrayElementType;
            this.arrayType = type;
            return;
        }
        this.elementType = arrayElementType;
        this.arrayType = type;
        this.refValues = null;
    }

    @Override
    public IteratorValue getIterator() {
        return new ArrayIterator(this);
    }

    public void setLength(long length) {
        this.handleFrozenArrayValue();
        int newLength = (int)length;
        this.rangeCheck(length, this.size);
        this.checkFixedLength(length);
        this.fillerValueCheck(newLength, this.size);
        this.resizeInternalArray(newLength);
        this.fillValues(newLength);
        this.size = newLength;
    }

    private void checkFixedLength(long length) {
        if (((BArrayType)this.arrayType).getState() == ArrayState.CLOSED_SEALED) {
            throw BLangExceptionHelper.getRuntimeException(BallerinaErrorReasons.INHERENT_TYPE_VIOLATION_ERROR, RuntimeErrors.ILLEGAL_ARRAY_SIZE, length);
        }
    }

    static class ArrayIterator
    implements IteratorValue {
        ArrayValue array;
        long cursor = 0L;
        long length;

        ArrayIterator(ArrayValue value2) {
            this.array = value2;
            this.length = value2.size();
        }

        public Object next() {
            long cursor;
            if ((cursor = this.cursor++) == this.length) {
                return null;
            }
            return this.array.getValue(cursor);
        }

        @Override
        public boolean hasNext() {
            return this.cursor < this.length;
        }
    }
}

