/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.jvm.values;

import java.io.PrintWriter;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.ballerinalang.jvm.BallerinaErrors;
import org.ballerinalang.jvm.TypeChecker;
import org.ballerinalang.jvm.commons.TypeValuePair;
import org.ballerinalang.jvm.services.ErrorHandlerUtils;
import org.ballerinalang.jvm.types.BErrorType;
import org.ballerinalang.jvm.types.BType;
import org.ballerinalang.jvm.types.BTypes;
import org.ballerinalang.jvm.values.RefValue;
import org.ballerinalang.jvm.values.freeze.Status;

public class ErrorValue
extends RuntimeException
implements RefValue {
    private static final long serialVersionUID = 1L;
    private final BType type;
    private final String reason;
    private final Object details;

    public ErrorValue(String reason, Object details) {
        super(reason);
        this.type = new BErrorType("error", BTypes.typeError.getPackage(), BTypes.typeString, TypeChecker.getType(details));
        this.reason = reason;
        this.details = details;
    }

    public ErrorValue(BType type, String reason, Object details) {
        super(reason);
        this.type = type;
        this.reason = reason;
        this.details = details;
    }

    @Override
    public String stringValue() {
        return "error " + this.reason + Optional.ofNullable(this.details).map(details -> " " + details).orElse("");
    }

    @Override
    public BType getType() {
        return this.type;
    }

    @Override
    public void stamp(BType type, List<TypeValuePair> unresolvedValues) {
    }

    @Override
    public Object copy(Map<Object, Object> refs) {
        return this;
    }

    @Override
    public Object frozenCopy(Map<Object, Object> refs) {
        return this;
    }

    @Override
    public void attemptFreeze(Status freezeStatus) {
    }

    @Override
    public void freezeDirect() {
    }

    @Override
    public String toString() {
        return this.stringValue();
    }

    public String getReason() {
        return this.reason;
    }

    public Object getDetails() {
        if (this.details instanceof RefValue) {
            return ((RefValue)this.details).copy(new HashMap<Object, Object>());
        }
        return this.details;
    }

    @Override
    public void printStackTrace() {
        ErrorHandlerUtils.printError("error: " + this.getPrintableStackTrace());
    }

    @Override
    public void printStackTrace(PrintWriter printWriter) {
        printWriter.print("error: " + this.getPrintableStackTrace());
    }

    @Override
    public StackTraceElement[] getStackTrace() {
        StackTraceElement[] stackTrace = super.getStackTrace();
        LinkedList<StackTraceElement> filteredStack = new LinkedList<StackTraceElement>();
        int index = 0;
        for (StackTraceElement stackFrame : stackTrace) {
            Optional<StackTraceElement> stackTraceElement;
            if (!(stackTraceElement = BallerinaErrors.filterStackTraceElement(stackFrame, index++)).isPresent()) continue;
            filteredStack.add(stackTraceElement.get());
        }
        StackTraceElement[] filteredStackArray = new StackTraceElement[filteredStack.size()];
        return filteredStack.toArray(filteredStackArray);
    }

    public String getPrintableStackTrace() {
        String errorMsg = this.getErrorMessage();
        StringBuilder sb = new StringBuilder();
        sb.append(errorMsg);
        StackTraceElement[] stackTrace = this.getStackTrace();
        if (stackTrace.length == 0) {
            return sb.toString();
        }
        sb.append("\n\tat ");
        this.printStackElement(sb, stackTrace[0], "");
        for (int i = 1; i < stackTrace.length; ++i) {
            this.printStackElement(sb, stackTrace[i], "\n\t   ");
        }
        return sb.toString();
    }

    private void printStackElement(StringBuilder sb, StackTraceElement stackTraceElement, String tab) {
        String pkgName = stackTraceElement.getClassName();
        String fileName = stackTraceElement.getFileName();
        fileName = fileName.replace(".bal", "");
        fileName = fileName.replace("/", "-");
        pkgName = pkgName.replace("." + fileName, "");
        sb.append(tab);
        if (!pkgName.equals("___init")) {
            sb.append(pkgName).append(":");
        }
        sb.append(stackTraceElement.getMethodName());
        sb.append("(").append(stackTraceElement.getFileName());
        sb.append(":").append(stackTraceElement.getLineNumber()).append(")");
    }

    private String getErrorMessage() {
        String errorMsg = "";
        boolean reasonAdded = false;
        if (this.reason != null && !this.reason.isEmpty()) {
            errorMsg = this.reason;
            reasonAdded = true;
        }
        if (this.details != null) {
            errorMsg = errorMsg + (reasonAdded ? " " : "") + this.details.toString();
        }
        return errorMsg;
    }

    @Override
    public boolean isFrozen() {
        return true;
    }
}

