/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.jvm.values;

import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import org.ballerinalang.jvm.types.BType;
import org.ballerinalang.jvm.values.RefValue;

public class FPValue<T, R>
implements RefValue {
    final BType type;
    Function<T, R> function;
    Consumer<T> consumer;

    public FPValue(Function<T, R> function, BType type) {
        this.function = function;
        this.type = type;
    }

    public FPValue(Consumer<T> consumer, BType type) {
        this.consumer = consumer;
        this.type = type;
    }

    public R apply(T t) {
        return this.function.apply(t);
    }

    public void accept(T t) {
        this.consumer.accept(t);
    }

    public Function<T, R> getFunction() {
        return this.function;
    }

    public Consumer<T> getConsumer() {
        return this.consumer;
    }

    @Override
    public String stringValue() {
        return Optional.ofNullable(this.getType()).map(BType::toString).filter(str -> str.startsWith("function")).orElse("function " + this.type.toString());
    }

    @Override
    public BType getType() {
        return this.type;
    }

    @Override
    public Object copy(Map<Object, Object> refs) {
        return this;
    }

    @Override
    public Object frozenCopy(Map<Object, Object> refs) {
        return this;
    }

    @Override
    public boolean isFrozen() {
        return true;
    }

    @Override
    public Object freeze() {
        return this;
    }

    public String toString() {
        return "";
    }
}

