/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.jvm.values;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.ballerinalang.jvm.BallerinaErrors;
import org.ballerinalang.jvm.BallerinaValues;
import org.ballerinalang.jvm.JSONGenerator;
import org.ballerinalang.jvm.JSONUtils;
import org.ballerinalang.jvm.TypeChecker;
import org.ballerinalang.jvm.TypeConverter;
import org.ballerinalang.jvm.commons.TypeValuePair;
import org.ballerinalang.jvm.types.BField;
import org.ballerinalang.jvm.types.BMapType;
import org.ballerinalang.jvm.types.BPackage;
import org.ballerinalang.jvm.types.BRecordType;
import org.ballerinalang.jvm.types.BTupleType;
import org.ballerinalang.jvm.types.BType;
import org.ballerinalang.jvm.types.BTypes;
import org.ballerinalang.jvm.types.BUnionType;
import org.ballerinalang.jvm.util.exceptions.BLangExceptionHelper;
import org.ballerinalang.jvm.util.exceptions.BLangFreezeException;
import org.ballerinalang.jvm.util.exceptions.BallerinaErrorReasons;
import org.ballerinalang.jvm.util.exceptions.BallerinaException;
import org.ballerinalang.jvm.util.exceptions.RuntimeErrors;
import org.ballerinalang.jvm.values.ArrayValue;
import org.ballerinalang.jvm.values.CollectionValue;
import org.ballerinalang.jvm.values.ErrorValue;
import org.ballerinalang.jvm.values.IteratorValue;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.jvm.values.RefValue;
import org.ballerinalang.jvm.values.freeze.FreezeUtils;
import org.ballerinalang.jvm.values.freeze.State;
import org.ballerinalang.jvm.values.freeze.Status;

public class MapValueImpl<K, V>
extends LinkedHashMap<K, V>
implements RefValue,
CollectionValue,
MapValue<K, V> {
    private static final long serialVersionUID = 1L;
    private BType type;
    private static final String PERIOD = ".";
    private static final String UNDERSCORE = "_";
    private static final String SLASH = "/";
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final Lock readLock = this.lock.readLock();
    private final Lock writeLock = this.lock.writeLock();
    private volatile Status freezeStatus = new Status(State.UNFROZEN);
    private final Map<String, Object> nativeData = new HashMap<String, Object>();

    public MapValueImpl(BType type) {
        this.type = type;
    }

    public MapValueImpl() {
        this.type = BTypes.typeMap;
    }

    @Override
    public V get(Object key) {
        this.readLock.lock();
        try {
            Object v = super.get(key);
            return v;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public Long getIntValue(String key) {
        return (Long)this.get(key);
    }

    @Override
    public Double getFloatValue(String key) {
        return (Double)this.get(key);
    }

    @Override
    public String getStringValue(String key) {
        return (String)this.get(key);
    }

    @Override
    public Boolean getBooleanValue(String key) {
        return (Boolean)this.get(key);
    }

    @Override
    public MapValueImpl<?, ?> getMapValue(String key) {
        return (MapValueImpl)this.get(key);
    }

    @Override
    public ObjectValue getObjectValue(String key) {
        return (ObjectValue)this.get(key);
    }

    @Override
    public ArrayValue getArrayValue(String key) {
        return (ArrayValue)this.get(key);
    }

    @Override
    public long getDefaultableIntValue(String key) {
        if (this.get(key) != null) {
            return this.getIntValue(key);
        }
        return 0L;
    }

    @Override
    public V getOrThrow(Object key) {
        this.readLock.lock();
        try {
            if (!this.containsKey(key)) {
                throw BallerinaErrors.createError(BallerinaErrorReasons.KEY_NOT_FOUND_ERROR, "cannot find key '" + key + "'");
            }
            Object v = super.get(key);
            return v;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V fillAndGet(Object key) {
        this.writeLock.lock();
        try {
            if (this.containsKey(key)) {
                Object v = super.get(key);
                return v;
            }
            BType expectedType = null;
            if (this.type.getTag() == 12) {
                BRecordType recordType = (BRecordType)this.type;
                Map<String, BField> fields = recordType.getFields();
                if (fields.containsKey(key)) {
                    expectedType = fields.get((Object)key).type;
                } else {
                    if (recordType.sealed) {
                        throw BallerinaErrors.createError(BallerinaErrorReasons.KEY_NOT_FOUND_ERROR, "cannot find key '" + key + "'");
                    }
                    expectedType = recordType.restFieldType;
                }
            } else {
                expectedType = ((BMapType)this.type).getConstrainedType();
            }
            if (!TypeChecker.hasFillerValue(expectedType)) {
                throw BallerinaErrors.createError(BallerinaErrorReasons.KEY_NOT_FOUND_ERROR, "cannot find key '" + key + "'");
            }
            Object value2 = expectedType.getZeroValue();
            this.put(key, value2);
            Object v = value2;
            return v;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object merge(MapValue v2, boolean checkMergeability) {
        this.writeLock.lock();
        try {
            ErrorValue errorIfUnmergeable;
            ((MapValueImpl)v2).writeLock.lock();
            if (checkMergeability && (errorIfUnmergeable = JSONUtils.getErrorIfUnmergeable(this, v2, new ArrayList<JSONUtils.ObjectPair>())) != null) {
                ErrorValue errorValue = errorIfUnmergeable;
                return errorValue;
            }
            MapValueImpl m1 = this;
            MapValue m2 = v2;
            for (Map.Entry entry : m2.entrySet()) {
                String key = (String)entry.getKey();
                if (!m1.containsKey(key)) {
                    m1.put(key, entry.getValue());
                    continue;
                }
                m1.put(key, JSONUtils.mergeJson(m1.get(key), entry.getValue(), false));
            }
            MapValueImpl mapValueImpl = this;
            return mapValueImpl;
        }
        finally {
            ((MapValueImpl)v2).writeLock.unlock();
            this.writeLock.unlock();
        }
    }

    @Override
    public V put(K key, V value2) {
        this.writeLock.lock();
        try {
            if (this.freezeStatus.getState() != State.UNFROZEN) {
                FreezeUtils.handleInvalidUpdate(this.freezeStatus.getState());
            }
            V v = super.put(key, value2);
            return v;
        }
        catch (BLangFreezeException e) {
            String errMessage = "";
            switch (this.getType().getTag()) {
                case 12: {
                    errMessage = "Invalid update of record field: ";
                    break;
                }
                case 15: {
                    errMessage = "Invalid map insertion: ";
                }
            }
            throw BallerinaErrors.createError(e.getMessage(), errMessage + e.getDetail());
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void clear() {
        this.writeLock.lock();
        try {
            if (this.freezeStatus.getState() != State.UNFROZEN) {
                FreezeUtils.handleInvalidUpdate(this.freezeStatus.getState());
            }
            super.clear();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public boolean containsKey(Object key) {
        this.readLock.lock();
        try {
            boolean bl = super.containsKey(key);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public int hashCode() {
        return System.identityHashCode(this);
    }

    @Override
    public V remove(Object key) {
        this.writeLock.lock();
        try {
            if (this.freezeStatus.getState() != State.UNFROZEN) {
                FreezeUtils.handleInvalidUpdate(this.freezeStatus.getState());
            }
            Object v = super.remove(key);
            return v;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public K[] getKeys() {
        this.readLock.lock();
        try {
            Set keys = super.keySet();
            Object[] objectArray = keys.toArray(new String[keys.size()]);
            return objectArray;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public Collection<V> values() {
        this.readLock.lock();
        try {
            Collection collection = super.values();
            return collection;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public int size() {
        this.readLock.lock();
        try {
            int n = super.size();
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public boolean isEmpty() {
        this.readLock.lock();
        try {
            boolean bl = super.size() == 0;
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public String toString() {
        return this.stringValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object copy(Map<Object, Object> refs) {
        this.readLock.lock();
        try {
            if (this.isFrozen()) {
                MapValueImpl mapValueImpl = this;
                return mapValueImpl;
            }
            if (refs.containsKey(this)) {
                Object object = refs.get(this);
                return object;
            }
            MapValueImpl newMap = new MapValueImpl(this.type);
            refs.put(this, newMap);
            for (Map.Entry entry : super.entrySet()) {
                Object value2 = entry.getValue();
                value2 = value2 instanceof RefValue ? ((RefValue)value2).copy(refs) : value2;
                newMap.put(entry.getKey(), value2);
            }
            MapValueImpl mapValueImpl = newMap;
            return mapValueImpl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public Object frozenCopy(Map<Object, Object> refs) {
        MapValueImpl copy = (MapValueImpl)this.copy(refs);
        if (!copy.isFrozen()) {
            copy.freezeDirect();
        }
        return copy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String stringValue() {
        this.readLock.lock();
        StringJoiner sj = new StringJoiner(" ");
        try {
            switch (this.type.getTag()) {
                case 7: {
                    String string2 = this.getJSONString();
                    return string2;
                }
                case 15: {
                    if (((BMapType)this.type).getConstrainedType().getTag() != 7) break;
                    String string3 = this.getJSONString();
                    return string3;
                }
            }
            for (Map.Entry kvEntry : this.entrySet()) {
                Object key = kvEntry.getKey();
                Object value2 = kvEntry.getValue();
                sj.add(key + "=" + this.getStringValue(value2));
            }
            String string4 = sj.toString();
            return string4;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public BType getType() {
        return this.type;
    }

    @Override
    public void stamp(BType type, List<TypeValuePair> unresolvedValues) {
        TypeValuePair typeValuePair = new TypeValuePair(this, type);
        if (unresolvedValues.contains(typeValuePair)) {
            throw new BallerinaException(BallerinaErrorReasons.CYCLIC_VALUE_REFERENCE_ERROR, BLangExceptionHelper.getErrorMessage(RuntimeErrors.CYCLIC_VALUE_REFERENCE, this.type));
        }
        unresolvedValues.add(typeValuePair);
        if (type.getTag() == 7) {
            type = TypeConverter.resolveMatchingTypeForUnion(this, type);
            this.stamp(type, unresolvedValues);
        } else if (type.getTag() == 15) {
            for (Map.Entry valueEntry : this.entrySet()) {
                Object value2 = valueEntry.getValue();
                BType constraintType = ((BMapType)type).getConstrainedType();
                if (value2 instanceof RefValue) {
                    ((RefValue)value2).stamp(constraintType, unresolvedValues);
                    continue;
                }
                if (TypeChecker.checkIsType(value2, constraintType)) continue;
                this.put(valueEntry.getKey(), TypeConverter.convertValues(TypeConverter.getConvertibleTypes(value2, constraintType).get(0), value2));
            }
        } else if (type.getTag() == 12) {
            BRecordType recordType = (BRecordType)type;
            MapValueImpl recordWithDefaults = (MapValueImpl)BallerinaValues.createRecordValue(this.getPackageForValueCreator(recordType.getPackage()), recordType.getName());
            for (Map.Entry valueEntry : recordWithDefaults.entrySet()) {
                Object fieldName = valueEntry.getKey();
                if (this.containsKey(fieldName)) continue;
                this.put(fieldName, valueEntry.getValue());
            }
            BType restFieldType = recordType.restFieldType;
            HashMap<String, BType> targetTypeField = new HashMap<String, BType>();
            for (BField bField : recordType.getFields().values()) {
                targetTypeField.put(bField.getFieldName(), bField.getFieldType());
            }
            for (Map.Entry entry : this.entrySet()) {
                String fieldName = entry.getKey().toString();
                Object value3 = entry.getValue();
                BType bType = targetTypeField.getOrDefault(fieldName, restFieldType);
                if (value3 instanceof RefValue) {
                    ((RefValue)value3).stamp(bType, unresolvedValues);
                    continue;
                }
                if (TypeChecker.checkIsType(value3, bType)) continue;
                this.put(fieldName, TypeConverter.convertValues(TypeConverter.getConvertibleTypes(value3, bType).get(0), value3));
            }
        } else if (type.getTag() == 21) {
            for (BType memberType : ((BUnionType)type).getMemberTypes()) {
                if (!TypeChecker.checkIsLikeType(this, memberType)) continue;
                this.stamp(memberType, unresolvedValues);
                type = memberType.getTag() == 11 ? TypeConverter.resolveMatchingTypeForUnion(this, memberType) : memberType;
                break;
            }
        } else if (type.getTag() == 11) {
            type = TypeConverter.resolveMatchingTypeForUnion(this, type);
            this.stamp(type, unresolvedValues);
        }
        this.type = type;
        unresolvedValues.remove(typeValuePair);
    }

    private String getPackageForValueCreator(BPackage bPackage) {
        if (PERIOD.equals(bPackage.toString())) {
            return PERIOD;
        }
        String org = bPackage.org;
        String name = bPackage.name;
        return org.replace(PERIOD, UNDERSCORE).concat(SLASH).concat(name.replace(PERIOD, UNDERSCORE));
    }

    @Override
    public synchronized void attemptFreeze(Status freezeStatus) {
        if (this.type.getTag() == 35) {
            throw new BLangFreezeException("'freeze()' not allowed on '" + this.getType() + "'");
        }
        if (FreezeUtils.isOpenForFreeze(this.freezeStatus, freezeStatus)) {
            this.freezeStatus = freezeStatus;
            super.values().forEach((? super T val) -> {
                if (val instanceof RefValue) {
                    ((RefValue)val).attemptFreeze(freezeStatus);
                }
            });
        }
    }

    @Override
    public void freezeDirect() {
        if (this.isFrozen()) {
            return;
        }
        this.freezeStatus.setFrozen();
        this.values().forEach((? super T val) -> {
            if (val instanceof RefValue) {
                ((RefValue)val).freezeDirect();
            }
        });
    }

    @Override
    public synchronized boolean isFrozen() {
        return this.freezeStatus.isFrozen();
    }

    private String getStringValue(Object value2) {
        if (value2 == null) {
            return null;
        }
        return value2.toString();
    }

    public String getJSONString() {
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        JSONGenerator gen = new JSONGenerator(byteOut);
        try {
            gen.serialize(this);
            gen.flush();
        }
        catch (IOException e) {
            throw new BallerinaException("Error in converting JSON to a string: " + e.getMessage(), e);
        }
        return new String(byteOut.toByteArray());
    }

    @Override
    public IteratorValue getIterator() {
        return new MapIterator(new LinkedHashMap(this).entrySet().iterator());
    }

    @Override
    public void addNativeData(String key, Object data) {
        this.nativeData.put(key, data);
    }

    @Override
    public Object getNativeData(String key) {
        return this.nativeData.get(key);
    }

    public Map<String, Object> getNativeDataMap() {
        return this.nativeData;
    }

    static class MapIterator<K, V>
    implements IteratorValue {
        Iterator<Map.Entry<K, V>> iterator;

        MapIterator(Iterator<Map.Entry<K, V>> iterator) {
            this.iterator = iterator;
        }

        public Object next() {
            Map.Entry<K, V> next = this.iterator.next();
            V value2 = next.getValue();
            LinkedList<BType> types = new LinkedList<BType>();
            types.add(BTypes.typeString);
            types.add(TypeChecker.getType(value2));
            BTupleType tupleType = new BTupleType(types);
            ArrayValue tuple = new ArrayValue(tupleType);
            tuple.add(0L, next.getKey());
            tuple.add(1L, value2);
            return tuple;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }
    }
}

