/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.jvm.values;

import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import org.ballerinalang.jvm.BallerinaErrors;
import org.ballerinalang.jvm.ColumnDefinition;
import org.ballerinalang.jvm.DataIterator;
import org.ballerinalang.jvm.TableProvider;
import org.ballerinalang.jvm.TableUtils;
import org.ballerinalang.jvm.types.BStructureType;
import org.ballerinalang.jvm.types.BTableType;
import org.ballerinalang.jvm.types.BType;
import org.ballerinalang.jvm.types.BTypes;
import org.ballerinalang.jvm.util.exceptions.BallerinaErrorReasons;
import org.ballerinalang.jvm.values.ArrayValue;
import org.ballerinalang.jvm.values.CollectionValue;
import org.ballerinalang.jvm.values.DecimalValue;
import org.ballerinalang.jvm.values.IteratorValue;
import org.ballerinalang.jvm.values.MapValueImpl;
import org.ballerinalang.jvm.values.RefValue;
import org.ballerinalang.jvm.values.TableIterator;
import org.ballerinalang.jvm.values.freeze.FreezeUtils;
import org.ballerinalang.jvm.values.freeze.State;
import org.ballerinalang.jvm.values.freeze.Status;

public class TableValue
implements RefValue,
CollectionValue {
    protected DataIterator iterator;
    private boolean hasNextVal;
    private boolean nextPrefetched;
    private TableProvider tableProvider;
    private String tableName;
    private BStructureType constraintType;
    private ArrayValue primaryKeys;
    private ArrayValue indices;
    private boolean tableClosed;
    private volatile Status freezeStatus = new Status(State.UNFROZEN);
    private BType type;

    public TableValue() {
        this.iterator = null;
        this.tableProvider = null;
        this.nextPrefetched = false;
        this.hasNextVal = false;
        this.tableName = null;
        this.type = BTypes.typeTable;
    }

    public TableValue(String tableName, BStructureType constraintType) {
        this(constraintType);
        this.tableName = tableName;
    }

    public TableValue(BStructureType constraintType) {
        this.nextPrefetched = false;
        this.hasNextVal = false;
        this.constraintType = constraintType;
        this.type = new BTableType(constraintType);
    }

    public TableValue(String query, TableValue fromTable, TableValue joinTable, BStructureType constraintType, ArrayValue params) {
        this.tableProvider = TableProvider.getInstance();
        if (!fromTable.isInMemoryTable()) {
            throw BallerinaErrors.createError(BallerinaErrorReasons.TABLE_OPERATION_ERROR, "Table query over a cursor table not supported");
        }
        if (joinTable != null) {
            if (!joinTable.isInMemoryTable()) {
                throw BallerinaErrors.createError(BallerinaErrorReasons.TABLE_OPERATION_ERROR, "Table query over a cursor table not supported");
            }
            this.tableName = this.tableProvider.createTable(fromTable.tableName, joinTable.tableName, query, constraintType, params);
        } else {
            this.tableName = this.tableProvider.createTable(fromTable.tableName, query, constraintType, params);
        }
        this.constraintType = constraintType;
        this.type = new BTableType(constraintType);
    }

    public TableValue(BType type, ArrayValue indexColumns, ArrayValue keyColumns, ArrayValue dataRows) {
        BType constrainedType = ((BTableType)type).getConstrainedType();
        this.tableProvider = TableProvider.getInstance();
        this.tableName = this.tableProvider.createTable(constrainedType, keyColumns, indexColumns);
        this.constraintType = (BStructureType)constrainedType;
        this.type = new BTableType(this.constraintType);
        this.primaryKeys = keyColumns;
        this.indices = indexColumns;
        if (dataRows != null) {
            this.insertInitialData(dataRows);
        }
    }

    public String toString() {
        return this.stringValue();
    }

    @Override
    public String stringValue() {
        String constraint = this.constraintType != null ? "<" + this.constraintType.toString() + ">" : "";
        StringBuilder tableWrapper = new StringBuilder("table" + constraint + " ");
        StringJoiner tableContent = new StringJoiner(", ", "{", "}");
        tableContent.add(this.createStringValueEntry("index", this.indices));
        tableContent.add(this.createStringValueEntry("primaryKey", this.primaryKeys));
        tableContent.add(this.createStringValueDataEntry());
        tableWrapper.append(tableContent.toString());
        return tableWrapper.toString();
    }

    private String createStringValueEntry(String key, ArrayValue contents) {
        String stringValue = "[]";
        if (contents != null) {
            stringValue = contents.toString();
        }
        return key + ": " + stringValue;
    }

    private String createStringValueDataEntry() {
        StringBuilder sb = new StringBuilder();
        sb.append("data: ");
        StringJoiner sj = new StringJoiner(", ", "[", "]");
        while (this.hasNext()) {
            MapValueImpl<String, Object> struct = this.getNext();
            sj.add(struct.toString());
        }
        sb.append(sj.toString());
        return sb.toString();
    }

    @Override
    public BType getType() {
        return this.type;
    }

    public boolean hasNext() {
        if (this.tableClosed) {
            throw BallerinaErrors.createError(BallerinaErrorReasons.TABLE_OPERATION_ERROR, "Trying to perform hasNext operation over a closed table");
        }
        if (this.isIteratorGenerationConditionMet()) {
            this.generateIterator();
        }
        if (!this.nextPrefetched) {
            this.hasNextVal = this.iterator.next();
            this.nextPrefetched = true;
        }
        if (!this.hasNextVal) {
            this.reset();
        }
        return this.hasNextVal;
    }

    public void moveToNext() {
        if (this.tableClosed) {
            throw BallerinaErrors.createError(BallerinaErrorReasons.TABLE_CLOSED_ERROR, "Trying to perform an operation over a closed table");
        }
        if (this.isIteratorGenerationConditionMet()) {
            this.generateIterator();
        }
        if (!this.nextPrefetched) {
            this.iterator.next();
        } else {
            this.nextPrefetched = false;
        }
    }

    public void close() {
        if (this.iterator != null) {
            this.iterator.close();
        }
        this.tableClosed = true;
    }

    public void reset() {
        if (this.iterator != null) {
            this.iterator.reset();
            this.iterator = null;
        }
        this.resetIterationHelperAttributes();
    }

    public MapValueImpl<String, Object> getNext() {
        this.moveToNext();
        return (MapValueImpl)this.iterator.generateNext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object performAddOperation(MapValueImpl<String, Object> data) {
        TableValue tableValue = this;
        synchronized (tableValue) {
            if (this.freezeStatus.getState() != State.UNFROZEN) {
                FreezeUtils.handleInvalidUpdate(this.freezeStatus.getState());
            }
        }
        try {
            this.addData(data);
            return null;
        }
        catch (Throwable e) {
            return TableUtils.createTableOperationError(e);
        }
    }

    public void addData(MapValueImpl<String, Object> data) {
        if (data.getType() != this.constraintType) {
            throw BallerinaErrors.createError(BallerinaErrorReasons.TABLE_OPERATION_ERROR, "incompatible types: record of type:" + data.getType().getName() + " cannot be added to a table with type:" + this.constraintType.getName());
        }
        this.tableProvider.insertData(this.tableName, data);
        this.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object performRemoveOperation() {
        TableValue tableValue = this;
        synchronized (tableValue) {
            if (this.freezeStatus.getState() != State.UNFROZEN) {
                FreezeUtils.handleInvalidUpdate(this.freezeStatus.getState());
            }
        }
        return TableUtils.createTableOperationError(new Exception("Remove operation is not supported yet"));
    }

    public String getString(int columnIndex) {
        return this.iterator.getString(columnIndex);
    }

    public Long getInt(int columnIndex) {
        return this.iterator.getInt(columnIndex);
    }

    public Double getFloat(int columnIndex) {
        return this.iterator.getFloat(columnIndex);
    }

    public Boolean getBoolean(int columnIndex) {
        return this.iterator.getBoolean(columnIndex);
    }

    public String getBlob(int columnIndex) {
        return this.iterator.getBlob(columnIndex);
    }

    public Object[] getStruct(int columnIndex) {
        return this.iterator.getStruct(columnIndex);
    }

    public Object[] getArray(int columnIndex) {
        return this.iterator.getArray(columnIndex);
    }

    public DecimalValue getDecimal(int columnIndex) {
        return this.iterator.getDecimal(columnIndex);
    }

    public List<ColumnDefinition> getColumnDefs() {
        return this.iterator.getColumnDefinitions();
    }

    public BStructureType getStructType() {
        return this.iterator.getStructType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object copy(Map<Object, Object> refs) {
        if (this.tableClosed) {
            throw BallerinaErrors.createError(BallerinaErrorReasons.TABLE_OPERATION_ERROR, "Trying to invoke clone built-in method over a closed table");
        }
        if (this.isFrozen()) {
            return this;
        }
        if (refs.containsKey(this)) {
            return refs.get(this);
        }
        TableIterator cloneIterator = this.tableProvider.createIterator(this.tableName, this.constraintType);
        ArrayValue data = new ArrayValue();
        int cursor = 0;
        try {
            while (cloneIterator.next()) {
                data.add((long)cursor++, cloneIterator.generateNext());
            }
            TableValue table2 = new TableValue(new BTableType(this.constraintType), this.indices, this.primaryKeys, data);
            refs.put(this, table2);
            TableValue tableValue = table2;
            return tableValue;
        }
        finally {
            cloneIterator.close();
        }
    }

    @Override
    public Object frozenCopy(Map<Object, Object> refs) {
        TableValue copy = (TableValue)this.copy(refs);
        if (!copy.isFrozen()) {
            copy.freezeDirect();
        }
        return copy;
    }

    @Override
    public IteratorValue getIterator() {
        return new TableValueIterator(this);
    }

    private void generateIterator() {
        this.iterator = this.tableProvider.createIterator(this.tableName, this.constraintType);
        this.resetIterationHelperAttributes();
    }

    protected boolean isIteratorGenerationConditionMet() {
        return this.iterator == null;
    }

    protected void resetIterationHelperAttributes() {
        this.nextPrefetched = false;
        this.hasNextVal = false;
    }

    public void finalize() {
        if (this.iterator != null) {
            this.iterator.close();
        }
        this.tableProvider.dropTable(this.tableName);
    }

    private void insertInitialData(ArrayValue data) {
        int count = data.size();
        for (int i = 0; i < count; ++i) {
            this.addData((MapValueImpl)data.getRefValue(i));
        }
    }

    public boolean isInMemoryTable() {
        return true;
    }

    @Override
    public int size() {
        if (this.tableName == null) {
            return 0;
        }
        return this.tableProvider.getRowCount(this.tableName);
    }

    public ArrayValue getPrimaryKeys() {
        return this.primaryKeys;
    }

    @Override
    public synchronized boolean isFrozen() {
        return this.freezeStatus.isFrozen();
    }

    @Override
    public synchronized void attemptFreeze(Status freezeStatus) {
        if (FreezeUtils.isOpenForFreeze(this.freezeStatus, freezeStatus)) {
            this.freezeStatus = freezeStatus;
        }
    }

    @Override
    public void freezeDirect() {
        this.freezeStatus.setFrozen();
    }

    private static class TableValueIterator
    implements IteratorValue {
        private TableValue table;

        TableValueIterator(TableValue value2) {
            this.table = value2;
        }

        @Override
        public boolean hasNext() {
            return this.table.hasNext();
        }

        public Object next() {
            if (this.hasNext()) {
                return this.table.getNext();
            }
            return null;
        }
    }
}

