/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.jvm.values;

import java.util.HashMap;
import java.util.Map;
import org.ballerinalang.jvm.scheduling.Scheduler;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.util.exceptions.BallerinaException;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.jvm.values.ObjectValue;

public abstract class ValueCreator {
    private static final Map<String, ValueCreator> runtimeValueCreators = new HashMap<String, ValueCreator>();

    public static void addValueCreator(String key, ValueCreator valueCreater) {
        if (!key.equals(".") && runtimeValueCreators.containsKey(key)) {
            return;
        }
        runtimeValueCreators.put(key, valueCreater);
    }

    public static ValueCreator getValueCreator(String key) {
        if (!runtimeValueCreators.containsKey(key)) {
            throw new BallerinaException("Value creator object is not available");
        }
        return runtimeValueCreators.get(key);
    }

    public abstract MapValue<String, Object> createRecordValue(String var1);

    public abstract ObjectValue createObjectValue(String var1, Scheduler var2, Strand var3, Map<String, Object> var4, Object[] var5);
}

