/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.jvm.values;

import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.ballerinalang.jvm.TypeConverter;
import org.ballerinalang.jvm.XMLNodeType;
import org.ballerinalang.jvm.commons.TypeValuePair;
import org.ballerinalang.jvm.types.BType;
import org.ballerinalang.jvm.types.BTypes;
import org.ballerinalang.jvm.util.exceptions.BallerinaException;
import org.ballerinalang.jvm.values.CollectionValue;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.jvm.values.RefValue;
import org.ballerinalang.jvm.values.XMLItem;
import org.ballerinalang.jvm.values.XMLQName;
import org.ballerinalang.jvm.values.freeze.State;
import org.ballerinalang.jvm.values.freeze.Status;

public abstract class XMLValue<T>
implements RefValue,
CollectionValue {
    BType type = BTypes.typeXML;
    public static final String COMMENT_START = "<!--";
    public static final String COMMENT_END = "-->";
    public static final String PI_START = "<?";
    public static final String PI_END = "?>";
    protected volatile Status freezeStatus = new Status(State.UNFROZEN);

    public abstract boolean isEmpty();

    public abstract boolean isSingleton();

    public abstract String getItemType();

    public abstract String getElementName();

    public abstract String getTextValue();

    public abstract String getAttribute(String var1, String var2);

    public abstract String getAttribute(String var1, String var2, String var3);

    public String getAttribute(XMLQName attributeName) {
        return this.getAttribute(attributeName.getLocalName(), attributeName.getUri(), attributeName.getPrefix());
    }

    public abstract void setAttribute(String var1, String var2, String var3, String var4);

    public void setAttribute(XMLQName attributeName, String value2) {
        this.setAttribute(attributeName.getLocalName(), attributeName.getUri(), attributeName.getPrefix(), value2);
    }

    public abstract MapValue<String, ?> getAttributesMap();

    public abstract void setAttributes(MapValue<String, ?> var1);

    public abstract XMLValue<?> elements();

    public abstract XMLValue<?> elements(String var1);

    public abstract XMLValue<?> children();

    public abstract XMLValue<?> children(String var1);

    public abstract void setChildren(XMLValue<?> var1);

    public abstract void addChildren(XMLValue<?> var1);

    public abstract XMLValue<?> strip();

    public abstract XMLNodeType getNodeType();

    public abstract XMLValue<?> slice(long var1, long var3);

    public abstract XMLValue<?> descendants(String var1);

    public abstract XMLValue<?> getItem(int var1);

    @Override
    public abstract int size();

    public abstract void build();

    @Override
    public BType getType() {
        return this.type;
    }

    @Override
    public void stamp(BType type, List<TypeValuePair> unresolvedValues) {
        if (type.getTag() == 11) {
            type = TypeConverter.resolveMatchingTypeForUnion(this, type);
        }
        this.type = type;
    }

    protected static void handleXmlException(String message, Throwable t) {
        if (t.getCause() != null) {
            throw new BallerinaException(message + t.getCause().getMessage());
        }
        throw new BallerinaException(message + t.getMessage());
    }

    protected QName getQname(String qname) {
        String nsUri;
        String localname;
        int rParenIndex = qname.indexOf(125);
        if (qname.startsWith("{") && rParenIndex > 0) {
            localname = qname.substring(rParenIndex + 1, qname.length());
            nsUri = qname.substring(1, rParenIndex);
        } else {
            localname = qname;
            nsUri = "";
        }
        return new QName(nsUri, localname);
    }

    protected void addDescendants(List<XMLValue<?>> descendants, OMElement currentElement, String qname) {
        Iterator childrenItr = currentElement.getChildren();
        while (childrenItr.hasNext()) {
            OMNode child = (OMNode)childrenItr.next();
            if (child.getType() != 1) continue;
            if (qname.equals(((OMElement)child).getQName().toString())) {
                descendants.add(new XMLItem(child));
                continue;
            }
            this.addDescendants(descendants, (OMElement)child, qname);
        }
    }

    public abstract void removeAttribute(String var1);

    public abstract void removeChildren(String var1);

    @Override
    public synchronized boolean isFrozen() {
        return this.freezeStatus.isFrozen();
    }

    public abstract T value();
}

