/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.jvm.values.connector;

import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import org.ballerinalang.jvm.util.exceptions.BLangRuntimeException;
import org.ballerinalang.jvm.values.connector.BallerinaServerConnector;

public class ServerConnectorRegistry {
    private Map<String, BallerinaServerConnector> serverConnectorMap = new HashMap<String, BallerinaServerConnector>();
    private boolean initialized = false;

    public void initServerConnectors() {
        if (this.initialized) {
            return;
        }
        ServiceLoader<BallerinaServerConnector> serverConnectorServiceLoader = ServiceLoader.load(BallerinaServerConnector.class);
        serverConnectorServiceLoader.forEach(serverConnector -> serverConnector.getProtocolPackages().forEach(protocolPkg -> {
            if (this.serverConnectorMap.containsKey(protocolPkg)) {
                throw new BLangRuntimeException("Multiple server connectors in the runtime for given protocol module - " + protocolPkg);
            }
            this.serverConnectorMap.put((String)protocolPkg, (BallerinaServerConnector)serverConnector);
        }));
        this.initialized = true;
    }

    public void deploymentComplete() {
        this.serverConnectorMap.values().forEach(BallerinaServerConnector::deploymentComplete);
    }

    public BallerinaServerConnector getBallerinaServerConnector(String protocolPkgPath) {
        return this.serverConnectorMap.get(protocolPkgPath);
    }
}

