/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.jvm.values.freeze;

import org.ballerinalang.jvm.util.exceptions.BLangFreezeException;
import org.ballerinalang.jvm.util.exceptions.BallerinaErrorReasons;
import org.ballerinalang.jvm.values.freeze.State;
import org.ballerinalang.jvm.values.freeze.Status;

public class FreezeUtils {
    public static boolean isOpenForFreeze(Status currentFreezeStatus, Status receivedFreezeStatus) {
        switch (currentFreezeStatus.getState()) {
            case FROZEN: {
                return false;
            }
            case MID_FREEZE: {
                if (currentFreezeStatus == receivedFreezeStatus) {
                    return false;
                }
                throw new BLangFreezeException(BallerinaErrorReasons.CONCURRENT_MODIFICATION_ERROR, "concurrent 'freeze()' attempts not allowed");
            }
        }
        return true;
    }

    public static void handleInvalidUpdate(State currentState) {
        switch (currentState) {
            case FROZEN: {
                throw new BLangFreezeException(BallerinaErrorReasons.INVALID_UPDATE_ERROR, "modification not allowed on readonly value");
            }
            case MID_FREEZE: {
                throw new BLangFreezeException(BallerinaErrorReasons.INVALID_UPDATE_ERROR, "modification not allowed during freeze");
            }
        }
    }
}

