/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.jvm.values.utils;

import org.ballerinalang.jvm.BallerinaErrors;
import org.ballerinalang.jvm.types.BType;
import org.ballerinalang.jvm.util.exceptions.BallerinaErrorReasons;
import org.ballerinalang.jvm.values.ArrayValue;
import org.ballerinalang.jvm.values.ErrorValue;
import org.ballerinalang.jvm.values.utils.GetFunction;

public class ArrayUtils {
    public static void add(ArrayValue arr, int elemTypeTag, long index, Object value2) {
        switch (elemTypeTag) {
            case 1: {
                arr.add(index, (Long)value2);
                break;
            }
            case 6: {
                arr.add(index, (Boolean)value2);
                break;
            }
            case 2: {
                arr.add(index, (Byte)value2);
                break;
            }
            case 3: {
                arr.add(index, (Double)value2);
                break;
            }
            case 5: {
                arr.add(index, (String)value2);
                break;
            }
            default: {
                arr.add(index, value2);
            }
        }
    }

    public static GetFunction getElementAccessFunction(BType arrType, String funcName) {
        switch (arrType.getTag()) {
            case 20: {
                return ArrayValue::get;
            }
            case 31: {
                return ArrayValue::getRefValue;
            }
        }
        throw ArrayUtils.createOpNotSupportedError(arrType, funcName);
    }

    public static void checkIsArrayOnlyOperation(BType arrType, String op) {
        if (arrType.getTag() != 20) {
            throw ArrayUtils.createOpNotSupportedError(arrType, op);
        }
    }

    public static ErrorValue createOpNotSupportedError(BType type, String op) {
        return BallerinaErrors.createError(BallerinaErrorReasons.OPERATION_NOT_SUPPORTED, String.format("%s not supported on type '%s'", op, type.getQualifiedName()));
    }
}

