/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langlib.array;

import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.values.ArrayValue;
import org.ballerinalang.jvm.values.FPValue;
import org.ballerinalang.jvm.values.utils.ArrayUtils;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.natives.annotations.Argument;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.ReturnType;

@BallerinaFunction(orgName="ballerina", packageName="lang.array", functionName="sort", args={@Argument(name="arr", type=TypeKind.ARRAY), @Argument(name="func", type=TypeKind.FUNCTION)}, returnType={@ReturnType(type=TypeKind.ARRAY)}, isPublic=true)
public class Sort {
    public static ArrayValue sort(Strand strand, ArrayValue arr, FPValue<Object, Long> func) {
        ArrayUtils.checkIsArrayOnlyOperation(arr.getType(), "sort()");
        return Sort.mergesort(arr, strand, func);
    }

    private static ArrayValue mergesort(ArrayValue input, Strand strand, FPValue<Object, Long> comparator) {
        int i;
        int n = input.size();
        if (n <= 1) {
            return input;
        }
        ArrayValue leftArr = new ArrayValue(input.getType());
        ArrayValue rightArr = new ArrayValue(input.getType());
        int leftArrSize = n / 2;
        int rightArrSize = n - n / 2;
        int elemTypeTag = input.elementType.getTag();
        for (i = 0; i < leftArrSize; ++i) {
            ArrayUtils.add(leftArr, elemTypeTag, i, input.get(i));
        }
        for (i = 0; i < rightArrSize; ++i) {
            ArrayUtils.add(rightArr, elemTypeTag, i, input.get(i + n / 2));
        }
        return Sort.merge(Sort.mergesort(leftArr, strand, comparator), Sort.mergesort(rightArr, strand, comparator), strand, comparator);
    }

    private static ArrayValue merge(ArrayValue leftArr, ArrayValue rightArr, Strand strand, FPValue<Object, Long> comparator) {
        ArrayValue mergedArr = new ArrayValue(leftArr.getType());
        int leftArrSize = leftArr.size();
        int rightArrSize = rightArr.size();
        int mergedArrSize = leftArrSize + rightArrSize;
        int elemTypeTag = mergedArr.elementType.getTag();
        int i = 0;
        int j = 0;
        for (int k = 0; k < mergedArrSize; ++k) {
            if (i >= leftArrSize) {
                ArrayUtils.add(mergedArr, elemTypeTag, k, rightArr.get(j++));
                continue;
            }
            if (j >= rightArrSize) {
                ArrayUtils.add(mergedArr, elemTypeTag, k, leftArr.get(i++));
                continue;
            }
            if (comparator.apply(new Object[]{strand, leftArr.get(i), true, rightArr.get(j), true}) <= 0L) {
                ArrayUtils.add(mergedArr, elemTypeTag, k, leftArr.get(i++));
                continue;
            }
            ArrayUtils.add(mergedArr, elemTypeTag, k, rightArr.get(j++));
        }
        return mergedArr;
    }
}

