/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langlib.map;

import org.ballerinalang.jvm.BallerinaErrors;
import org.ballerinalang.jvm.MapUtils;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.util.exceptions.BLangFreezeException;
import org.ballerinalang.jvm.util.exceptions.BallerinaErrorReasons;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.natives.annotations.Argument;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.ReturnType;

@BallerinaFunction(orgName="ballerina", packageName="lang.map", functionName="remove", args={@Argument(name="m", type=TypeKind.MAP), @Argument(name="k", type=TypeKind.STRING)}, returnType={@ReturnType(type=TypeKind.ANY)}, isPublic=true)
public class Remove {
    public static Object remove(Strand strand, MapValue<?, ?> m, String k) {
        MapUtils.checkIsMapOnlyOperation(m.getType(), "remove()");
        if (m.containsKey(k)) {
            try {
                return m.remove(k);
            }
            catch (BLangFreezeException e) {
                throw BallerinaErrors.createError(e.getMessage(), "Failed to remove element from map: " + e.getDetail());
            }
        }
        throw BallerinaErrors.createError(BallerinaErrorReasons.KEY_NOT_FOUND_ERROR, "cannot find key '" + k + "'");
    }
}

