/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langlib.typedesc;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.ballerinalang.jvm.BallerinaErrors;
import org.ballerinalang.jvm.JSONUtils;
import org.ballerinalang.jvm.TypeChecker;
import org.ballerinalang.jvm.TypeConverter;
import org.ballerinalang.jvm.XMLFactory;
import org.ballerinalang.jvm.commons.TypeValuePair;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.types.BType;
import org.ballerinalang.jvm.types.BTypedescType;
import org.ballerinalang.jvm.util.exceptions.BLangExceptionHelper;
import org.ballerinalang.jvm.util.exceptions.BallerinaErrorReasons;
import org.ballerinalang.jvm.util.exceptions.BallerinaException;
import org.ballerinalang.jvm.util.exceptions.RuntimeErrors;
import org.ballerinalang.jvm.values.RefValue;
import org.ballerinalang.jvm.values.TableValue;
import org.ballerinalang.jvm.values.TypedescValue;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.natives.annotations.Argument;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.ReturnType;

@BallerinaFunction(orgName="ballerina", packageName="lang.typedesc", functionName="constructFrom", args={@Argument(name="t", type=TypeKind.TYPEDESC), @Argument(name="v", type=TypeKind.ANYDATA)}, returnType={@ReturnType(type=TypeKind.ANYDATA), @ReturnType(type=TypeKind.ERROR)}, isPublic=true)
public class ConstructFrom {
    private static final String AMBIGUOUS_TARGET = "ambiguous target type";

    public static Object constructFrom(Strand strand, TypedescValue t, Object v) {
        BType describingType = t.getDescribingType();
        if (describingType.getTag() == 13) {
            return ConstructFrom.convert(((BTypedescType)t.getDescribingType()).getConstraint(), v);
        }
        return ConstructFrom.convert(describingType, v);
    }

    public static Object convert(BType convertType, Object inputValue) {
        if (inputValue == null) {
            if (convertType.isNilable()) {
                return null;
            }
            return BallerinaErrors.createError(BallerinaErrorReasons.CONVERSION_ERROR, BLangExceptionHelper.getErrorMessage(RuntimeErrors.CANNOT_CONVERT_NIL, convertType));
        }
        BType inputValType = TypeChecker.getType(inputValue);
        List<BType> convertibleTypes = TypeConverter.getConvertibleTypes(inputValue, convertType);
        if (convertibleTypes.size() == 0) {
            if (inputValType.getTag() == 9) {
                switch (convertType.getTag()) {
                    case 7: {
                        return JSONUtils.toJSON((TableValue)inputValue);
                    }
                    case 8: {
                        return XMLFactory.tableToXML((TableValue)inputValue);
                    }
                }
            }
            return BallerinaErrors.createConversionError(inputValue, convertType);
        }
        if (convertibleTypes.size() > 1) {
            return BallerinaErrors.createConversionError(inputValue, convertType, AMBIGUOUS_TARGET);
        }
        BType targetType = convertibleTypes.get(0);
        if (inputValType.getTag() < 7) {
            if (!TypeChecker.checkIsType(inputValue, convertType)) {
                return TypeConverter.convertValues(targetType, inputValue);
            }
            return inputValue;
        }
        try {
            RefValue refValue = (RefValue)inputValue;
            if (targetType.equals(inputValType)) {
                return refValue.copy(new HashMap<Object, Object>());
            }
            RefValue convertedValue = (RefValue)refValue.copy(new HashMap<Object, Object>());
            convertedValue.stamp(targetType, new ArrayList<TypeValuePair>());
            return convertedValue;
        }
        catch (BallerinaException e) {
            return BallerinaErrors.createError(BallerinaErrorReasons.CONVERSION_ERROR, e.getDetail());
        }
    }
}

