/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langlib.xml;

import org.ballerinalang.jvm.XMLNodeType;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.types.BArrayType;
import org.ballerinalang.jvm.types.BTypes;
import org.ballerinalang.jvm.util.exceptions.BLangExceptionHelper;
import org.ballerinalang.jvm.values.ArrayValue;
import org.ballerinalang.jvm.values.IteratorValue;
import org.ballerinalang.jvm.values.XMLSequence;
import org.ballerinalang.jvm.values.XMLValue;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.ReturnType;

@BallerinaFunction(orgName="ballerina", packageName="lang.xml", functionName="elements", returnType={@ReturnType(type=TypeKind.XML)}, isPublic=true)
public class Elements {
    private static final String OPERATION = "get elements from xml";

    public static XMLValue<?> elements(Strand strand, XMLValue<?> xml2) {
        try {
            if (xml2.getNodeType() == XMLNodeType.TEXT) {
                return Elements.generateCodePointSequence(xml2);
            }
            return xml2.elements();
        }
        catch (Throwable e) {
            BLangExceptionHelper.handleXMLException(OPERATION, e);
            return null;
        }
    }

    private static XMLValue<?> generateCodePointSequence(XMLValue<?> value2) {
        ArrayValue array2 = new ArrayValue(new BArrayType(BTypes.typeXML));
        IteratorValue bIterator = value2.getIterator();
        long i = 0L;
        while (bIterator.hasNext()) {
            array2.add(i++, bIterator.next());
        }
        return new XMLSequence(array2);
    }
}

