/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.logging;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import java.util.logging.SocketHandler;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.ballerinalang.config.ConfigRegistry;
import org.ballerinalang.logging.formatters.HttpAccessLogFormatter;
import org.ballerinalang.logging.formatters.HttpTraceLogFormatter;
import org.ballerinalang.logging.formatters.JsonLogFormatter;
import org.ballerinalang.logging.util.BLogLevel;
import org.ballerinalang.logging.util.Constants;

public class BLogManager
extends LogManager {
    public static final String BALLERINA_ROOT_LOGGER_NAME = "ballerina";
    public static final int LOGGER_PREFIX_LENGTH = "ballerina".length() + 1;
    private static final Pattern varPattern = Pattern.compile("\\$\\{([^}]*)}");
    private Map<String, BLogLevel> loggerLevels = new HashMap<String, BLogLevel>();
    private BLogLevel ballerinaUserLogLevel = BLogLevel.INFO;
    private Logger httpTraceLogger;
    private Logger httpAccessLogger;

    @Override
    public void readConfiguration(InputStream ins) throws IOException, SecurityException {
        Properties properties = new Properties();
        properties.load(ins);
        properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> {
            String val = this.substituteVariables((String)v);
            properties.setProperty((String)k, val);
        }));
        String breLogPath = this.initBRELogHandler(properties.getProperty(Constants.DEFAULT_LOG_FILE_HANDLER_PATTERN));
        properties.setProperty(Constants.DEFAULT_LOG_FILE_HANDLER_PATTERN, breLogPath);
        super.readConfiguration(this.propertiesToInputStream(properties));
    }

    public void loadUserProvidedLogConfiguration() {
        ConfigRegistry configRegistry = ConfigRegistry.getInstance();
        Iterator<String> keys = configRegistry.keySetIterator();
        keys.forEachRemaining(key -> {
            if (key.endsWith(".loglevel")) {
                this.loggerLevels.put(key.substring(0, key.length() - ".loglevel".length()), BLogLevel.toBLogLevel(configRegistry.getAsString((String)key)));
            }
        });
        String userLogLevel = configRegistry.getAsString("b7a.log.level");
        if (userLogLevel != null) {
            this.ballerinaUserLogLevel = BLogLevel.toBLogLevel(userLogLevel);
        }
        this.loggerLevels.put("b7a.log.level", this.ballerinaUserLogLevel);
        this.setHttpTraceLogHandler();
        this.setHttpAccessLogHandler();
    }

    public BLogLevel getPackageLogLevel(String pkg) {
        return this.loggerLevels.containsKey(pkg) ? this.loggerLevels.get(pkg) : this.ballerinaUserLogLevel;
    }

    public void setHttpTraceLogHandler() {
        String logFilePath;
        if (this.httpTraceLogger == null) {
            this.httpTraceLogger = Logger.getLogger("http.tracelog");
        }
        ConfigRegistry configRegistry = ConfigRegistry.getInstance();
        PrintStream stdErr = System.err;
        boolean tracelogsEnabled = false;
        String consoleLogEnabled = configRegistry.getAsString("b7a.http.tracelog.console");
        if (Boolean.parseBoolean(consoleLogEnabled)) {
            ConsoleHandler consoleHandler = new ConsoleHandler();
            consoleHandler.setFormatter(new HttpTraceLogFormatter());
            consoleHandler.setLevel(Level.FINEST);
            this.httpTraceLogger.addHandler(consoleHandler);
            tracelogsEnabled = true;
        }
        if ((logFilePath = configRegistry.getAsString("b7a.http.tracelog.path")) != null && !logFilePath.trim().isEmpty()) {
            try {
                FileHandler fileHandler = new FileHandler(logFilePath, true);
                fileHandler.setFormatter(new HttpTraceLogFormatter());
                fileHandler.setLevel(Level.FINEST);
                this.httpTraceLogger.addHandler(fileHandler);
                tracelogsEnabled = true;
            }
            catch (IOException e) {
                throw new RuntimeException("failed to setup HTTP trace log file: " + logFilePath, e);
            }
        }
        String host = configRegistry.getAsString("b7a.http.tracelog.host");
        String port = configRegistry.getAsString("b7a.http.tracelog.port");
        if (host != null && !host.trim().isEmpty() && port != null && !port.trim().isEmpty()) {
            try {
                SocketHandler socketHandler = new SocketHandler(host, Integer.parseInt(port));
                socketHandler.setFormatter(new JsonLogFormatter());
                socketHandler.setLevel(Level.FINEST);
                this.httpTraceLogger.addHandler(socketHandler);
                tracelogsEnabled = true;
            }
            catch (IOException e) {
                throw new RuntimeException("failed to connect to " + host + ":" + port, e);
            }
        }
        if (tracelogsEnabled) {
            this.httpTraceLogger.setLevel(Level.FINEST);
            System.setProperty("http.tracelog.enabled", "true");
            stdErr.println("ballerina: HTTP trace log enabled");
        }
    }

    public void setHttpAccessLogHandler() {
        String filePath;
        if (this.httpAccessLogger == null) {
            this.httpAccessLogger = Logger.getLogger("http.accesslog");
        }
        ConfigRegistry configRegistry = ConfigRegistry.getInstance();
        PrintStream stdErr = System.err;
        boolean accesslogsEnabled = false;
        String consoleLogEnabled = configRegistry.getAsString("b7a.http.accesslog.console");
        if (Boolean.parseBoolean(consoleLogEnabled)) {
            ConsoleHandler consoleHandler = new ConsoleHandler();
            consoleHandler.setFormatter(new HttpAccessLogFormatter());
            consoleHandler.setLevel(Level.INFO);
            this.httpAccessLogger.addHandler(consoleHandler);
            this.httpAccessLogger.setLevel(Level.INFO);
            accesslogsEnabled = true;
        }
        if ((filePath = configRegistry.getAsString("b7a.http.accesslog.path")) != null && !filePath.trim().isEmpty()) {
            try {
                FileHandler fileHandler = new FileHandler(filePath, true);
                fileHandler.setFormatter(new HttpAccessLogFormatter());
                fileHandler.setLevel(Level.INFO);
                this.httpAccessLogger.addHandler(fileHandler);
                this.httpAccessLogger.setLevel(Level.INFO);
                accesslogsEnabled = true;
            }
            catch (IOException e) {
                throw new RuntimeException("failed to setup HTTP access log file: " + filePath, e);
            }
        }
        if (accesslogsEnabled) {
            System.setProperty("http.accesslog.enabled", "true");
            stdErr.println("ballerina: HTTP access log enabled");
        }
    }

    private String substituteVariables(String value2) {
        Matcher matcher = varPattern.matcher(value2);
        boolean found = matcher.find();
        if (!found) {
            return value2;
        }
        StringBuffer buffer = new StringBuffer();
        do {
            String sysPropertyKey;
            String sysPropertyValue;
            if ((sysPropertyValue = this.getSystemVariableValue(sysPropertyKey = matcher.group(1))) == null || sysPropertyValue.isEmpty()) continue;
            sysPropertyValue = sysPropertyValue.replace("\\", "\\\\");
            matcher.appendReplacement(buffer, sysPropertyValue);
        } while (matcher.find());
        matcher.appendTail(buffer);
        return buffer.toString();
    }

    private String getSystemVariableValue(String variableName) {
        String value2 = System.getProperty(variableName) != null ? System.getProperty(variableName) : (System.getenv(variableName) != null ? System.getenv(variableName) : variableName);
        return value2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InputStream propertiesToInputStream(Properties properties) throws IOException {
        try (ByteArrayOutputStream outputStream = null;){
            outputStream = new ByteArrayOutputStream();
            properties.store(outputStream, "Java util logging configuration properties");
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(outputStream.toByteArray());
            return byteArrayInputStream;
        }
    }

    private String initBRELogHandler(String fileName) throws IOException {
        if (fileName == null || fileName.trim().isEmpty()) {
            fileName = "ballerina-internal.log";
        }
        if (Files.isWritable(Paths.get(Constants.USER_DIR, new String[0]))) {
            return Paths.get(Constants.USER_DIR, fileName).toString();
        }
        return Paths.get(Constants.TEMP_DIR, fileName).toString();
    }
}

