/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.model;

import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.ballerinalang.model.AnnotationAttachmentPoint;
import org.ballerinalang.model.AnnotationAttributeValue;
import org.ballerinalang.model.Node;
import org.ballerinalang.model.NodeLocation;
import org.ballerinalang.model.WhiteSpaceDescriptor;
import org.ballerinalang.model.values.BValue;

public class AnnotationAttachment
implements Node {
    private String name;
    private String pkgName;
    private String pkgPath;
    private Map<String, AnnotationAttributeValue> attributeNameValPairs = new HashMap<String, AnnotationAttributeValue>();
    private NodeLocation location;
    private WhiteSpaceDescriptor whiteSpaceDescriptor;
    AnnotationAttachmentPoint attachedPoint;

    public AnnotationAttachment(NodeLocation location, WhiteSpaceDescriptor whiteSpaceDescriptor, String name, String pkgName, String pkgPath, Map<String, AnnotationAttributeValue> fieldValPairs) {
        this.location = location;
        this.whiteSpaceDescriptor = whiteSpaceDescriptor;
        this.name = name;
        this.pkgName = pkgName;
        this.pkgPath = pkgPath;
        this.attributeNameValPairs = fieldValPairs;
    }

    public String getName() {
        return this.name;
    }

    public String getPkgName() {
        return this.pkgName;
    }

    public String getPkgPath() {
        return this.pkgPath;
    }

    public Map<String, AnnotationAttributeValue> getAttributeNameValuePairs() {
        return this.attributeNameValPairs;
    }

    public AnnotationAttributeValue getAttribute(String attributeName) {
        return this.attributeNameValPairs.get(attributeName);
    }

    @Override
    public NodeLocation getNodeLocation() {
        return this.location;
    }

    public void setWhiteSpaceDescriptor(WhiteSpaceDescriptor whiteSpaceDescriptor) {
        this.whiteSpaceDescriptor = whiteSpaceDescriptor;
    }

    @Override
    public WhiteSpaceDescriptor getWhiteSpaceDescriptor() {
        return this.whiteSpaceDescriptor;
    }

    public void setAttachedPoint(AnnotationAttachmentPoint attachedPoint) {
        this.attachedPoint = attachedPoint;
    }

    public AnnotationAttachmentPoint getAttachedPoint() {
        return this.attachedPoint;
    }

    public void addAttributeNameValuePair(String name, AnnotationAttributeValue value2) {
        this.attributeNameValPairs.put(name, value2);
    }

    public String toString() {
        String nameValuePairs = this.attributeNameValPairs.entrySet().stream().map(nameValue -> (String)nameValue.getKey() + ":" + ((AnnotationAttributeValue)nameValue.getValue()).toString()).collect(Collectors.joining(", "));
        return "@" + (this.pkgName == null ? "" : this.pkgName + ":") + this.name + "{" + nameValuePairs + "}";
    }

    public String getValue() {
        if (this.attributeNameValPairs.isEmpty()) {
            return null;
        }
        if (this.attributeNameValPairs.size() > 1) {
            throw new IllegalAccessError("annotation contains multiple attributes");
        }
        BValue literalVal = this.attributeNameValPairs.values().toArray(new AnnotationAttributeValue[0])[0].getLiteralValue();
        if (literalVal != null) {
            return literalVal.stringValue();
        }
        return null;
    }

    public static class AnnotationBuilder {
        private NodeLocation location;
        private WhiteSpaceDescriptor whiteSpaceDescriptor;
        private String name;
        private String pkgName;
        private String pkgPath;
        private Map<String, AnnotationAttributeValue> attributeNameValPairs = new HashMap<String, AnnotationAttributeValue>();

        public void setNodeLocation(NodeLocation location) {
            this.location = location;
        }

        public void setWhiteSpaceDescriptor(WhiteSpaceDescriptor whiteSpaceDescriptor) {
            this.whiteSpaceDescriptor = whiteSpaceDescriptor;
        }

        public void setName(String string2) {
            this.name = string2;
        }

        public void setPkgName(String pkgName) {
            this.pkgName = pkgName;
        }

        public void setPkgPath(String pkgPath) {
            this.pkgPath = pkgPath;
        }

        public void addAttributeNameValuePair(String name, AnnotationAttributeValue value2) {
            this.attributeNameValPairs.put(name, value2);
        }

        public AnnotationAttachment build() {
            return new AnnotationAttachment(this.location, this.whiteSpaceDescriptor, this.name, this.pkgName, this.pkgPath, this.attributeNameValPairs);
        }
    }
}

