/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.model.util;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMText;
import org.ballerinalang.bre.bvm.BVM;
import org.ballerinalang.model.TableJSONDataSource;
import org.ballerinalang.model.types.BArrayType;
import org.ballerinalang.model.types.BJSONType;
import org.ballerinalang.model.types.BMapType;
import org.ballerinalang.model.types.BStructureType;
import org.ballerinalang.model.types.BType;
import org.ballerinalang.model.types.BTypes;
import org.ballerinalang.model.types.BUnionType;
import org.ballerinalang.model.util.ListUtils;
import org.ballerinalang.model.util.XMLUtils;
import org.ballerinalang.model.util.XMLValidationUtils;
import org.ballerinalang.model.values.BBoolean;
import org.ballerinalang.model.values.BDecimal;
import org.ballerinalang.model.values.BFloat;
import org.ballerinalang.model.values.BInteger;
import org.ballerinalang.model.values.BMap;
import org.ballerinalang.model.values.BNewArray;
import org.ballerinalang.model.values.BRefType;
import org.ballerinalang.model.values.BStreamingJSON;
import org.ballerinalang.model.values.BString;
import org.ballerinalang.model.values.BTable;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.model.values.BValueArray;
import org.ballerinalang.model.values.BValueType;
import org.ballerinalang.model.values.BXML;
import org.ballerinalang.model.values.BXMLItem;
import org.ballerinalang.model.values.BXMLSequence;
import org.ballerinalang.util.codegen.StructFieldInfo;
import org.ballerinalang.util.codegen.StructureTypeInfo;
import org.ballerinalang.util.exceptions.BLangExceptionHelper;
import org.ballerinalang.util.exceptions.BLangFreezeException;
import org.ballerinalang.util.exceptions.BallerinaErrorReasons;
import org.ballerinalang.util.exceptions.BallerinaException;
import org.ballerinalang.util.exceptions.RuntimeErrors;

public class JSONUtils {
    private static final OMFactory OM_FACTORY = OMAbstractFactory.getOMFactory();
    private static final String XSI_NAMESPACE = "http://www.w3.org/2001/XMLSchema-instance";
    private static final String XSI_PREFIX = "xsi";
    private static final String NIL = "nil";
    public static final String OBJECT = "object";
    public static final String ARRAY = "array";

    public static boolean hasElement(BRefType<?> json, String elementName) {
        if (json.getType().getTag() != 15) {
            return false;
        }
        return ((BMap)json).hasKey(elementName);
    }

    private static BValueArray convertIntArrayToJSON(BValueArray intArray) {
        BValueArray json = new BValueArray(new BArrayType(BTypes.typeJSON));
        int i = 0;
        while ((long)i < intArray.size()) {
            long value2 = intArray.getInt(i);
            json.append(new BInteger(value2));
            ++i;
        }
        return json;
    }

    private static BValueArray convertFloatArrayToJSON(BValueArray floatArray) {
        BValueArray json = new BValueArray(new BArrayType(BTypes.typeJSON));
        int i = 0;
        while ((long)i < floatArray.size()) {
            double value2 = floatArray.getFloat(i);
            json.append(new BFloat(value2));
            ++i;
        }
        return json;
    }

    private static BValueArray convertDecimalArrayToJSON(BValueArray decimalArray) {
        BValueArray json = new BValueArray(new BArrayType(BTypes.typeJSON));
        int i = 0;
        while ((long)i < decimalArray.size()) {
            BDecimal value2 = (BDecimal)decimalArray.getRefValue(i);
            json.append(value2);
            ++i;
        }
        return json;
    }

    private static BValueArray convertStringArrayToJSON(BValueArray stringArray) {
        BValueArray json = new BValueArray(new BArrayType(BTypes.typeJSON));
        int i = 0;
        while ((long)i < stringArray.size()) {
            String value2 = stringArray.getString(i);
            json.append(new BString(value2));
            ++i;
        }
        return json;
    }

    private static BValueArray convertBooleanArrayToJSON(BValueArray booleanArray) {
        BValueArray json = new BValueArray(new BArrayType(BTypes.typeJSON));
        int i = 0;
        while ((long)i < booleanArray.size()) {
            int value2 = booleanArray.getBoolean(i);
            json.append(new BBoolean(value2 == 1));
            ++i;
        }
        return json;
    }

    public static BValueArray convertArrayToJSON(BNewArray bArray) {
        if (bArray instanceof BValueArray) {
            if (((BValueArray)bArray).elementType == BTypes.typeInt) {
                return JSONUtils.convertIntArrayToJSON((BValueArray)bArray);
            }
            if (((BValueArray)bArray).elementType == BTypes.typeBoolean) {
                return JSONUtils.convertBooleanArrayToJSON((BValueArray)bArray);
            }
            if (((BValueArray)bArray).elementType == BTypes.typeFloat) {
                return JSONUtils.convertFloatArrayToJSON((BValueArray)bArray);
            }
            if (((BValueArray)bArray).elementType == BTypes.typeDecimal) {
                return JSONUtils.convertDecimalArrayToJSON((BValueArray)bArray);
            }
            if (((BValueArray)bArray).elementType == BTypes.typeString) {
                return JSONUtils.convertStringArrayToJSON((BValueArray)bArray);
            }
            return JSONUtils.convertRefArrayToJSON((BValueArray)bArray);
        }
        throw BLangExceptionHelper.getRuntimeException(RuntimeErrors.INCOMPATIBLE_TYPE, BTypes.typeJSON, bArray.getType());
    }

    public static BValueArray convertRefArrayToJSON(BValueArray refValueArray) {
        BValueArray json = new BValueArray(new BArrayType(BTypes.typeJSON));
        int i = 0;
        while ((long)i < refValueArray.size()) {
            BRefType<?> value2 = refValueArray.getRefValue(i);
            if (value2 == null) {
                json.append(null);
            }
            switch (value2.getType().getTag()) {
                case 7: {
                    json.append(value2);
                    break;
                }
                case 12: 
                case 15: 
                case 33: {
                    json.append(JSONUtils.convertMapToJSON((BMap)value2, (BJSONType)BTypes.typeJSON));
                    break;
                }
                case 19: {
                    json.append(JSONUtils.convertArrayToJSON((BNewArray)value2));
                    break;
                }
                default: {
                    throw BLangExceptionHelper.getRuntimeException(RuntimeErrors.INCOMPATIBLE_TYPE, BTypes.typeJSON, value2.getType());
                }
            }
            ++i;
        }
        return json;
    }

    public static BRefType<?> convertMapToJSON(BMap<String, BValue> map2, BJSONType targetType) {
        if (map2 == null) {
            return null;
        }
        BMap<String, BValue> json = new BMap<String, BValue>(targetType);
        for (Map.Entry<String, BValue> structField : map2.getMap().entrySet()) {
            String key = structField.getKey();
            BValue value2 = structField.getValue();
            JSONUtils.populateJSON(json, key, value2, BTypes.typeJSON);
        }
        return json;
    }

    private static void populateJSON(BMap<String, BValue> json, String key, BValue value2, BType exptType) {
        try {
            if (value2 == null) {
                json.put(key, null);
                return;
            }
            switch (value2.getType().getTag()) {
                case 1: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    json.put(key, value2);
                    break;
                }
                case 19: {
                    json.put(key, JSONUtils.convertArrayToJSON((BNewArray)value2));
                    break;
                }
                case 12: 
                case 15: 
                case 33: {
                    json.put(key, JSONUtils.convertMapToJSON((BMap)value2, (BJSONType)exptType));
                    break;
                }
                default: {
                    throw BLangExceptionHelper.getRuntimeException(RuntimeErrors.INCOMPATIBLE_TYPE, BTypes.typeJSON, value2.getType());
                }
            }
        }
        catch (Exception e) {
            JSONUtils.handleError(e, key);
        }
    }

    public static BRefType<?> toJSON(BTable table2) {
        TableJSONDataSource jsonDataSource = new TableJSONDataSource(table2);
        if (table2.isInMemoryTable()) {
            return jsonDataSource.build();
        }
        return new BStreamingJSON(jsonDataSource);
    }

    public static BRefType<?> getElement(BValue json, String elementName) {
        if (json == null || !JSONUtils.isJSONObject(json)) {
            return null;
        }
        try {
            return (BRefType)((BMap)json).get(elementName);
        }
        catch (BallerinaException e) {
            if (e.getDetail() != null) {
                throw BLangExceptionHelper.getRuntimeException(RuntimeErrors.JSON_GET_ERROR, e.getDetail());
            }
            throw BLangExceptionHelper.getRuntimeException(RuntimeErrors.JSON_GET_ERROR, e.getMessage());
        }
        catch (Throwable t) {
            throw BLangExceptionHelper.getRuntimeException(RuntimeErrors.JSON_GET_ERROR, t.getMessage());
        }
    }

    public static void setElement(BValue json, String elementName, BValue element) {
        if (json == null || !JSONUtils.isJSONObject(json)) {
            return;
        }
        try {
            ((BMap)json).put(elementName, element);
        }
        catch (BLangFreezeException e) {
            throw e;
        }
        catch (Throwable t) {
            throw BLangExceptionHelper.getRuntimeException(BallerinaErrorReasons.INHERENT_TYPE_VIOLATION_ERROR, RuntimeErrors.JSON_SET_ERROR, t.getMessage());
        }
    }

    public static boolean isJSONArray(BValue json) {
        if (json == null) {
            return false;
        }
        return json.getType().getTag() == 19;
    }

    public static boolean isJSONObject(BValue json) {
        if (json == null) {
            return false;
        }
        return json.getType().getTag() == 7 || json.getType().getTag() == 15;
    }

    public static BRefType<?> getArrayElement(BRefType<?> jsonArray, long index) {
        if (!JSONUtils.isJSONArray(jsonArray)) {
            return null;
        }
        try {
            return ListUtils.execListGetOperation((BNewArray)jsonArray, index);
        }
        catch (BallerinaException e) {
            if (e.getDetail() != null) {
                throw BLangExceptionHelper.getRuntimeException(RuntimeErrors.JSON_GET_ERROR, e.getDetail());
            }
            throw BLangExceptionHelper.getRuntimeException(RuntimeErrors.JSON_GET_ERROR, e.getMessage());
        }
        catch (Throwable t) {
            throw BLangExceptionHelper.getRuntimeException(RuntimeErrors.JSON_GET_ERROR, t.getMessage());
        }
    }

    public static void setArrayElement(BValue json, long index, BRefType element) {
        if (!JSONUtils.isJSONArray(json)) {
            return;
        }
        BArrayType jsonArray = (BArrayType)json.getType();
        BType elementType = jsonArray.getElementType();
        if (!BVM.checkCast(element, elementType)) {
            throw BLangExceptionHelper.getRuntimeException(RuntimeErrors.INCOMPATIBLE_TYPE, elementType, element != null ? element.getType() : BTypes.typeNull);
        }
        try {
            ListUtils.execListAddOperation((BNewArray)json, index, element);
        }
        catch (BLangFreezeException e) {
            throw e;
        }
        catch (BallerinaException e) {
            throw BLangExceptionHelper.getRuntimeException(e.getMessage(), RuntimeErrors.JSON_SET_ERROR, e.getDetail());
        }
        catch (Throwable t) {
            throw BLangExceptionHelper.getRuntimeException(RuntimeErrors.JSON_SET_ERROR, t.getMessage());
        }
    }

    public static BXML convertToXML(BValue json, String attributePrefix, String arrayEntryTag) {
        BXML xml2;
        if (json == null) {
            return new BXMLSequence();
        }
        List<BXML> omElementArrayList = JSONUtils.traverseTree(json, attributePrefix, arrayEntryTag);
        if (omElementArrayList.size() == 1) {
            xml2 = omElementArrayList.get(0);
        } else {
            BValueArray elementsSeq = new BValueArray();
            int count = omElementArrayList.size();
            for (int i = 0; i < count; ++i) {
                elementsSeq.add((long)i, omElementArrayList.get(i));
            }
            xml2 = new BXMLSequence(elementsSeq);
        }
        return xml2;
    }

    private static List<BXML> traverseTree(BValue json, String attributePrefix, String arrayEntryTag) {
        ArrayList<BXML> xmlArray = new ArrayList<BXML>();
        if (json instanceof BValueType) {
            BXML<?> xml2 = XMLUtils.parse(json.stringValue());
            xmlArray.add(xml2);
        } else {
            JSONUtils.traverseJsonNode(json, null, null, xmlArray, attributePrefix, arrayEntryTag);
        }
        return xmlArray;
    }

    private static OMElement traverseJsonNode(BValue json, String nodeName, OMElement parentElement, List<BXML> omElementArrayList, String attributePrefix, String arrayEntryTag) {
        OMElement currentRoot = null;
        if (nodeName != null) {
            if (nodeName.startsWith(attributePrefix)) {
                if (!(json instanceof BValueType)) {
                    throw new BallerinaException("attribute cannot be an object or array");
                }
                if (parentElement != null) {
                    String attributeKey = nodeName.substring(1);
                    XMLValidationUtils.validateXMLName(attributeKey);
                    parentElement.addAttribute(attributeKey, json.stringValue(), null);
                }
                return parentElement;
            }
            XMLValidationUtils.validateXMLName(nodeName);
            currentRoot = OM_FACTORY.createOMElement(nodeName, null);
        }
        if (json == null) {
            OMNamespace xsiNameSpace = OM_FACTORY.createOMNamespace(XSI_NAMESPACE, XSI_PREFIX);
            currentRoot.addAttribute(NIL, "true", xsiNameSpace);
        } else {
            switch (json.getType().getTag()) {
                case 7: {
                    LinkedHashMap map2 = ((BMap)json).getMap();
                    for (Map.Entry entry : map2.entrySet()) {
                        currentRoot = JSONUtils.traverseJsonNode((BValue)entry.getValue(), (String)entry.getKey(), currentRoot, omElementArrayList, attributePrefix, arrayEntryTag);
                        if (nodeName != null) continue;
                        omElementArrayList.add(new BXMLItem((OMNode)currentRoot));
                        currentRoot = null;
                    }
                    break;
                }
                case 19: {
                    BValueArray array2 = (BValueArray)json;
                    int i = 0;
                    while ((long)i < array2.size()) {
                        currentRoot = JSONUtils.traverseJsonNode(array2.getRefValue(i), arrayEntryTag, currentRoot, omElementArrayList, attributePrefix, arrayEntryTag);
                        if (nodeName == null) {
                            omElementArrayList.add(new BXMLItem((OMNode)currentRoot));
                            currentRoot = null;
                        }
                        ++i;
                    }
                    break;
                }
                case 1: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    if (currentRoot == null) {
                        throw new BallerinaException("error in converting json to xml");
                    }
                    OMText txt1 = OM_FACTORY.createOMText((OMContainer)currentRoot, json.stringValue());
                    currentRoot.addChild((OMNode)txt1);
                    break;
                }
                default: {
                    throw new BallerinaException("error in converting json to xml");
                }
            }
        }
        if (parentElement != null) {
            parentElement.addChild((OMNode)currentRoot);
            currentRoot = parentElement;
        }
        return currentRoot;
    }

    private static BInteger jsonNodeToInt(BValue json) {
        if (json == null || json.getType().getTag() != 1) {
            throw BLangExceptionHelper.getRuntimeException(RuntimeErrors.INCOMPATIBLE_TYPE_FOR_CASTING_JSON, BTypes.typeInt, JSONUtils.getTypeName(json));
        }
        return (BInteger)json;
    }

    private static BFloat jsonNodeToFloat(BValue json) {
        if (json == null || json.getType().getTag() != 1 && json.getType().getTag() != 3) {
            throw BLangExceptionHelper.getRuntimeException(RuntimeErrors.INCOMPATIBLE_TYPE_FOR_CASTING_JSON, BTypes.typeFloat, JSONUtils.getTypeName(json));
        }
        if (json.getType().getTag() == 1) {
            return new BFloat(((BInteger)json).intValue());
        }
        return (BFloat)json;
    }

    private static BDecimal jsonNodeToDecimal(BValue json) {
        if (json == null || json.getType().getTag() != 1 && json.getType().getTag() != 3 && json.getType().getTag() != 4) {
            throw BLangExceptionHelper.getRuntimeException(RuntimeErrors.INCOMPATIBLE_TYPE_FOR_CASTING_JSON, BTypes.typeDecimal, JSONUtils.getTypeName(json));
        }
        if (json.getType().getTag() == 1) {
            return new BDecimal(((BInteger)json).decimalValue());
        }
        if (json.getType().getTag() == 3) {
            return new BDecimal(((BFloat)json).decimalValue());
        }
        return (BDecimal)json;
    }

    private static BBoolean jsonNodeToBool(BValue json) {
        if (json == null || json.getType().getTag() != 6) {
            throw BLangExceptionHelper.getRuntimeException(RuntimeErrors.INCOMPATIBLE_TYPE_FOR_CASTING_JSON, BTypes.typeBoolean, JSONUtils.getTypeName(json));
        }
        return (BBoolean)json;
    }

    public static BMap<String, ?> jsonToBMap(BValue json, BMapType mapType) {
        if (json == null || !JSONUtils.isJSONObject(json)) {
            throw BLangExceptionHelper.getRuntimeException(RuntimeErrors.INCOMPATIBLE_TYPE, JSONUtils.getComplexObjectTypeName(OBJECT), JSONUtils.getTypeName(json));
        }
        BMap map2 = new BMap(mapType);
        BType mapConstraint = mapType.getConstrainedType();
        if (mapConstraint == null || mapConstraint.getTag() == 17 || mapConstraint.getTag() == 7) {
            ((BMap)json).getMap().entrySet().forEach(entry -> map2.put(entry.getKey(), (BValue)entry.getValue()));
            return map2;
        }
        ((BMap)json).getMap().entrySet().forEach(entry -> map2.put(entry.getKey(), JSONUtils.convertJSON((BRefType)entry.getValue(), mapConstraint)));
        return map2;
    }

    public static BMap<String, BValue> convertJSONToStruct(BValue json, BStructureType structType) {
        if (json == null || !JSONUtils.isJSONObject(json)) {
            throw BLangExceptionHelper.getRuntimeException(RuntimeErrors.INCOMPATIBLE_TYPE, JSONUtils.getComplexObjectTypeName(OBJECT), JSONUtils.getTypeName(json));
        }
        BMap<String, BValue> bStruct = new BMap<String, BValue>(structType);
        BMap jsonObject = (BMap)json;
        StructureTypeInfo structInfo = (StructureTypeInfo)structType.getTypeInfo();
        for (StructFieldInfo fieldInfo : structInfo.getFieldInfoEntries()) {
            BType fieldType = fieldInfo.getFieldType();
            String fieldName = fieldInfo.getName();
            try {
                if (!jsonObject.hasKey(fieldName)) {
                    bStruct.put(fieldName, (BValue)fieldType.getZeroValue());
                    continue;
                }
                BRefType jsonValue = (BRefType)jsonObject.get(fieldName);
                bStruct.put(fieldName, JSONUtils.convertJSON(jsonValue, fieldType));
            }
            catch (Exception e) {
                JSONUtils.handleError(e, fieldName);
            }
        }
        return bStruct;
    }

    public static BRefType<?> convertJSON(BRefType<?> jsonValue, BType targetType) {
        switch (targetType.getTag()) {
            case 1: {
                return JSONUtils.jsonNodeToInt(jsonValue);
            }
            case 3: {
                return JSONUtils.jsonNodeToFloat(jsonValue);
            }
            case 4: {
                return JSONUtils.jsonNodeToDecimal(jsonValue);
            }
            case 5: {
                return new BString(jsonValue.stringValue());
            }
            case 6: {
                return JSONUtils.jsonNodeToBool(jsonValue);
            }
            case 7: {
                if (jsonValue != null && !BVM.checkCast(jsonValue, targetType)) {
                    throw BLangExceptionHelper.getRuntimeException(RuntimeErrors.INCOMPATIBLE_TYPE, targetType, JSONUtils.getTypeName(jsonValue));
                }
            }
            case 17: {
                return jsonValue;
            }
            case 20: {
                BUnionType type = (BUnionType)targetType;
                if (jsonValue == null && type.isNilable()) {
                    return null;
                }
                List matchingTypes = type.getMemberTypes().stream().filter(memberType -> memberType != BTypes.typeNull).collect(Collectors.toList());
                if (matchingTypes.size() != 1) break;
                return JSONUtils.convertJSON(jsonValue, (BType)matchingTypes.get(0));
            }
            case 12: 
            case 33: {
                return JSONUtils.convertJSONToStruct(jsonValue, (BStructureType)targetType);
            }
            case 19: {
                return JSONUtils.convertJSONToBArray(jsonValue, (BArrayType)targetType);
            }
            case 15: {
                return JSONUtils.jsonToBMap(jsonValue, (BMapType)targetType);
            }
            case 10: {
                if (jsonValue == null) {
                    return null;
                }
            }
            default: {
                throw BLangExceptionHelper.getRuntimeException(RuntimeErrors.INCOMPATIBLE_TYPE, targetType, JSONUtils.getTypeName(jsonValue));
            }
        }
        throw BLangExceptionHelper.getRuntimeException(RuntimeErrors.INCOMPATIBLE_TYPE, targetType, JSONUtils.getTypeName(jsonValue));
    }

    public static BValueArray getKeys(BValue json) {
        if (json == null || !JSONUtils.isJSONObject(json)) {
            return new BValueArray(BTypes.typeString);
        }
        String[] keys = (String[])((BMap)json).keys();
        return new BValueArray(keys);
    }

    public static BRefType<?> convertUnionTypeToJSON(BRefType<?> source, BJSONType targetType) {
        if (source == null) {
            return null;
        }
        switch (source.getType().getTag()) {
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                return source;
            }
            case 10: {
                return null;
            }
            case 12: 
            case 15: 
            case 33: {
                return JSONUtils.convertMapToJSON((BMap)source, targetType);
            }
            case 7: {
                return source;
            }
        }
        throw BLangExceptionHelper.getRuntimeException(RuntimeErrors.INCOMPATIBLE_TYPE, BTypes.typeJSON, source.getType());
    }

    public static void remove(BValue json, String fieldName) {
        if (json == null || json.getType().getTag() != 7) {
            return;
        }
        ((BMap)json).remove(fieldName);
    }

    public static BNewArray convertJSONToBArray(BValue json, BArrayType targetArrayType) {
        if (!(json instanceof BNewArray)) {
            throw BLangExceptionHelper.getRuntimeException(RuntimeErrors.INCOMPATIBLE_TYPE, JSONUtils.getComplexObjectTypeName(ARRAY), JSONUtils.getTypeName(json));
        }
        BType targetElementType = targetArrayType.getElementType();
        BValueArray jsonArray = (BValueArray)json;
        switch (targetElementType.getTag()) {
            case 1: {
                return JSONUtils.jsonArrayToBIntArray(jsonArray);
            }
            case 3: {
                return JSONUtils.jsonArrayToBFloatArray(jsonArray);
            }
            case 5: {
                return JSONUtils.jsonArrayToBStringArray(jsonArray);
            }
            case 6: {
                return JSONUtils.jsonArrayToBBooleanArray(jsonArray);
            }
            case 17: {
                BValueArray array2 = new BValueArray(targetArrayType);
                int i = 0;
                while ((long)i < jsonArray.size()) {
                    array2.add((long)i, jsonArray.getRefValue(i));
                    ++i;
                }
                return array2;
            }
        }
        BValueArray array3 = new BValueArray(targetArrayType);
        int i = 0;
        while ((long)i < jsonArray.size()) {
            array3.append(JSONUtils.convertJSON(jsonArray.getRefValue(i), targetElementType));
            ++i;
        }
        return array3;
    }

    private static BValueArray jsonArrayToBIntArray(BValueArray arrayNode) {
        BValueArray intArray = new BValueArray(BTypes.typeInt);
        int i = 0;
        while ((long)i < arrayNode.size()) {
            BRefType<?> jsonValue = arrayNode.getRefValue(i);
            intArray.add((long)i, ((BInteger)JSONUtils.convertJSON(jsonValue, BTypes.typeInt)).intValue());
            ++i;
        }
        return intArray;
    }

    private static BValueArray jsonArrayToBFloatArray(BValueArray arrayNode) {
        BValueArray floatArray = new BValueArray(BTypes.typeFloat);
        int i = 0;
        while ((long)i < arrayNode.size()) {
            BRefType<?> jsonValue = arrayNode.getRefValue(i);
            floatArray.add((long)i, ((BFloat)JSONUtils.convertJSON(jsonValue, BTypes.typeFloat)).floatValue());
            ++i;
        }
        return floatArray;
    }

    private static BValueArray jsonArrayToBStringArray(BValueArray arrayNode) {
        BValueArray stringArray = new BValueArray(BTypes.typeString);
        int i = 0;
        while ((long)i < arrayNode.size()) {
            BRefType<?> jsonValue = arrayNode.getRefValue(i);
            String value2 = jsonValue.stringValue();
            stringArray.add((long)i, value2);
            ++i;
        }
        return stringArray;
    }

    private static BValueArray jsonArrayToBBooleanArray(BValueArray arrayNode) {
        BValueArray booleanArray = new BValueArray(BTypes.typeBoolean);
        int i = 0;
        while ((long)i < arrayNode.size()) {
            BRefType<?> jsonValue = arrayNode.getRefValue(i);
            booleanArray.add((long)i, ((BBoolean)JSONUtils.convertJSON(jsonValue, BTypes.typeBoolean)).booleanValue() ? 1 : 0);
            ++i;
        }
        return booleanArray;
    }

    public static String getTypeName(BValue jsonValue) {
        if (jsonValue == null) {
            return BTypes.typeNull.toString();
        }
        return jsonValue.getType().toString();
    }

    private static String getComplexObjectTypeName(String nodeType) {
        return "json-" + nodeType;
    }

    private static void handleError(Exception e, String fieldName) {
        String errorMsg = e.getCause() == null ? "error while mapping '" + fieldName + "': " : "";
        throw new BallerinaException(errorMsg + e.getMessage(), e);
    }
}

