/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.model.util.serializer;

import java.util.Set;
import org.ballerinalang.model.values.BInteger;
import org.ballerinalang.model.values.BMap;
import org.ballerinalang.model.values.BString;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.model.values.BValueArray;

class BTreeHelper {
    private BTreeHelper() {
    }

    static BMap<String, BValue> wrapWithTypeMetadata(String type, BValue payload) {
        BMap<String, BValue> map2 = new BMap<String, BValue>();
        map2.put("type#", BTreeHelper.createBString(type));
        map2.put("value#", payload);
        return map2;
    }

    static BString createBString(String s) {
        if (s == null) {
            return null;
        }
        return new BString(s);
    }

    static void trimTree(BValue jsonObj, Set<Long> repeatedReferenceSet) {
        if (jsonObj == null) {
            return;
        }
        if (jsonObj instanceof BMap) {
            BMap map2 = (BMap)jsonObj;
            BInteger objId = (BInteger)map2.get("#id#");
            if (objId != null && !repeatedReferenceSet.contains(objId.intValue())) {
                map2.remove("#id#");
            }
            BTreeHelper.trimTree(map2.get("value#"), repeatedReferenceSet);
        }
        if (jsonObj instanceof BValueArray) {
            BValueArray array2 = (BValueArray)jsonObj;
            int i = 0;
            while ((long)i < array2.size()) {
                BTreeHelper.trimTree(array2.getRefValue(i), repeatedReferenceSet);
                ++i;
            }
        }
    }
}

