/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.model.util.serializer;

import org.ballerinalang.model.types.BArrayType;
import org.ballerinalang.model.types.BTypes;
import org.ballerinalang.model.util.serializer.BValueSerializer;
import org.ballerinalang.model.values.BRefType;
import org.ballerinalang.model.values.BValueArray;

class BValueArrays {
    private static final BArrayType B_INT_ARRAY_TYPE = new BArrayType(BTypes.typeInt);
    private static final BArrayType B_FLOAT_ARRAY_TYPE = new BArrayType(BTypes.typeFloat);
    private final BValueSerializer serializer;

    BValueArrays(BValueSerializer serializer) {
        this.serializer = serializer;
    }

    BValueArray from(int[] array2) {
        BRefType[] backing = new BRefType[array2.length];
        for (int i = 0; i < array2.length; ++i) {
            backing[i] = (BRefType)this.serializer.toBValue(array2[i], null);
        }
        return new BValueArray(backing, B_INT_ARRAY_TYPE);
    }

    BValueArray from(long[] array2) {
        BRefType[] backing = new BRefType[array2.length];
        for (int i = 0; i < array2.length; ++i) {
            backing[i] = (BRefType)this.serializer.toBValue(array2[i], null);
        }
        return new BValueArray(backing, B_INT_ARRAY_TYPE);
    }

    BValueArray from(double[] array2) {
        BRefType[] backing = new BRefType[array2.length];
        for (int i = 0; i < array2.length; ++i) {
            backing[i] = (BRefType)this.serializer.toBValue(array2[i], null);
        }
        return new BValueArray(backing, B_FLOAT_ARRAY_TYPE);
    }

    private <T> BRefType[] getBRefArray(T[] array2) {
        BRefType[] backing = new BRefType[array2.length];
        for (int i = 0; i < array2.length; ++i) {
            backing[i] = (BRefType)this.serializer.toBValue(array2[i], null);
        }
        return backing;
    }

    BValueArray from(Object[] array2) {
        BRefType[] backing = this.getBRefArray(array2);
        return new BValueArray(backing, new BArrayType(BTypes.typeAny));
    }

    public BRefType from(char[] array2) {
        BRefType[] backing = new BRefType[array2.length];
        for (int i = 0; i < array2.length; ++i) {
            backing[i] = (BRefType)this.serializer.toBValue(Character.valueOf(array2[i]), null);
        }
        return new BValueArray(backing, B_INT_ARRAY_TYPE);
    }

    public BRefType from(byte[] array2) {
        BRefType[] backing = new BRefType[array2.length];
        for (int i = 0; i < array2.length; ++i) {
            backing[i] = (BRefType)this.serializer.toBValue(array2[i], null);
        }
        return new BValueArray(backing, B_INT_ARRAY_TYPE);
    }

    public BRefType from(short[] array2) {
        BRefType[] backing = new BRefType[array2.length];
        for (int i = 0; i < array2.length; ++i) {
            backing[i] = (BRefType)this.serializer.toBValue(array2[i], null);
        }
        return new BValueArray(backing, B_INT_ARRAY_TYPE);
    }

    public BRefType from(float[] array2) {
        BRefType[] backing = new BRefType[array2.length];
        for (int i = 0; i < array2.length; ++i) {
            backing[i] = (BRefType)this.serializer.toBValue(Float.valueOf(array2[i]), null);
        }
        return new BValueArray(backing, B_FLOAT_ARRAY_TYPE);
    }
}

