/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.model.util.serializer;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.ballerinalang.model.util.serializer.BPacket;
import org.ballerinalang.model.util.serializer.BValueDeserializer;
import org.ballerinalang.model.util.serializer.BValueProvider;
import org.ballerinalang.model.util.serializer.InstanceProviderRegistry;
import org.ballerinalang.model.util.serializer.ObjectHelper;
import org.ballerinalang.model.util.serializer.SerializationBValueProvider;
import org.ballerinalang.model.util.serializer.TypeInstanceProvider;
import org.ballerinalang.model.util.serializer.providers.instance.ListInstanceProvider;
import org.ballerinalang.model.util.serializer.providers.instance.MapInstanceProvider;
import org.ballerinalang.model.values.BBoolean;
import org.ballerinalang.model.values.BFloat;
import org.ballerinalang.model.values.BInteger;
import org.ballerinalang.model.values.BMap;
import org.ballerinalang.model.values.BRefType;
import org.ballerinalang.model.values.BString;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.model.values.BValueArray;
import org.ballerinalang.util.exceptions.BallerinaException;

class JsonDeserializer
implements BValueDeserializer {
    private final BValueProvider bValueProvider;
    private final HashMap<Long, Object> identityMap;
    private final BRefType<?> treeHead;
    private static final InstanceProviderRegistry instanceProvider = InstanceProviderRegistry.getInstance();

    JsonDeserializer(BRefType<?> objTree) {
        this.treeHead = objTree;
        this.bValueProvider = BValueProvider.getInstance();
        this.identityMap = new HashMap();
    }

    Object deserialize(Class<?> destinationType) {
        if (ObjectHelper.isInstantiable(destinationType)) {
            return this.deserialize(this.treeHead, destinationType);
        }
        throw new BallerinaException(String.format("%s is not instantiable", destinationType.getName()));
    }

    @Override
    public Object deserialize(BValue jValue, Class<?> targetType) {
        if (jValue == null) {
            return null;
        }
        switch (jValue.getType().getTag()) {
            case 7: 
            case 15: {
                BMap jBMap = (BMap)jValue;
                Object obj = this.deserializeComplexType(jBMap, targetType);
                this.addObjReference(jBMap, obj);
                return obj;
            }
            case 19: {
                return this.deserializeBRefValueArray((BValueArray)jValue, targetType);
            }
            case 5: {
                return jValue.stringValue();
            }
            case 1: {
                return this.castLong(((BInteger)jValue).intValue(), targetType);
            }
            case 3: {
                return this.castFloat((BFloat)jValue, targetType);
            }
            case 6: {
                return ((BBoolean)jValue).booleanValue();
            }
        }
        throw new BallerinaException(String.format("Unknown BValue type to deserialize: %s", jValue.getClass().getSimpleName()));
    }

    private Object castFloat(BFloat jValue, Class<?> targetType) {
        if (targetType == Float.class || targetType == Float.TYPE) {
            return Float.valueOf((float)jValue.floatValue());
        }
        return jValue.floatValue();
    }

    private Object castLong(long jValue, Class<?> targetType) {
        if (targetType == Short.class || targetType == Short.TYPE) {
            return (short)jValue;
        }
        if (targetType == Integer.class || targetType == Integer.TYPE) {
            return (int)jValue;
        }
        if (targetType == Byte.class || targetType == Byte.TYPE) {
            return (byte)jValue;
        }
        if (targetType == Character.class || targetType == Character.TYPE) {
            return Character.valueOf((char)jValue);
        }
        return jValue;
    }

    private Object deserializeBRefValueArray(BValueArray valueArray, Class<?> targetType) {
        int size = (int)valueArray.size();
        Class<?> componentType = targetType.getComponentType();
        Object target = Array.newInstance(componentType, size);
        return this.deserializeBRefValueArray(valueArray, target);
    }

    private Object deserializeBRefValueArray(BValueArray valueArray, Object destinationArray) {
        Class<?> componentType = destinationArray.getClass().getComponentType();
        int i = 0;
        while ((long)i < valueArray.size()) {
            Object obj = this.deserialize(valueArray.getRefValue(i), componentType);
            Array.set(destinationArray, i, obj);
            ++i;
        }
        return destinationArray;
    }

    private Object deserializeComplexType(BMap<String, BValue> jBMap, Class<?> targetType) {
        Object resolved;
        SerializationBValueProvider provider;
        Object existing = this.findExistingReference(jBMap);
        if (existing != null) {
            return existing;
        }
        if (this.isNullObj(jBMap)) {
            return null;
        }
        Object object = null;
        String typeName = this.resolveTargetTypeName(targetType, jBMap);
        if (typeName != null && (provider = this.bValueProvider.find(typeName)) != null) {
            object = provider.toObject(BPacket.toPacket(jBMap), this);
            this.addObjReference(jBMap, object);
        }
        if (object == null) {
            Object emptyInstance = this.createInstance(jBMap, targetType);
            this.addObjReference(jBMap, emptyInstance);
            object = this.deserializeInto(emptyInstance, jBMap, targetType);
            if (object != emptyInstance) {
                throw new BallerinaException("Internal error: deserializeInto should not create own objects.");
            }
        }
        if ((resolved = this.readResolve(jBMap, targetType, object)) != null) {
            return resolved;
        }
        return object;
    }

    private boolean isNullObj(BMap<String, BValue> jBMap) {
        return jBMap.hasKey("#null#");
    }

    private Object deserializeInto(Object instance, BMap<String, BValue> data, Class<?> targetType) {
        BMap<String, BValue> valueNode = data.get("value#");
        if (data.hasKey("type#")) {
            BValue type = data.get("type#");
            switch (type.stringValue()) {
                case "map#": {
                    return this.deserializeMap(valueNode, (Map)instance);
                }
                case "list#": {
                    return this.deserializeList((BValueArray)((Object)valueNode), targetType, (List)instance);
                }
                case "enum#": {
                    return instance;
                }
                case "array#": {
                    return this.deserializeBRefValueArray((BValueArray)((Object)valueNode), instance);
                }
            }
        }
        if (valueNode == null) {
            valueNode = data;
        }
        return this.deserializeReflectively(instance, valueNode);
    }

    private String resolveTargetTypeName(Class<?> targetType, BMap<String, BValue> jBMap) {
        if (jBMap.hasKey("type#")) {
            BValue jType = jBMap.get("type#");
            return jType.stringValue();
        }
        if (targetType != null) {
            return ObjectHelper.getTrimmedClassName(targetType);
        }
        throw new IllegalStateException("Target type should either come from jBMap or via targetType param");
    }

    @Override
    public void addObjReference(BMap<String, BValue> jBMap, Object object) {
        BInteger objId = (BInteger)jBMap.get("#id#");
        if (objId != null) {
            this.identityMap.put(objId.intValue(), object);
        }
    }

    private Object findExistingReference(BMap<String, BValue> jBMap) {
        if (!jBMap.hasKey("#existing#")) {
            return null;
        }
        BInteger existingObjId = (BInteger)jBMap.get("#existing#");
        Object existingObjRef = this.getExistingObjRef(existingObjId.intValue());
        if (existingObjRef == null) {
            throw new BallerinaException("Can not find existing reference: " + existingObjId);
        }
        return existingObjRef;
    }

    @Override
    public Object getExistingObjRef(long key) {
        return this.identityMap.get(key);
    }

    private Object createInstance(BMap<String, BValue> jsonNode, Class<?> target) {
        if (target != null && Enum.class.isAssignableFrom(target)) {
            return this.createEnumInstance(jsonNode);
        }
        if (jsonNode.hasKey("type#")) {
            BValue typeNode = jsonNode.get("type#");
            String type = typeNode.stringValue();
            if (type.equals("array#")) {
                return this.createArrayInstance(jsonNode);
            }
            return this.getObjectOf(type);
        }
        return this.getObjectOf(target);
    }

    private Object createArrayInstance(BMap<String, BValue> jsonNode) {
        BString ct = (BString)jsonNode.get("componentType#");
        String componentType = ct.stringValue();
        BInteger bSize = (BInteger)jsonNode.get("len#");
        int size = (int)bSize.intValue();
        Class<?> clazz = this.findClass(componentType);
        if (clazz != null) {
            return Array.newInstance(clazz, size);
        }
        throw new BallerinaException("Can not create array instance of: " + componentType + "[]");
    }

    private Object createEnumInstance(BMap jsonNode) {
        String enumName = jsonNode.get("value#").stringValue();
        int separatorPos = enumName.lastIndexOf(".");
        String type = enumName.substring(0, separatorPos);
        String enumConst = enumName.substring(separatorPos + 1);
        Class enumClass = instanceProvider.findInstanceProvider(type).getTypeClass();
        return Enum.valueOf(enumClass, enumConst);
    }

    private Object getObjectOf(Class<?> clazz) {
        String className = ObjectHelper.getTrimmedClassName(clazz);
        return this.getObjectOf(className);
    }

    private Object getObjectOf(String type) {
        TypeInstanceProvider typeProvider = instanceProvider.findInstanceProvider(type);
        return typeProvider.newInstance();
    }

    private Object deserializeReflectively(Object instance, BMap<String, BValue> payload) {
        this.setFields(instance, payload);
        return instance;
    }

    private void setFields(Object target, BMap<String, BValue> fieldMap) {
        Objects.requireNonNull(target);
        Class<?> targetClass = target.getClass();
        HashMap<String, Field> allFields = ObjectHelper.getAllFields(targetClass, 0);
        for (String fieldName : fieldMap.keys()) {
            if (fieldName.equals("#id#")) continue;
            if (!allFields.containsKey(fieldName)) {
                throw new BallerinaException(String.format("Can not find field '%s' from JSON in %s class", fieldName, targetClass.getName()));
            }
            Field field = allFields.get(fieldName);
            BValue value2 = fieldMap.get(fieldName);
            Object object = this.deserialize(value2, field.getType());
            ObjectHelper.setField(target, field, object);
        }
    }

    private Object deserializeList(BValueArray jArray, Class<?> targetType, List targetList) {
        Class<?> componentType = targetType.getComponentType();
        for (BRefType<?> value2 : jArray.getValues()) {
            Object item = this.deserialize(value2, componentType);
            targetList.add(item);
        }
        return targetList;
    }

    private Object deserializeMap(BMap<String, BValue> payload, Map target) {
        BValue complexKeyMap = payload.get("#complex_key_map#");
        if (complexKeyMap instanceof BMap) {
            return this.deserializeComplexKeyMap((BMap)complexKeyMap, payload, target);
        }
        for (String key : payload.keys()) {
            if (key.equals("#complex_key_map#")) continue;
            BValue value2 = payload.get(key);
            Class fieldType = Object.class;
            if (value2 instanceof BMap) {
                BMap item = (BMap)value2;
                if (item.hasKey("type#")) {
                    Object val = item.get("type#");
                    String typeName = val.stringValue();
                    fieldType = this.findClass(typeName);
                }
            } else if (value2 instanceof BBoolean) {
                fieldType = BBoolean.class;
            }
            target.put(key, this.deserialize(value2, fieldType));
        }
        return target;
    }

    private Object deserializeComplexKeyMap(BMap<String, BValue> complexKeyMap, BMap<String, BValue> payload, Map targetMap) {
        for (String key : payload.keys()) {
            if (key.equals("#complex_key_map#")) continue;
            BValue value2 = payload.get(key);
            BValue complexKey = complexKeyMap.get(key);
            Object ckObj = this.deserialize(complexKey, Object.class);
            targetMap.put(ckObj, this.deserialize(value2, Object.class));
        }
        return targetMap;
    }

    private Class<?> findClass(String typeName) {
        Class<?> primitiveClass = ObjectHelper.findPrimitiveClass(typeName);
        if (primitiveClass != null) {
            return primitiveClass;
        }
        SerializationBValueProvider provider = this.bValueProvider.find(typeName);
        if (provider != null) {
            return provider.getType();
        }
        TypeInstanceProvider typeProvider = instanceProvider.findInstanceProvider(typeName);
        return typeProvider.getTypeClass();
    }

    private Object readResolve(BMap<String, BValue> jBMap, Class<?> targetType, Object object) {
        Class<?> clz;
        if (targetType != null) {
            clz = targetType;
        } else {
            String targetTypeName = this.resolveTargetTypeName(null, jBMap);
            clz = this.findClass(targetTypeName);
        }
        if (clz != null && Serializable.class.isAssignableFrom(clz)) {
            return ObjectHelper.invokeReadResolveOn(object, clz);
        }
        return null;
    }

    static {
        instanceProvider.add(new MapInstanceProvider());
        instanceProvider.add(new ListInstanceProvider());
    }
}

