/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.model.util.serializer.providers.bvalue;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.ballerinalang.model.types.BAnyType;
import org.ballerinalang.model.types.BAnydataType;
import org.ballerinalang.model.types.BArrayType;
import org.ballerinalang.model.types.BAttachedFunction;
import org.ballerinalang.model.types.BMapType;
import org.ballerinalang.model.types.BObjectType;
import org.ballerinalang.model.types.BRecordType;
import org.ballerinalang.model.types.BType;
import org.ballerinalang.model.util.serializer.BPacket;
import org.ballerinalang.model.util.serializer.BValueDeserializer;
import org.ballerinalang.model.util.serializer.BValueSerializer;
import org.ballerinalang.model.util.serializer.SerializationBValueProvider;
import org.ballerinalang.model.values.BBoolean;
import org.ballerinalang.model.values.BInteger;
import org.ballerinalang.model.values.BString;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.util.codegen.ObjectTypeInfo;
import org.ballerinalang.util.codegen.RecordTypeInfo;

public class BTypeBValueProviders {
    private static final String ELEM_TYPE = "elemType";
    private static final String PACKAGE_PATH = "packagePath";
    private static final String TYPE_NAME = "typeName";

    private BTypeBValueProviders() {
    }

    public static class BRecordTypeBValueProvider
    implements SerializationBValueProvider<BRecordType> {
        static final String REST_FIELD_SIGNATURE_CP_INDEX = "restFieldSignatureCPIndex";
        static final String REST_FIELD_TYPE_SIGNATURE = "restFieldTypeSignature";
        private static final String PACKAGE_PATH = "packagePath";
        private static final String TYPE_NAME = "typeName";
        private static final String FLAGS = "flags";
        private static final String REST_FIELD_TYPE = "restFieldType";
        private static final String CLOSED = "closed";

        @Override
        public Class<?> getType() {
            return BRecordType.class;
        }

        @Override
        public String typeName() {
            return this.getType().getName();
        }

        @Override
        public BPacket toBValue(BRecordType recType, BValueSerializer serializer) {
            String packagePath = recType.getPackagePath();
            String typeName = recType.getName();
            int flags = recType.flags;
            int restFieldSignatureCPIndex = recType.recordTypeInfo.getRestFieldSignatureCPIndex();
            String restFieldTypeSignature = recType.recordTypeInfo.getRestFieldTypeSignature();
            BPacket packet = BPacket.from(this.typeName(), serializer.toBValue(recType.getFields(), null));
            packet.putString("packagePath", packagePath);
            packet.putString("typeName", typeName);
            packet.put(FLAGS, new BInteger(flags));
            packet.put(REST_FIELD_SIGNATURE_CP_INDEX, new BInteger(restFieldSignatureCPIndex));
            packet.putString(REST_FIELD_TYPE_SIGNATURE, restFieldTypeSignature);
            packet.put(CLOSED, new BBoolean(recType.sealed));
            packet.put(REST_FIELD_TYPE, serializer.toBValue(recType.restFieldType, null));
            return packet;
        }

        @Override
        public BRecordType toObject(BPacket packet, BValueDeserializer bValueDeserializer) {
            String typeName = packet.get("typeName").stringValue();
            String pkgPath = packet.get("packagePath").stringValue();
            int flags = (int)((BInteger)packet.get(FLAGS)).intValue();
            int cpIndex = (int)((BInteger)packet.get(REST_FIELD_SIGNATURE_CP_INDEX)).intValue();
            BBoolean closed = (BBoolean)packet.get(CLOSED);
            RecordTypeInfo recTypeInfo = new RecordTypeInfo();
            recTypeInfo.setRestFieldSignatureCPIndex(cpIndex);
            BValue restFieldTypeSig = packet.get(REST_FIELD_TYPE_SIGNATURE);
            if (restFieldTypeSig != null) {
                String typeSig = restFieldTypeSig.stringValue();
                recTypeInfo.setRestFieldTypeSignature(typeSig);
            }
            BRecordType bRecType = new BRecordType(recTypeInfo, typeName, pkgPath, flags);
            Map fields = (Map)bValueDeserializer.deserialize(packet.getValue(), LinkedHashMap.class);
            bRecType.setFields(fields);
            recTypeInfo.setType(bRecType);
            bRecType.restFieldType = (BType)bValueDeserializer.deserialize(packet.get(REST_FIELD_TYPE), BType.class);
            bRecType.sealed = closed.booleanValue();
            return bRecType;
        }
    }

    public static class BObjectTypeBValueProvider
    implements SerializationBValueProvider<BObjectType> {
        private static final String PACKAGE_PATH = "packagePath";
        private static final String TYPE_NAME = "typeName";
        private static final String FLAGS = "flags";
        private static final String FIELDS = "fields";
        private static final String ATTACHED_FUNCTIONS = "attachedFunctions";
        private static final String INITIALIZER = "initializer";
        private static final String DEFAULT_INIT = "defaultsValuesInitFunc";

        @Override
        public Class<?> getType() {
            return BObjectType.class;
        }

        @Override
        public String typeName() {
            return this.getType().getName();
        }

        @Override
        public BPacket toBValue(BObjectType objType, BValueSerializer serializer) {
            String packagePath = objType.getPackagePath();
            String typeName = objType.getName();
            int flags = objType.flags;
            BValue fields = serializer.toBValue(objType.getFields(), null);
            BValue attachedFunctions = serializer.toBValue(objType.getAttachedFunctions(), null);
            BValue initializer = serializer.toBValue(objType.initializer, null);
            BValue defaultsValuesInitFunc = serializer.toBValue(objType.defaultsValuesInitFunc, null);
            BPacket packet = BPacket.from(this.typeName(), null);
            packet.put("packagePath", new BString(packagePath));
            packet.put("typeName", new BString(typeName));
            packet.put(FLAGS, new BInteger(flags));
            packet.put(FIELDS, fields);
            packet.put(ATTACHED_FUNCTIONS, attachedFunctions);
            packet.put(INITIALIZER, initializer);
            packet.put(DEFAULT_INIT, defaultsValuesInitFunc);
            return packet;
        }

        @Override
        public BObjectType toObject(BPacket packet, BValueDeserializer bValueDeserializer) {
            String typeName = packet.get("typeName").stringValue();
            String pkgPath = packet.get("packagePath").stringValue();
            int flags = (int)((BInteger)packet.get(FLAGS)).intValue();
            ObjectTypeInfo objectTypeInfo = new ObjectTypeInfo();
            BObjectType bObjectType = new BObjectType(objectTypeInfo, typeName, pkgPath, flags);
            objectTypeInfo.setType(bObjectType);
            bValueDeserializer.addObjReference(packet.toBMap(), bObjectType);
            LinkedHashMap fields = (LinkedHashMap)bValueDeserializer.deserialize(packet.get(FIELDS), LinkedHashMap.class);
            BAttachedFunction[] attachedFunctions = (BAttachedFunction[])bValueDeserializer.deserialize(packet.get(ATTACHED_FUNCTIONS), BAttachedFunction[].class);
            BAttachedFunction initializer = (BAttachedFunction)bValueDeserializer.deserialize(packet.get(INITIALIZER), BAttachedFunction.class);
            BAttachedFunction defaultsValuesInitFunc = (BAttachedFunction)bValueDeserializer.deserialize(packet.get(DEFAULT_INIT), BAttachedFunction.class);
            bObjectType.setFields(fields);
            bObjectType.setAttachedFunctions(attachedFunctions);
            bObjectType.initializer = initializer;
            bObjectType.defaultsValuesInitFunc = defaultsValuesInitFunc;
            return bObjectType;
        }
    }

    public static class BMapTypeBValueProvider
    implements SerializationBValueProvider<BMapType> {
        @Override
        public Class<?> getType() {
            return BMapType.class;
        }

        @Override
        public String typeName() {
            return this.getType().getName();
        }

        @Override
        public BPacket toBValue(BMapType type, BValueSerializer serializer) {
            BType elementType = type.getConstrainedType();
            BPacket packet = BPacket.from(this.typeName(), null);
            packet.put(BTypeBValueProviders.ELEM_TYPE, serializer.toBValue(elementType, null));
            return packet;
        }

        @Override
        public BMapType toObject(BPacket packet, BValueDeserializer bValueDeserializer) {
            BType elemType = (BType)bValueDeserializer.deserialize(packet.get(BTypeBValueProviders.ELEM_TYPE), BType.class);
            BMapType bMapType = new BMapType(elemType);
            bValueDeserializer.addObjReference(packet.toBMap(), bMapType);
            return bMapType;
        }
    }

    public static class BArrayTypeBValueProvider
    implements SerializationBValueProvider<BArrayType> {
        static final String DIMENSIONS = "dimensions";
        static final String SIZE = "size";

        @Override
        public Class<?> getType() {
            return BArrayType.class;
        }

        @Override
        public String typeName() {
            return this.getType().getName();
        }

        @Override
        public BPacket toBValue(BArrayType type, BValueSerializer serializer) {
            BType elementType = type.getElementType();
            int dimensions = type.getDimensions();
            int size = type.getSize();
            BPacket packet = BPacket.from(this.typeName(), null);
            packet.put(BTypeBValueProviders.ELEM_TYPE, serializer.toBValue(elementType, null));
            packet.put(DIMENSIONS, new BInteger(dimensions));
            packet.put(SIZE, new BInteger(size));
            return packet;
        }

        @Override
        public BArrayType toObject(BPacket packet, BValueDeserializer bValueDeserializer) {
            BType elemType = (BType)bValueDeserializer.deserialize(packet.get(BTypeBValueProviders.ELEM_TYPE), BType.class);
            int size = (int)((BInteger)packet.get(SIZE)).intValue();
            return new BArrayType(elemType, size);
        }
    }

    public static class BAnydataTypeBValueProvider
    implements SerializationBValueProvider<BAnydataType> {
        @Override
        public Class<?> getType() {
            return BAnydataType.class;
        }

        @Override
        public String typeName() {
            return this.getType().getName();
        }

        @Override
        public BPacket toBValue(BAnydataType type, BValueSerializer serializer) {
            String packagePath = type.getPackagePath();
            String typeName = type.getName();
            BPacket packet = BPacket.from(this.typeName(), null);
            if (packagePath != null) {
                packet.put(BTypeBValueProviders.PACKAGE_PATH, new BString(packagePath));
            }
            packet.put(BTypeBValueProviders.TYPE_NAME, new BString(typeName));
            return packet;
        }

        @Override
        public BAnydataType toObject(BPacket packet, BValueDeserializer bValueDeserializer) {
            String typeName = packet.get(BTypeBValueProviders.TYPE_NAME).stringValue();
            String pkgPath = null;
            BValue pkgP = packet.get(BTypeBValueProviders.PACKAGE_PATH);
            if (pkgP != null) {
                pkgPath = pkgP.stringValue();
            }
            try {
                Constructor constructor = BAnydataType.class.getDeclaredConstructor(String.class, String.class);
                constructor.setAccessible(true);
                return (BAnydataType)constructor.newInstance(typeName, pkgPath);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                return null;
            }
        }
    }

    public static class BAnyTypeBValueProvider
    implements SerializationBValueProvider<BAnyType> {
        @Override
        public Class<?> getType() {
            return BAnyType.class;
        }

        @Override
        public String typeName() {
            return this.getType().getName();
        }

        @Override
        public BPacket toBValue(BAnyType type, BValueSerializer serializer) {
            String packagePath = type.getPackagePath();
            String typeName = type.getName();
            BPacket packet = BPacket.from(this.typeName(), null);
            if (packagePath != null) {
                packet.put(BTypeBValueProviders.PACKAGE_PATH, new BString(packagePath));
            }
            packet.put(BTypeBValueProviders.TYPE_NAME, new BString(typeName));
            return packet;
        }

        @Override
        public BAnyType toObject(BPacket packet, BValueDeserializer bValueDeserializer) {
            String typeName = packet.get(BTypeBValueProviders.TYPE_NAME).stringValue();
            String pkgPath = null;
            BValue pkgP = packet.get(BTypeBValueProviders.PACKAGE_PATH);
            if (pkgP != null) {
                pkgPath = pkgP.stringValue();
            }
            try {
                Constructor constructor = BAnyType.class.getDeclaredConstructor(String.class, String.class);
                constructor.setAccessible(true);
                return (BAnyType)constructor.newInstance(typeName, pkgPath);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                return null;
            }
        }
    }
}

