/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.model.util.serializer.providers.bvalue;

import java.util.HashSet;
import org.ballerinalang.model.types.BArrayType;
import org.ballerinalang.model.types.BTypes;
import org.ballerinalang.model.util.serializer.BPacket;
import org.ballerinalang.model.util.serializer.BValueDeserializer;
import org.ballerinalang.model.util.serializer.BValueSerializer;
import org.ballerinalang.model.util.serializer.SerializationBValueProvider;
import org.ballerinalang.model.values.BInteger;
import org.ballerinalang.model.values.BRefType;
import org.ballerinalang.model.values.BValueArray;

public class HashSetBValueProvider
implements SerializationBValueProvider<HashSet> {
    @Override
    public String typeName() {
        return this.getType().getName();
    }

    @Override
    public Class<?> getType() {
        return HashSet.class;
    }

    @Override
    public BPacket toBValue(HashSet set, BValueSerializer serializer) {
        BValueArray array2 = new BValueArray(new BArrayType(BTypes.typeAny));
        for (Object item : set) {
            array2.append((BRefType)serializer.toBValue(item, null));
        }
        return BPacket.from(this.typeName(), array2).put("len#", new BInteger(set.size()));
    }

    @Override
    public HashSet toObject(BPacket packet, BValueDeserializer bValueDeserializer) {
        BInteger length = (BInteger)packet.get("len#");
        BValueArray array2 = (BValueArray)packet.getValue();
        HashSet<Object> set = new HashSet<Object>((int)length.intValue());
        int i = 0;
        while ((long)i < array2.size()) {
            set.add(bValueDeserializer.deserialize(array2.getRefValue(i), null));
            ++i;
        }
        return set;
    }
}

