/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.model.values;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ballerinalang.bre.bvm.BVM;
import org.ballerinalang.model.types.BType;
import org.ballerinalang.model.values.BClosure;
import org.ballerinalang.model.values.BRefType;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.util.codegen.FunctionInfo;

public class BFunctionPointer
implements BRefType<FunctionInfo> {
    FunctionInfo functionInfo;
    BType type;
    private List<BClosure> closureVars = new ArrayList<BClosure>();
    private Map<Integer, Integer> additionalIndexes = new HashMap<Integer, Integer>();

    public BFunctionPointer(FunctionInfo functionInfo) {
        this.functionInfo = functionInfo;
    }

    public BFunctionPointer(FunctionInfo functionInfo, BType type) {
        this.functionInfo = functionInfo;
        this.type = type;
    }

    @Override
    public FunctionInfo value() {
        return this.functionInfo;
    }

    public List<BClosure> getClosureVars() {
        return this.closureVars;
    }

    public void addClosureVar(BClosure closure, int tag) {
        this.closureVars.add(closure);
        this.additionalIndexes.merge(tag, 1, Integer::sum);
    }

    public Integer getAdditionalIndexCount(int type) {
        return this.additionalIndexes.getOrDefault(type, 0);
    }

    @Override
    public String stringValue() {
        return "";
    }

    @Override
    public BType getType() {
        return this.type;
    }

    @Override
    public void stamp(BType type, List<BVM.TypeValuePair> unresolvedValues) {
    }

    @Override
    public BValue copy(Map<BValue, BValue> refs) {
        return new BFunctionPointer(this.functionInfo);
    }
}

