/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.natives;

import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import org.ballerinalang.model.NativeCallableUnit;
import org.ballerinalang.natives.NativeElementRepository;
import org.ballerinalang.spi.NativeElementProvider;

public class NativeUnitLoader {
    private NativeElementRepository nativeElementRepo;
    private static NativeUnitLoader instance;
    private Map<String, NativeCallableUnit> nativeUnitsCache = new HashMap<String, NativeCallableUnit>();

    public static NativeUnitLoader getInstance() {
        if (instance == null) {
            instance = new NativeUnitLoader();
        }
        return instance;
    }

    public NativeUnitLoader() {
        this.nativeElementRepo = new NativeElementRepository();
        ServiceLoader.load(NativeElementProvider.class).forEach(e -> e.populateNatives(this.nativeElementRepo));
    }

    public NativeElementRepository getNativeElementRepository() {
        return this.nativeElementRepo;
    }

    public NativeCallableUnit loadNativeFunction(String pkgName, String functionName) {
        NativeElementRepository.NativeFunctionDef functionDef;
        String key = NativeElementRepository.functionToKey((String)pkgName, (String)functionName);
        NativeCallableUnit result = this.nativeUnitsCache.get(key);
        if (result == null && (functionDef = this.nativeElementRepo.lookupNativeFunction(pkgName, functionName)) != null) {
            try {
                result = (NativeCallableUnit)Class.forName(functionDef.getClassName()).newInstance();
                this.nativeUnitsCache.put(key, result);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                throw new RuntimeException("Error in loading native function: " + e.getMessage(), e);
            }
        }
        return result;
    }

    public String loadNativeFunctionClassName(String pkgName, String functionName) {
        String result = null;
        NativeElementRepository.NativeFunctionDef functionDef = this.nativeElementRepo.lookupNativeFunction(pkgName, functionName);
        if (functionDef != null) {
            result = functionDef.getClassName().replaceAll("\\.", "\\/");
        }
        return result;
    }

    public NativeCallableUnit loadNativeAction(String pkgName, String connectorName, String actionName) {
        NativeElementRepository.NativeActionDef actionDef;
        String key = NativeElementRepository.actionToKey((String)pkgName, (String)connectorName, (String)actionName);
        NativeCallableUnit result = this.nativeUnitsCache.get(key);
        if (result == null && (actionDef = this.nativeElementRepo.lookupNativeAction(pkgName, connectorName, actionName)) != null) {
            try {
                result = (NativeCallableUnit)Class.forName(actionDef.getClassName()).newInstance();
                this.nativeUnitsCache.put(key, result);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                throw new RuntimeException("Error in loading native action: " + e.getMessage(), e);
            }
        }
        return result;
    }
}

