/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.persistence;

import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import org.ballerinalang.model.util.serializer.BValueProvider;
import org.ballerinalang.model.util.serializer.InstanceProviderRegistry;
import org.ballerinalang.model.util.serializer.JsonSerializer;
import org.ballerinalang.model.values.BBoolean;
import org.ballerinalang.model.values.BByte;
import org.ballerinalang.model.values.BFloat;
import org.ballerinalang.model.values.BInteger;
import org.ballerinalang.model.values.BString;
import org.ballerinalang.model.values.BXMLItem;
import org.ballerinalang.model.values.BXMLQName;
import org.ballerinalang.model.values.BXMLSequence;
import org.ballerinalang.persistence.serializable.serializer.providers.bvalue.SerializedKeyBValueProvider;
import org.ballerinalang.persistence.serializable.serializer.providers.instance.SerializableBRefArrayInstanceProvider;
import org.ballerinalang.persistence.serializable.serializer.providers.instance.SerializableContextInstanceProvider;
import org.ballerinalang.persistence.serializable.serializer.providers.instance.SerializableWorkerDataInstanceProvider;
import org.ballerinalang.persistence.serializable.serializer.providers.instance.WorkerStateInstanceProvider;

public class Serializer {
    private static final List<String> serializableClasses = new ArrayList<String>();
    private static final JsonSerializer JSON_SERIALIZER = new JsonSerializer();
    private static final BValueProvider BVALUE_PROVIDER_REGISTRY = JSON_SERIALIZER.getBValueProviderRegistry();
    private static final InstanceProviderRegistry INSTANCE_PROVIDER_REGISTRY = JSON_SERIALIZER.getInstanceProviderRegistry();

    public static boolean isSerializable(Object o) {
        if (o == null) {
            return true;
        }
        return serializableClasses.contains(o.getClass().getName());
    }

    public static JsonSerializer getJsonSerializer() {
        return JSON_SERIALIZER;
    }

    static {
        serializableClasses.add(String.class.getName());
        serializableClasses.add(Integer.class.getName());
        serializableClasses.add(Long.class.getName());
        serializableClasses.add(Double.class.getName());
        serializableClasses.add(Float.class.getName());
        serializableClasses.add(Boolean.class.getName());
        serializableClasses.add(byte[].class.getName());
        serializableClasses.add(InetSocketAddress.class.getName());
        serializableClasses.add(BString.class.getName());
        serializableClasses.add(BInteger.class.getName());
        serializableClasses.add(BBoolean.class.getName());
        serializableClasses.add(BFloat.class.getName());
        serializableClasses.add(BByte.class.getName());
        serializableClasses.add(BXMLItem.class.getName());
        serializableClasses.add(BXMLQName.class.getName());
        serializableClasses.add(BXMLSequence.class.getName());
        BVALUE_PROVIDER_REGISTRY.register(new SerializedKeyBValueProvider());
        INSTANCE_PROVIDER_REGISTRY.add(new SerializableWorkerDataInstanceProvider());
        INSTANCE_PROVIDER_REGISTRY.add(new SerializableContextInstanceProvider());
        INSTANCE_PROVIDER_REGISTRY.add(new WorkerStateInstanceProvider());
        INSTANCE_PROVIDER_REGISTRY.add(new SerializableBRefArrayInstanceProvider());
    }
}

