/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.persistence.serializable;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ballerinalang.bre.old.CallableWorkerResponseContext;
import org.ballerinalang.bre.old.WorkerExecutionContext;
import org.ballerinalang.model.util.serializer.JsonSerializer;
import org.ballerinalang.model.values.BRefType;
import org.ballerinalang.persistence.Deserializer;
import org.ballerinalang.persistence.Serializer;
import org.ballerinalang.persistence.serializable.SerializableContext;
import org.ballerinalang.persistence.serializable.SerializableRespContext;
import org.ballerinalang.persistence.serializable.SerializedKey;
import org.ballerinalang.persistence.serializable.reftypes.Serializable;
import org.ballerinalang.persistence.serializable.reftypes.SerializableRefType;
import org.ballerinalang.util.codegen.CallableUnitInfo;
import org.ballerinalang.util.codegen.ProgramFile;

public class SerializableState {
    private String id;
    private String currentContextKey;
    private Map<String, SerializableContext> sContexts = new HashMap<String, SerializableContext>();
    private Map<String, SerializableRespContext> sRespContexts = new HashMap<String, SerializableRespContext>();
    private Map<String, SerializableRefType> sRefTypes = new HashMap<String, SerializableRefType>();
    public HashMap<String, Object> globalProps = new HashMap();

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public static SerializableState deserialize(String json) {
        JsonSerializer jsonSerializer = Serializer.getJsonSerializer();
        return jsonSerializer.deserialize(json, SerializableState.class);
    }

    public SerializableState(WorkerExecutionContext executionContext, int ip) {
        if (executionContext == null) {
            return;
        }
        this.currentContextKey = String.valueOf(executionContext.hashCode());
        SerializableContext serializableContext = new SerializableContext(this.currentContextKey, executionContext, this, ip);
        this.sContexts.put(this.currentContextKey, serializableContext);
    }

    public String serialize() {
        return Serializer.getJsonSerializer().serialize(this);
    }

    public WorkerExecutionContext getExecutionContext(ProgramFile programFile, Deserializer deserializer) {
        SerializableContext serializableContext = this.sContexts.get(this.currentContextKey);
        return serializableContext.getWorkerExecutionContext(programFile, this, deserializer);
    }

    public String addContext(WorkerExecutionContext context, int ip) {
        if (context == null) {
            return null;
        }
        String contextKey = String.valueOf(context.hashCode());
        if (!this.sContexts.containsKey(contextKey)) {
            SerializableContext serializableContext = new SerializableContext(contextKey, context, this, ip);
            this.sContexts.put(contextKey, serializableContext);
        }
        return contextKey;
    }

    public WorkerExecutionContext getContext(String contextKey, ProgramFile programFile, Deserializer deserializer) {
        SerializableContext serializableContext = this.sContexts.get(contextKey);
        return serializableContext.getWorkerExecutionContext(programFile, this, deserializer);
    }

    public String addRespContext(CallableWorkerResponseContext responseContext) {
        if (responseContext == null) {
            return null;
        }
        String key = String.valueOf(responseContext.hashCode());
        if (!this.sRespContexts.containsKey(key)) {
            SerializableRespContext serializableRespContext = new SerializableRespContext(key, responseContext, this);
            this.sRespContexts.put(key, serializableRespContext);
        }
        return key;
    }

    public CallableWorkerResponseContext getResponseContext(String respCtxKey, ProgramFile programFile, CallableUnitInfo callableUnitInfo, Deserializer deserializer) {
        CallableWorkerResponseContext responseContext = deserializer.getRespContexts().get(respCtxKey);
        if (responseContext != null) {
            return responseContext;
        }
        SerializableRespContext serializableRespContext = this.sRespContexts.get(respCtxKey);
        responseContext = serializableRespContext.getResponseContext(programFile, callableUnitInfo, this, deserializer);
        deserializer.getRespContexts().put(respCtxKey, responseContext);
        return responseContext;
    }

    public ArrayList<Object> serializeRefFields(BRefType[] bRefFields) {
        if (bRefFields == null) {
            return null;
        }
        ArrayList<Object> refFields = new ArrayList<Object>(bRefFields.length);
        for (int i = 0; i < bRefFields.length; ++i) {
            BRefType refType = bRefFields[i];
            refFields.add(i, this.serialize(refType));
        }
        return refFields;
    }

    public BRefType[] deserializeRefFields(List<Object> sRefFields, ProgramFile programFile, Deserializer deserializer) {
        if (sRefFields == null) {
            return null;
        }
        BRefType[] bRefFields = new BRefType[sRefFields.size()];
        for (int i = 0; i < sRefFields.size(); ++i) {
            Object s = sRefFields.get(i);
            bRefFields[i] = (BRefType)this.deserialize(s, programFile, deserializer);
        }
        return bRefFields;
    }

    public Object serialize(Object o) {
        if (o == null || Serializer.isSerializable(o)) {
            return o;
        }
        if (o instanceof Serializable) {
            return this.addRefType((Serializable)o);
        }
        return null;
    }

    public Object deserialize(Object o, ProgramFile programFile, Deserializer deserializer) {
        if (o instanceof SerializedKey) {
            SerializedKey key = (SerializedKey)o;
            BRefType bRefType = deserializer.getRefTypes().get(key.key);
            if (bRefType != null) {
                return bRefType;
            }
            SerializableRefType sRefType = this.sRefTypes.get(key.key);
            bRefType = sRefType.getBRefType(programFile, this, deserializer);
            deserializer.getRefTypes().put(key.key, bRefType);
            return bRefType;
        }
        return o;
    }

    private SerializedKey addRefType(Serializable serializable) {
        String refKey = String.valueOf(serializable.hashCode());
        if (this.sRefTypes.containsKey(refKey)) {
            return new SerializedKey(refKey);
        }
        SerializableRefType sRefType = serializable.serialize(this);
        if (sRefType != null) {
            this.sRefTypes.put(refKey, sRefType);
            return new SerializedKey(refKey);
        }
        return null;
    }
}

