/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.persistence.serializable.reftypes.impl;

import java.util.HashMap;
import org.ballerinalang.model.values.BMap;
import org.ballerinalang.model.values.BRefType;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.persistence.Deserializer;
import org.ballerinalang.persistence.serializable.SerializableState;
import org.ballerinalang.persistence.serializable.reftypes.SerializableRefType;
import org.ballerinalang.util.codegen.PackageInfo;
import org.ballerinalang.util.codegen.ProgramFile;
import org.ballerinalang.util.codegen.StructureTypeInfo;
import org.ballerinalang.util.exceptions.BallerinaException;

public class SerializableBMap<K, V extends BValue>
implements SerializableRefType {
    private String pkgPath;
    private String structName;
    private HashMap<K, Object> map = new HashMap();
    private HashMap<String, Object> nativeData = new HashMap();

    public SerializableBMap(BMap<K, V> bMap, SerializableState state) {
        this.structName = bMap.getType().getName();
        this.pkgPath = bMap.getType().getPackagePath();
        bMap.getNativeData().forEach((k, o) -> this.nativeData.put((String)k, state.serialize(o)));
        bMap.getMap().forEach((k, v) -> this.map.put(k, state.serialize(v)));
    }

    @Override
    public BRefType getBRefType(ProgramFile programFile, SerializableState state, Deserializer deserializer) {
        BMap bMap;
        PackageInfo packageInfo = programFile.getPackageInfo(this.pkgPath);
        if (packageInfo != null) {
            StructureTypeInfo structInfo = packageInfo.getStructInfo(this.structName);
            if (structInfo == null) {
                throw new BallerinaException(this.structName + " not found in module " + this.pkgPath);
            }
            bMap = new BMap(structInfo.getType());
        } else {
            bMap = new BMap();
        }
        this.nativeData.forEach((s, o) -> bMap.addNativeData((String)s, state.deserialize(o, programFile, deserializer)));
        this.map.forEach((k, v) -> bMap.put(k, (BValue)state.deserialize(v, programFile, deserializer)));
        return bMap;
    }
}

